/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.AnomalySubscription;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse;

public class GetAnomalySubscriptionsPublisher
implements SdkPublisher<GetAnomalySubscriptionsResponse> {
    private final CostExplorerAsyncClient client;
    private final GetAnomalySubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAnomalySubscriptionsPublisher(CostExplorerAsyncClient client, GetAnomalySubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAnomalySubscriptionsPublisher(CostExplorerAsyncClient client, GetAnomalySubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAnomalySubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAnomalySubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnomalySubscription> anomalySubscriptions() {
        Function<GetAnomalySubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalySubscriptions() != null) {
                return response.anomalySubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAnomalySubscriptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAnomalySubscriptionsResponseFetcher
    implements AsyncPageFetcher<GetAnomalySubscriptionsResponse> {
        private GetAnomalySubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(GetAnomalySubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetAnomalySubscriptionsResponse> nextPage(GetAnomalySubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return GetAnomalySubscriptionsPublisher.this.client.getAnomalySubscriptions(GetAnomalySubscriptionsPublisher.this.firstRequest);
            }
            return GetAnomalySubscriptionsPublisher.this.client.getAnomalySubscriptions((GetAnomalySubscriptionsRequest)((Object)GetAnomalySubscriptionsPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

