/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnomalyMonitorResponse extends CostExplorerResponse implements
        ToCopyableBuilder<CreateAnomalyMonitorResponse.Builder, CreateAnomalyMonitorResponse> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitorArn").getter(getter(CreateAnomalyMonitorResponse::monitorArn))
            .setter(setter(Builder::monitorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String monitorArn;

    private CreateAnomalyMonitorResponse(BuilderImpl builder) {
        super(builder);
        this.monitorArn = builder.monitorArn;
    }

    /**
     * <p>
     * The unique identifier of your newly created cost anomaly detection monitor.
     * </p>
     * 
     * @return The unique identifier of your newly created cost anomaly detection monitor.
     */
    public final String monitorArn() {
        return monitorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalyMonitorResponse)) {
            return false;
        }
        CreateAnomalyMonitorResponse other = (CreateAnomalyMonitorResponse) obj;
        return Objects.equals(monitorArn(), other.monitorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnomalyMonitorResponse").add("MonitorArn", monitorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitorArn":
            return Optional.ofNullable(clazz.cast(monitorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitorArn", MONITOR_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalyMonitorResponse, T> g) {
        return obj -> g.apply((CreateAnomalyMonitorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAnomalyMonitorResponse> {
        /**
         * <p>
         * The unique identifier of your newly created cost anomaly detection monitor.
         * </p>
         * 
         * @param monitorArn
         *        The unique identifier of your newly created cost anomaly detection monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorArn(String monitorArn);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String monitorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalyMonitorResponse model) {
            super(model);
            monitorArn(model.monitorArn);
        }

        public final String getMonitorArn() {
            return monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        @Override
        public CreateAnomalyMonitorResponse build() {
            return new CreateAnomalyMonitorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
