/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCostAndUsageResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetCostAndUsageResponse.Builder, GetCostAndUsageResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetCostAndUsageResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<List<GroupDefinition>> GROUP_DEFINITIONS_FIELD = SdkField
            .<List<GroupDefinition>> builder(MarshallingType.LIST)
            .memberName("GroupDefinitions")
            .getter(getter(GetCostAndUsageResponse::groupDefinitions))
            .setter(setter(Builder::groupDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResultByTime>> RESULTS_BY_TIME_FIELD = SdkField
            .<List<ResultByTime>> builder(MarshallingType.LIST)
            .memberName("ResultsByTime")
            .getter(getter(GetCostAndUsageResponse::resultsByTime))
            .setter(setter(Builder::resultsByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsByTime").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultByTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultByTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionValuesWithAttributes>> DIMENSION_VALUE_ATTRIBUTES_FIELD = SdkField
            .<List<DimensionValuesWithAttributes>> builder(MarshallingType.LIST)
            .memberName("DimensionValueAttributes")
            .getter(getter(GetCostAndUsageResponse::dimensionValueAttributes))
            .setter(setter(Builder::dimensionValueAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionValuesWithAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionValuesWithAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD,
            GROUP_DEFINITIONS_FIELD, RESULTS_BY_TIME_FIELD, DIMENSION_VALUE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextPageToken;

    private final List<GroupDefinition> groupDefinitions;

    private final List<ResultByTime> resultsByTime;

    private final List<DimensionValuesWithAttributes> dimensionValueAttributes;

    private GetCostAndUsageResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.groupDefinitions = builder.groupDefinitions;
        this.resultsByTime = builder.resultsByTime;
        this.dimensionValueAttributes = builder.dimensionValueAttributes;
    }

    /**
     * <p>
     * The token for the next set of retrievable results. Amazon Web Services provides the token when the response from
     * a previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token for the next set of retrievable results. Amazon Web Services provides the token when the
     *         response from a previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupDefinitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupDefinitions() {
        return groupDefinitions != null && !(groupDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupDefinitions} method.
     * </p>
     * 
     * @return The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the
     *         request.
     */
    public final List<GroupDefinition> groupDefinitions() {
        return groupDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultsByTime property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultsByTime() {
        return resultsByTime != null && !(resultsByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The time period that's covered by the results in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultsByTime} method.
     * </p>
     * 
     * @return The time period that's covered by the results in the response.
     */
    public final List<ResultByTime> resultsByTime() {
        return resultsByTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionValueAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDimensionValueAttributes() {
        return dimensionValueAttributes != null && !(dimensionValueAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes that apply to a specific dimension value. For example, if the value is a linked account, the
     * attribute is that account name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionValueAttributes} method.
     * </p>
     * 
     * @return The attributes that apply to a specific dimension value. For example, if the value is a linked account,
     *         the attribute is that account name.
     */
    public final List<DimensionValuesWithAttributes> dimensionValueAttributes() {
        return dimensionValueAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupDefinitions() ? groupDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResultsByTime() ? resultsByTime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionValueAttributes() ? dimensionValueAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostAndUsageResponse)) {
            return false;
        }
        GetCostAndUsageResponse other = (GetCostAndUsageResponse) obj;
        return Objects.equals(nextPageToken(), other.nextPageToken()) && hasGroupDefinitions() == other.hasGroupDefinitions()
                && Objects.equals(groupDefinitions(), other.groupDefinitions()) && hasResultsByTime() == other.hasResultsByTime()
                && Objects.equals(resultsByTime(), other.resultsByTime())
                && hasDimensionValueAttributes() == other.hasDimensionValueAttributes()
                && Objects.equals(dimensionValueAttributes(), other.dimensionValueAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCostAndUsageResponse").add("NextPageToken", nextPageToken())
                .add("GroupDefinitions", hasGroupDefinitions() ? groupDefinitions() : null)
                .add("ResultsByTime", hasResultsByTime() ? resultsByTime() : null)
                .add("DimensionValueAttributes", hasDimensionValueAttributes() ? dimensionValueAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "GroupDefinitions":
            return Optional.ofNullable(clazz.cast(groupDefinitions()));
        case "ResultsByTime":
            return Optional.ofNullable(clazz.cast(resultsByTime()));
        case "DimensionValueAttributes":
            return Optional.ofNullable(clazz.cast(dimensionValueAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        map.put("GroupDefinitions", GROUP_DEFINITIONS_FIELD);
        map.put("ResultsByTime", RESULTS_BY_TIME_FIELD);
        map.put("DimensionValueAttributes", DIMENSION_VALUE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostAndUsageResponse, T> g) {
        return obj -> g.apply((GetCostAndUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCostAndUsageResponse> {
        /**
         * <p>
         * The token for the next set of retrievable results. Amazon Web Services provides the token when the response
         * from a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token for the next set of retrievable results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.
         * </p>
         * 
         * @param groupDefinitions
         *        The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDefinitions(Collection<GroupDefinition> groupDefinitions);

        /**
         * <p>
         * The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.
         * </p>
         * 
         * @param groupDefinitions
         *        The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDefinitions(GroupDefinition... groupDefinitions);

        /**
         * <p>
         * The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #groupDefinitions(List<GroupDefinition>)}.
         * 
         * @param groupDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupDefinitions(java.util.Collection<GroupDefinition>)
         */
        Builder groupDefinitions(Consumer<GroupDefinition.Builder>... groupDefinitions);

        /**
         * <p>
         * The time period that's covered by the results in the response.
         * </p>
         * 
         * @param resultsByTime
         *        The time period that's covered by the results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsByTime(Collection<ResultByTime> resultsByTime);

        /**
         * <p>
         * The time period that's covered by the results in the response.
         * </p>
         * 
         * @param resultsByTime
         *        The time period that's covered by the results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsByTime(ResultByTime... resultsByTime);

        /**
         * <p>
         * The time period that's covered by the results in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.ResultByTime.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.costexplorer.model.ResultByTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.ResultByTime.Builder#build()} is called immediately
         * and its result is passed to {@link #resultsByTime(List<ResultByTime>)}.
         * 
         * @param resultsByTime
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.ResultByTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultsByTime(java.util.Collection<ResultByTime>)
         */
        Builder resultsByTime(Consumer<ResultByTime.Builder>... resultsByTime);

        /**
         * <p>
         * The attributes that apply to a specific dimension value. For example, if the value is a linked account, the
         * attribute is that account name.
         * </p>
         * 
         * @param dimensionValueAttributes
         *        The attributes that apply to a specific dimension value. For example, if the value is a linked
         *        account, the attribute is that account name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValueAttributes(Collection<DimensionValuesWithAttributes> dimensionValueAttributes);

        /**
         * <p>
         * The attributes that apply to a specific dimension value. For example, if the value is a linked account, the
         * attribute is that account name.
         * </p>
         * 
         * @param dimensionValueAttributes
         *        The attributes that apply to a specific dimension value. For example, if the value is a linked
         *        account, the attribute is that account name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValueAttributes(DimensionValuesWithAttributes... dimensionValueAttributes);

        /**
         * <p>
         * The attributes that apply to a specific dimension value. For example, if the value is a linked account, the
         * attribute is that account name.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #dimensionValueAttributes(List<DimensionValuesWithAttributes>)}.
         * 
         * @param dimensionValueAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionValueAttributes(java.util.Collection<DimensionValuesWithAttributes>)
         */
        Builder dimensionValueAttributes(Consumer<DimensionValuesWithAttributes.Builder>... dimensionValueAttributes);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String nextPageToken;

        private List<GroupDefinition> groupDefinitions = DefaultSdkAutoConstructList.getInstance();

        private List<ResultByTime> resultsByTime = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionValuesWithAttributes> dimensionValueAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostAndUsageResponse model) {
            super(model);
            nextPageToken(model.nextPageToken);
            groupDefinitions(model.groupDefinitions);
            resultsByTime(model.resultsByTime);
            dimensionValueAttributes(model.dimensionValueAttributes);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final List<GroupDefinition.Builder> getGroupDefinitions() {
            List<GroupDefinition.Builder> result = GroupDefinitionsCopier.copyToBuilder(this.groupDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupDefinitions(Collection<GroupDefinition.BuilderImpl> groupDefinitions) {
            this.groupDefinitions = GroupDefinitionsCopier.copyFromBuilder(groupDefinitions);
        }

        @Override
        public final Builder groupDefinitions(Collection<GroupDefinition> groupDefinitions) {
            this.groupDefinitions = GroupDefinitionsCopier.copy(groupDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDefinitions(GroupDefinition... groupDefinitions) {
            groupDefinitions(Arrays.asList(groupDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDefinitions(Consumer<GroupDefinition.Builder>... groupDefinitions) {
            groupDefinitions(Stream.of(groupDefinitions).map(c -> GroupDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResultByTime.Builder> getResultsByTime() {
            List<ResultByTime.Builder> result = ResultsByTimeCopier.copyToBuilder(this.resultsByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultsByTime(Collection<ResultByTime.BuilderImpl> resultsByTime) {
            this.resultsByTime = ResultsByTimeCopier.copyFromBuilder(resultsByTime);
        }

        @Override
        public final Builder resultsByTime(Collection<ResultByTime> resultsByTime) {
            this.resultsByTime = ResultsByTimeCopier.copy(resultsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(ResultByTime... resultsByTime) {
            resultsByTime(Arrays.asList(resultsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(Consumer<ResultByTime.Builder>... resultsByTime) {
            resultsByTime(Stream.of(resultsByTime).map(c -> ResultByTime.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionValuesWithAttributes.Builder> getDimensionValueAttributes() {
            List<DimensionValuesWithAttributes.Builder> result = DimensionValuesWithAttributesListCopier
                    .copyToBuilder(this.dimensionValueAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionValueAttributes(
                Collection<DimensionValuesWithAttributes.BuilderImpl> dimensionValueAttributes) {
            this.dimensionValueAttributes = DimensionValuesWithAttributesListCopier.copyFromBuilder(dimensionValueAttributes);
        }

        @Override
        public final Builder dimensionValueAttributes(Collection<DimensionValuesWithAttributes> dimensionValueAttributes) {
            this.dimensionValueAttributes = DimensionValuesWithAttributesListCopier.copy(dimensionValueAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueAttributes(DimensionValuesWithAttributes... dimensionValueAttributes) {
            dimensionValueAttributes(Arrays.asList(dimensionValueAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueAttributes(Consumer<DimensionValuesWithAttributes.Builder>... dimensionValueAttributes) {
            dimensionValueAttributes(Stream.of(dimensionValueAttributes)
                    .map(c -> DimensionValuesWithAttributes.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCostAndUsageResponse build() {
            return new GetCostAndUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
