/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCostForecastRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetCostForecastRequest.Builder, GetCostForecastRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(GetCostForecastRequest::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Metric")
            .getter(getter(GetCostForecastRequest::metricAsString)).setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(GetCostForecastRequest::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetCostForecastRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> BILLING_VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingViewArn").getter(getter(GetCostForecastRequest::billingViewArn))
            .setter(setter(Builder::billingViewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingViewArn").build()).build();

    private static final SdkField<Integer> PREDICTION_INTERVAL_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PredictionIntervalLevel").getter(getter(GetCostForecastRequest::predictionIntervalLevel))
            .setter(setter(Builder::predictionIntervalLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionIntervalLevel").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            METRIC_FIELD, GRANULARITY_FIELD, FILTER_FIELD, BILLING_VIEW_ARN_FIELD, PREDICTION_INTERVAL_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DateInterval timePeriod;

    private final String metric;

    private final String granularity;

    private final Expression filter;

    private final String billingViewArn;

    private final Integer predictionIntervalLevel;

    private GetCostForecastRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.metric = builder.metric;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
        this.billingViewArn = builder.billingViewArn;
        this.predictionIntervalLevel = builder.predictionIntervalLevel;
    }

    /**
     * <p>
     * The period of time that you want the forecast to cover. The start date must be equal to or no later than the
     * current date to avoid a validation error.
     * </p>
     * 
     * @return The period of time that you want the forecast to cover. The start date must be equal to or no later than
     *         the current date to avoid a validation error.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates,
     * see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended"
     * annotation appear on some line items in my bill?</a>.
     * </p>
     * <p>
     * Valid values for a <code>GetCostForecast</code> call are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AMORTIZED_COST
     * </p>
     * </li>
     * <li>
     * <p>
     * BLENDED_COST
     * </p>
     * </li>
     * <li>
     * <p>
     * NET_AMORTIZED_COST
     * </p>
     * </li>
     * <li>
     * <p>
     * NET_UNBLENDED_COST
     * </p>
     * </li>
     * <li>
     * <p>
     * UNBLENDED_COST
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link Metric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended
     *         rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does
     *         the "blended" annotation appear on some line items in my bill?</a>. </p>
     *         <p>
     *         Valid values for a <code>GetCostForecast</code> call are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AMORTIZED_COST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BLENDED_COST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NET_AMORTIZED_COST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NET_UNBLENDED_COST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNBLENDED_COST
     *         </p>
     *         </li>
     * @see Metric
     */
    public final Metric metric() {
        return Metric.fromValue(metric);
    }

    /**
     * <p>
     * Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates,
     * see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended"
     * annotation appear on some line items in my bill?</a>.
     * </p>
     * <p>
     * Valid values for a <code>GetCostForecast</code> call are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AMORTIZED_COST
     * </p>
     * </li>
     * <li>
     * <p>
     * BLENDED_COST
     * </p>
     * </li>
     * <li>
     * <p>
     * NET_AMORTIZED_COST
     * </p>
     * </li>
     * <li>
     * <p>
     * NET_UNBLENDED_COST
     * </p>
     * </li>
     * <li>
     * <p>
     * UNBLENDED_COST
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link Metric#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended
     *         rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does
     *         the "blended" annotation appear on some line items in my bill?</a>. </p>
     *         <p>
     *         Valid values for a <code>GetCostForecast</code> call are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AMORTIZED_COST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BLENDED_COST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NET_AMORTIZED_COST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NET_UNBLENDED_COST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNBLENDED_COST
     *         </p>
     *         </li>
     * @see Metric
     */
    public final String metricAsString() {
        return metric;
    }

    /**
     * <p>
     * How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of
     * <code>MONTHLY</code> forecasts.
     * </p>
     * <p>
     * The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12
     *         months of <code>MONTHLY</code> forecasts.</p>
     *         <p>
     *         The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     *         granularities.
     * @see Granularity
     */
    public final Granularity granularity() {
        return Granularity.fromValue(granularity);
    }

    /**
     * <p>
     * How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of
     * <code>MONTHLY</code> forecasts.
     * </p>
     * <p>
     * The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12
     *         months of <code>MONTHLY</code> forecasts.</p>
     *         <p>
     *         The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     *         granularities.
     * @see Granularity
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * <p>
     * The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports filtering
     * by the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AZ</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPERATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PURCHASE_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>USAGE_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>USAGE_TYPE_GROUP</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RECORD_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OPERATING_SYSTEM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TENANCY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCOPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLATFORM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBSCRIPTION_ID</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LEGAL_ENTITY_NAME</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPLOYMENT_OPTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DATABASE_ENGINE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_TYPE_FAMILY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BILLING_ENTITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESERVATION_ID</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_PLAN_ARN</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports
     *         filtering by the following dimensions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AZ</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LINKED_ACCOUNT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPERATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PURCHASE_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>USAGE_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>USAGE_TYPE_GROUP</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RECORD_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OPERATING_SYSTEM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TENANCY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCOPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLATFORM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBSCRIPTION_ID</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LEGAL_ENTITY_NAME</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPLOYMENT_OPTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DATABASE_ENGINE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE_TYPE_FAMILY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BILLING_ENTITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESERVATION_ID</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_PLAN_ARN</code>
     *         </p>
     *         </li>
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to specify which
     * particular billing view you want to interact with or retrieve information from when making API calls related to
     * Amazon Web Services Billing and Cost Management features. The BillingViewArn can be retrieved by calling the
     * ListBillingViews API.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to
     *         specify which particular billing view you want to interact with or retrieve information from when making
     *         API calls related to Amazon Web Services Billing and Cost Management features. The BillingViewArn can be
     *         retrieved by calling the ListBillingViews API.
     */
    public final String billingViewArn() {
        return billingViewArn;
    }

    /**
     * <p>
     * Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around
     * the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is
     * about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction
     * intervals.
     * </p>
     * 
     * @return Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval
     *         around the mean by specifying a confidence level. The higher the confidence level, the more confident
     *         Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels
     *         result in wider prediction intervals.
     */
    public final Integer predictionIntervalLevel() {
        return predictionIntervalLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(billingViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(predictionIntervalLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostForecastRequest)) {
            return false;
        }
        GetCostForecastRequest other = (GetCostForecastRequest) obj;
        return Objects.equals(timePeriod(), other.timePeriod()) && Objects.equals(metricAsString(), other.metricAsString())
                && Objects.equals(granularityAsString(), other.granularityAsString()) && Objects.equals(filter(), other.filter())
                && Objects.equals(billingViewArn(), other.billingViewArn())
                && Objects.equals(predictionIntervalLevel(), other.predictionIntervalLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCostForecastRequest").add("TimePeriod", timePeriod()).add("Metric", metricAsString())
                .add("Granularity", granularityAsString()).add("Filter", filter()).add("BillingViewArn", billingViewArn())
                .add("PredictionIntervalLevel", predictionIntervalLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metricAsString()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "BillingViewArn":
            return Optional.ofNullable(clazz.cast(billingViewArn()));
        case "PredictionIntervalLevel":
            return Optional.ofNullable(clazz.cast(predictionIntervalLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("Metric", METRIC_FIELD);
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("BillingViewArn", BILLING_VIEW_ARN_FIELD);
        map.put("PredictionIntervalLevel", PREDICTION_INTERVAL_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostForecastRequest, T> g) {
        return obj -> g.apply((GetCostForecastRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCostForecastRequest> {
        /**
         * <p>
         * The period of time that you want the forecast to cover. The start date must be equal to or no later than the
         * current date to avoid a validation error.
         * </p>
         * 
         * @param timePeriod
         *        The period of time that you want the forecast to cover. The start date must be equal to or no later
         *        than the current date to avoid a validation error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The period of time that you want the forecast to cover. The start date must be equal to or no later than the
         * current date to avoid a validation error.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended
         * rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the
         * "blended" annotation appear on some line items in my bill?</a>.
         * </p>
         * <p>
         * Valid values for a <code>GetCostForecast</code> call are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AMORTIZED_COST
         * </p>
         * </li>
         * <li>
         * <p>
         * BLENDED_COST
         * </p>
         * </li>
         * <li>
         * <p>
         * NET_AMORTIZED_COST
         * </p>
         * </li>
         * <li>
         * <p>
         * NET_UNBLENDED_COST
         * </p>
         * </li>
         * <li>
         * <p>
         * UNBLENDED_COST
         * </p>
         * </li>
         * </ul>
         * 
         * @param metric
         *        Which metric Cost Explorer uses to create your forecast. For more information about blended and
         *        unblended rates, see <a
         *        href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the
         *        "blended" annotation appear on some line items in my bill?</a>. </p>
         *        <p>
         *        Valid values for a <code>GetCostForecast</code> call are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AMORTIZED_COST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BLENDED_COST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NET_AMORTIZED_COST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NET_UNBLENDED_COST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNBLENDED_COST
         *        </p>
         *        </li>
         * @see Metric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Metric
         */
        Builder metric(String metric);

        /**
         * <p>
         * Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended
         * rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the
         * "blended" annotation appear on some line items in my bill?</a>.
         * </p>
         * <p>
         * Valid values for a <code>GetCostForecast</code> call are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AMORTIZED_COST
         * </p>
         * </li>
         * <li>
         * <p>
         * BLENDED_COST
         * </p>
         * </li>
         * <li>
         * <p>
         * NET_AMORTIZED_COST
         * </p>
         * </li>
         * <li>
         * <p>
         * NET_UNBLENDED_COST
         * </p>
         * </li>
         * <li>
         * <p>
         * UNBLENDED_COST
         * </p>
         * </li>
         * </ul>
         * 
         * @param metric
         *        Which metric Cost Explorer uses to create your forecast. For more information about blended and
         *        unblended rates, see <a
         *        href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the
         *        "blended" annotation appear on some line items in my bill?</a>. </p>
         *        <p>
         *        Valid values for a <code>GetCostForecast</code> call are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AMORTIZED_COST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BLENDED_COST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NET_AMORTIZED_COST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NET_UNBLENDED_COST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNBLENDED_COST
         *        </p>
         *        </li>
         * @see Metric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Metric
         */
        Builder metric(Metric metric);

        /**
         * <p>
         * How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months
         * of <code>MONTHLY</code> forecasts.
         * </p>
         * <p>
         * The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
         * granularities.
         * </p>
         * 
         * @param granularity
         *        How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12
         *        months of <code>MONTHLY</code> forecasts.</p>
         *        <p>
         *        The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
         *        granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months
         * of <code>MONTHLY</code> forecasts.
         * </p>
         * <p>
         * The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
         * granularities.
         * </p>
         * 
         * @param granularity
         *        How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12
         *        months of <code>MONTHLY</code> forecasts.</p>
         *        <p>
         *        The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
         *        granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(Granularity granularity);

        /**
         * <p>
         * The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports
         * filtering by the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AZ</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPERATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PURCHASE_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>USAGE_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>USAGE_TYPE_GROUP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RECORD_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPERATING_SYSTEM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TENANCY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCOPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLATFORM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBSCRIPTION_ID</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LEGAL_ENTITY_NAME</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPLOYMENT_OPTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DATABASE_ENGINE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE_FAMILY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BILLING_ENTITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESERVATION_ID</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLAN_ARN</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API
         *        supports filtering by the following dimensions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AZ</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LINKED_ACCOUNT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPERATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PURCHASE_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>USAGE_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>USAGE_TYPE_GROUP</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RECORD_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OPERATING_SYSTEM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TENANCY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCOPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLATFORM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBSCRIPTION_ID</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LEGAL_ENTITY_NAME</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPLOYMENT_OPTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DATABASE_ENGINE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE_TYPE_FAMILY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BILLING_ENTITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESERVATION_ID</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_PLAN_ARN</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * <p>
         * The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports
         * filtering by the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AZ</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPERATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PURCHASE_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>USAGE_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>USAGE_TYPE_GROUP</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RECORD_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OPERATING_SYSTEM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TENANCY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCOPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLATFORM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBSCRIPTION_ID</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LEGAL_ENTITY_NAME</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPLOYMENT_OPTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DATABASE_ENGINE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE_FAMILY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BILLING_ENTITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESERVATION_ID</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLAN_ARN</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to specify
         * which particular billing view you want to interact with or retrieve information from when making API calls
         * related to Amazon Web Services Billing and Cost Management features. The BillingViewArn can be retrieved by
         * calling the ListBillingViews API.
         * </p>
         * 
         * @param billingViewArn
         *        The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to
         *        specify which particular billing view you want to interact with or retrieve information from when
         *        making API calls related to Amazon Web Services Billing and Cost Management features. The
         *        BillingViewArn can be retrieved by calling the ListBillingViews API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingViewArn(String billingViewArn);

        /**
         * <p>
         * Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval
         * around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost
         * Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in
         * wider prediction intervals.
         * </p>
         * 
         * @param predictionIntervalLevel
         *        Cost Explorer always returns the mean forecast as a single point. You can request a prediction
         *        interval around the mean by specifying a confidence level. The higher the confidence level, the more
         *        confident Cost Explorer is about the actual value falling in the prediction interval. Higher
         *        confidence levels result in wider prediction intervals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionIntervalLevel(Integer predictionIntervalLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private String metric;

        private String granularity;

        private Expression filter;

        private String billingViewArn;

        private Integer predictionIntervalLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostForecastRequest model) {
            super(model);
            timePeriod(model.timePeriod);
            metric(model.metric);
            granularity(model.granularity);
            filter(model.filter);
            billingViewArn(model.billingViewArn);
            predictionIntervalLevel(model.predictionIntervalLevel);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final String getBillingViewArn() {
            return billingViewArn;
        }

        public final void setBillingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
        }

        @Override
        public final Builder billingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        public final Integer getPredictionIntervalLevel() {
            return predictionIntervalLevel;
        }

        public final void setPredictionIntervalLevel(Integer predictionIntervalLevel) {
            this.predictionIntervalLevel = predictionIntervalLevel;
        }

        @Override
        public final Builder predictionIntervalLevel(Integer predictionIntervalLevel) {
            this.predictionIntervalLevel = predictionIntervalLevel;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCostForecastRequest build() {
            return new GetCostForecastRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
