/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the hourly metrics for the given recommendation over the lookback period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationDetailHourlyMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationDetailHourlyMetrics.Builder, RecommendationDetailHourlyMetrics> {
    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(RecommendationDetailHourlyMetrics::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedOnDemandCost").getter(getter(RecommendationDetailHourlyMetrics::estimatedOnDemandCost))
            .setter(setter(Builder::estimatedOnDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedOnDemandCost").build())
            .build();

    private static final SdkField<String> CURRENT_COVERAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentCoverage").getter(getter(RecommendationDetailHourlyMetrics::currentCoverage))
            .setter(setter(Builder::currentCoverage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentCoverage").build()).build();

    private static final SdkField<String> ESTIMATED_COVERAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimatedCoverage").getter(getter(RecommendationDetailHourlyMetrics::estimatedCoverage))
            .setter(setter(Builder::estimatedCoverage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCoverage").build()).build();

    private static final SdkField<String> ESTIMATED_NEW_COMMITMENT_UTILIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EstimatedNewCommitmentUtilization")
            .getter(getter(RecommendationDetailHourlyMetrics::estimatedNewCommitmentUtilization))
            .setter(setter(Builder::estimatedNewCommitmentUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedNewCommitmentUtilization")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            ESTIMATED_ON_DEMAND_COST_FIELD, CURRENT_COVERAGE_FIELD, ESTIMATED_COVERAGE_FIELD,
            ESTIMATED_NEW_COMMITMENT_UTILIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String startTime;

    private final String estimatedOnDemandCost;

    private final String currentCoverage;

    private final String estimatedCoverage;

    private final String estimatedNewCommitmentUtilization;

    private RecommendationDetailHourlyMetrics(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.currentCoverage = builder.currentCoverage;
        this.estimatedCoverage = builder.estimatedCoverage;
        this.estimatedNewCommitmentUtilization = builder.estimatedNewCommitmentUtilization;
    }

    /**
     * Returns the value of the StartTime property for this object.
     * 
     * @return The value of the StartTime property for this object.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The remaining On-Demand cost estimated to not be covered by the recommended Savings Plan, over the length of the
     * lookback period.
     * </p>
     * 
     * @return The remaining On-Demand cost estimated to not be covered by the recommended Savings Plan, over the length
     *         of the lookback period.
     */
    public final String estimatedOnDemandCost() {
        return estimatedOnDemandCost;
    }

    /**
     * <p>
     * The current amount of Savings Plans eligible usage that the Savings Plan covered.
     * </p>
     * 
     * @return The current amount of Savings Plans eligible usage that the Savings Plan covered.
     */
    public final String currentCoverage() {
        return currentCoverage;
    }

    /**
     * <p>
     * The estimated coverage amount based on the recommended Savings Plan.
     * </p>
     * 
     * @return The estimated coverage amount based on the recommended Savings Plan.
     */
    public final String estimatedCoverage() {
        return estimatedCoverage;
    }

    /**
     * <p>
     * The estimated utilization for the recommended Savings Plan.
     * </p>
     * 
     * @return The estimated utilization for the recommended Savings Plan.
     */
    public final String estimatedNewCommitmentUtilization() {
        return estimatedNewCommitmentUtilization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(currentCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedNewCommitmentUtilization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationDetailHourlyMetrics)) {
            return false;
        }
        RecommendationDetailHourlyMetrics other = (RecommendationDetailHourlyMetrics) obj;
        return Objects.equals(startTime(), other.startTime())
                && Objects.equals(estimatedOnDemandCost(), other.estimatedOnDemandCost())
                && Objects.equals(currentCoverage(), other.currentCoverage())
                && Objects.equals(estimatedCoverage(), other.estimatedCoverage())
                && Objects.equals(estimatedNewCommitmentUtilization(), other.estimatedNewCommitmentUtilization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationDetailHourlyMetrics").add("StartTime", startTime())
                .add("EstimatedOnDemandCost", estimatedOnDemandCost()).add("CurrentCoverage", currentCoverage())
                .add("EstimatedCoverage", estimatedCoverage())
                .add("EstimatedNewCommitmentUtilization", estimatedNewCommitmentUtilization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EstimatedOnDemandCost":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCost()));
        case "CurrentCoverage":
            return Optional.ofNullable(clazz.cast(currentCoverage()));
        case "EstimatedCoverage":
            return Optional.ofNullable(clazz.cast(estimatedCoverage()));
        case "EstimatedNewCommitmentUtilization":
            return Optional.ofNullable(clazz.cast(estimatedNewCommitmentUtilization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EstimatedOnDemandCost", ESTIMATED_ON_DEMAND_COST_FIELD);
        map.put("CurrentCoverage", CURRENT_COVERAGE_FIELD);
        map.put("EstimatedCoverage", ESTIMATED_COVERAGE_FIELD);
        map.put("EstimatedNewCommitmentUtilization", ESTIMATED_NEW_COMMITMENT_UTILIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationDetailHourlyMetrics, T> g) {
        return obj -> g.apply((RecommendationDetailHourlyMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationDetailHourlyMetrics> {
        /**
         * Sets the value of the StartTime property for this object.
         *
         * @param startTime
         *        The new value for the StartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The remaining On-Demand cost estimated to not be covered by the recommended Savings Plan, over the length of
         * the lookback period.
         * </p>
         * 
         * @param estimatedOnDemandCost
         *        The remaining On-Demand cost estimated to not be covered by the recommended Savings Plan, over the
         *        length of the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCost(String estimatedOnDemandCost);

        /**
         * <p>
         * The current amount of Savings Plans eligible usage that the Savings Plan covered.
         * </p>
         * 
         * @param currentCoverage
         *        The current amount of Savings Plans eligible usage that the Savings Plan covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentCoverage(String currentCoverage);

        /**
         * <p>
         * The estimated coverage amount based on the recommended Savings Plan.
         * </p>
         * 
         * @param estimatedCoverage
         *        The estimated coverage amount based on the recommended Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCoverage(String estimatedCoverage);

        /**
         * <p>
         * The estimated utilization for the recommended Savings Plan.
         * </p>
         * 
         * @param estimatedNewCommitmentUtilization
         *        The estimated utilization for the recommended Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedNewCommitmentUtilization(String estimatedNewCommitmentUtilization);
    }

    static final class BuilderImpl implements Builder {
        private String startTime;

        private String estimatedOnDemandCost;

        private String currentCoverage;

        private String estimatedCoverage;

        private String estimatedNewCommitmentUtilization;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationDetailHourlyMetrics model) {
            startTime(model.startTime);
            estimatedOnDemandCost(model.estimatedOnDemandCost);
            currentCoverage(model.currentCoverage);
            estimatedCoverage(model.estimatedCoverage);
            estimatedNewCommitmentUtilization(model.estimatedNewCommitmentUtilization);
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEstimatedOnDemandCost() {
            return estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final String getCurrentCoverage() {
            return currentCoverage;
        }

        public final void setCurrentCoverage(String currentCoverage) {
            this.currentCoverage = currentCoverage;
        }

        @Override
        public final Builder currentCoverage(String currentCoverage) {
            this.currentCoverage = currentCoverage;
            return this;
        }

        public final String getEstimatedCoverage() {
            return estimatedCoverage;
        }

        public final void setEstimatedCoverage(String estimatedCoverage) {
            this.estimatedCoverage = estimatedCoverage;
        }

        @Override
        public final Builder estimatedCoverage(String estimatedCoverage) {
            this.estimatedCoverage = estimatedCoverage;
            return this;
        }

        public final String getEstimatedNewCommitmentUtilization() {
            return estimatedNewCommitmentUtilization;
        }

        public final void setEstimatedNewCommitmentUtilization(String estimatedNewCommitmentUtilization) {
            this.estimatedNewCommitmentUtilization = estimatedNewCommitmentUtilization;
        }

        @Override
        public final Builder estimatedNewCommitmentUtilization(String estimatedNewCommitmentUtilization) {
            this.estimatedNewCommitmentUtilization = estimatedNewCommitmentUtilization;
            return this;
        }

        @Override
        public RecommendationDetailHourlyMetrics build() {
            return new RecommendationDetailHourlyMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
