/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApproximateUsageRecordsResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetApproximateUsageRecordsResponse.Builder, GetApproximateUsageRecordsResponse> {
    private static final SdkField<Map<String, Long>> SERVICES_FIELD = SdkField
            .<Map<String, Long>> builder(MarshallingType.MAP)
            .memberName("Services")
            .getter(getter(GetApproximateUsageRecordsResponse::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalRecords").getter(getter(GetApproximateUsageRecordsResponse::totalRecords))
            .setter(setter(Builder::totalRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRecords").build()).build();

    private static final SdkField<DateInterval> LOOKBACK_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("LookbackPeriod").getter(getter(GetApproximateUsageRecordsResponse::lookbackPeriod))
            .setter(setter(Builder::lookbackPeriod)).constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD,
            TOTAL_RECORDS_FIELD, LOOKBACK_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, Long> services;

    private final Long totalRecords;

    private final DateInterval lookbackPeriod;

    private GetApproximateUsageRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.totalRecords = builder.totalRecords;
        this.lookbackPeriod = builder.lookbackPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The service metadata for the service or services in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return The service metadata for the service or services in the response.
     */
    public final Map<String, Long> services() {
        return services;
    }

    /**
     * <p>
     * The total number of usage records for all services in the services list.
     * </p>
     * 
     * @return The total number of usage records for all services in the services list.
     */
    public final Long totalRecords() {
        return totalRecords;
    }

    /**
     * <p>
     * The lookback period that's used for the estimation.
     * </p>
     * 
     * @return The lookback period that's used for the estimation.
     */
    public final DateInterval lookbackPeriod() {
        return lookbackPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalRecords());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApproximateUsageRecordsResponse)) {
            return false;
        }
        GetApproximateUsageRecordsResponse other = (GetApproximateUsageRecordsResponse) obj;
        return hasServices() == other.hasServices() && Objects.equals(services(), other.services())
                && Objects.equals(totalRecords(), other.totalRecords())
                && Objects.equals(lookbackPeriod(), other.lookbackPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApproximateUsageRecordsResponse").add("Services", hasServices() ? services() : null)
                .add("TotalRecords", totalRecords()).add("LookbackPeriod", lookbackPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "TotalRecords":
            return Optional.ofNullable(clazz.cast(totalRecords()));
        case "LookbackPeriod":
            return Optional.ofNullable(clazz.cast(lookbackPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Services", SERVICES_FIELD);
        map.put("TotalRecords", TOTAL_RECORDS_FIELD);
        map.put("LookbackPeriod", LOOKBACK_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetApproximateUsageRecordsResponse, T> g) {
        return obj -> g.apply((GetApproximateUsageRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApproximateUsageRecordsResponse> {
        /**
         * <p>
         * The service metadata for the service or services in the response.
         * </p>
         * 
         * @param services
         *        The service metadata for the service or services in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Map<String, Long> services);

        /**
         * <p>
         * The total number of usage records for all services in the services list.
         * </p>
         * 
         * @param totalRecords
         *        The total number of usage records for all services in the services list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecords(Long totalRecords);

        /**
         * <p>
         * The lookback period that's used for the estimation.
         * </p>
         * 
         * @param lookbackPeriod
         *        The lookback period that's used for the estimation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookbackPeriod(DateInterval lookbackPeriod);

        /**
         * <p>
         * The lookback period that's used for the estimation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #lookbackPeriod(DateInterval)}.
         * 
         * @param lookbackPeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lookbackPeriod(DateInterval)
         */
        default Builder lookbackPeriod(Consumer<DateInterval.Builder> lookbackPeriod) {
            return lookbackPeriod(DateInterval.builder().applyMutation(lookbackPeriod).build());
        }
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private Map<String, Long> services = DefaultSdkAutoConstructMap.getInstance();

        private Long totalRecords;

        private DateInterval lookbackPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApproximateUsageRecordsResponse model) {
            super(model);
            services(model.services);
            totalRecords(model.totalRecords);
            lookbackPeriod(model.lookbackPeriod);
        }

        public final Map<String, Long> getServices() {
            if (services instanceof SdkAutoConstructMap) {
                return null;
            }
            return services;
        }

        public final void setServices(Map<String, Long> services) {
            this.services = ApproximateUsageRecordsPerServiceCopier.copy(services);
        }

        @Override
        public final Builder services(Map<String, Long> services) {
            this.services = ApproximateUsageRecordsPerServiceCopier.copy(services);
            return this;
        }

        public final Long getTotalRecords() {
            return totalRecords;
        }

        public final void setTotalRecords(Long totalRecords) {
            this.totalRecords = totalRecords;
        }

        @Override
        public final Builder totalRecords(Long totalRecords) {
            this.totalRecords = totalRecords;
            return this;
        }

        public final DateInterval.Builder getLookbackPeriod() {
            return lookbackPeriod != null ? lookbackPeriod.toBuilder() : null;
        }

        public final void setLookbackPeriod(DateInterval.BuilderImpl lookbackPeriod) {
            this.lookbackPeriod = lookbackPeriod != null ? lookbackPeriod.build() : null;
        }

        @Override
        public final Builder lookbackPeriod(DateInterval lookbackPeriod) {
            this.lookbackPeriod = lookbackPeriod;
            return this;
        }

        @Override
        public GetApproximateUsageRecordsResponse build() {
            return new GetApproximateUsageRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
