/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCostComparisonDriversRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetCostComparisonDriversRequest.Builder, GetCostComparisonDriversRequest> {
    private static final SdkField<String> BILLING_VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingViewArn").getter(getter(GetCostComparisonDriversRequest::billingViewArn))
            .setter(setter(Builder::billingViewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingViewArn").build()).build();

    private static final SdkField<DateInterval> BASELINE_TIME_PERIOD_FIELD = SdkField
            .<DateInterval> builder(MarshallingType.SDK_POJO).memberName("BaselineTimePeriod")
            .getter(getter(GetCostComparisonDriversRequest::baselineTimePeriod)).setter(setter(Builder::baselineTimePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineTimePeriod").build())
            .build();

    private static final SdkField<DateInterval> COMPARISON_TIME_PERIOD_FIELD = SdkField
            .<DateInterval> builder(MarshallingType.SDK_POJO).memberName("ComparisonTimePeriod")
            .getter(getter(GetCostComparisonDriversRequest::comparisonTimePeriod)).setter(setter(Builder::comparisonTimePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonTimePeriod").build())
            .build();

    private static final SdkField<String> METRIC_FOR_COMPARISON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricForComparison").getter(getter(GetCostComparisonDriversRequest::metricForComparison))
            .setter(setter(Builder::metricForComparison))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricForComparison").build())
            .build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetCostComparisonDriversRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<List<GroupDefinition>> GROUP_BY_FIELD = SdkField
            .<List<GroupDefinition>> builder(MarshallingType.LIST)
            .memberName("GroupBy")
            .getter(getter(GetCostComparisonDriversRequest::groupBy))
            .setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetCostComparisonDriversRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetCostComparisonDriversRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_VIEW_ARN_FIELD,
            BASELINE_TIME_PERIOD_FIELD, COMPARISON_TIME_PERIOD_FIELD, METRIC_FOR_COMPARISON_FIELD, FILTER_FIELD, GROUP_BY_FIELD,
            MAX_RESULTS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String billingViewArn;

    private final DateInterval baselineTimePeriod;

    private final DateInterval comparisonTimePeriod;

    private final String metricForComparison;

    private final Expression filter;

    private final List<GroupDefinition> groupBy;

    private final Integer maxResults;

    private final String nextPageToken;

    private GetCostComparisonDriversRequest(BuilderImpl builder) {
        super(builder);
        this.billingViewArn = builder.billingViewArn;
        this.baselineTimePeriod = builder.baselineTimePeriod;
        this.comparisonTimePeriod = builder.comparisonTimePeriod;
        this.metricForComparison = builder.metricForComparison;
        this.filter = builder.filter;
        this.groupBy = builder.groupBy;
        this.maxResults = builder.maxResults;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to specify which
     * particular billing view you want to interact with or retrieve information from when making API calls related to
     * Amazon Web Services Billing and Cost Management features. The BillingViewArn can be retrieved by calling the
     * ListBillingViews API.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to
     *         specify which particular billing view you want to interact with or retrieve information from when making
     *         API calls related to Amazon Web Services Billing and Cost Management features. The BillingViewArn can be
     *         retrieved by calling the ListBillingViews API.
     */
    public final String billingViewArn() {
        return billingViewArn;
    }

    /**
     * <p>
     * The reference time period for comparison. This time period serves as the baseline against which other cost and
     * usage data will be compared. The interval must start and end on the first day of a month, with a duration of
     * exactly one month.
     * </p>
     * 
     * @return The reference time period for comparison. This time period serves as the baseline against which other
     *         cost and usage data will be compared. The interval must start and end on the first day of a month, with a
     *         duration of exactly one month.
     */
    public final DateInterval baselineTimePeriod() {
        return baselineTimePeriod;
    }

    /**
     * <p>
     * The comparison time period for analysis. This time period's cost and usage data will be compared against the
     * baseline time period. The interval must start and end on the first day of a month, with a duration of exactly one
     * month.
     * </p>
     * 
     * @return The comparison time period for analysis. This time period's cost and usage data will be compared against
     *         the baseline time period. The interval must start and end on the first day of a month, with a duration of
     *         exactly one month.
     */
    public final DateInterval comparisonTimePeriod() {
        return comparisonTimePeriod;
    }

    /**
     * <p>
     * The cost and usage metric to compare. Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>,
     * <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>,
     * <code>UnblendedCost</code>, and <code>UsageQuantity</code>.
     * </p>
     * 
     * @return The cost and usage metric to compare. Valid values are <code>AmortizedCost</code>,
     *         <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>,
     *         <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>.
     */
    public final String metricForComparison() {
        return metricForComparison;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can group results using the attributes <code>DIMENSION</code>, <code>TAG</code>, and
     * <code>COST_CATEGORY</code>. Note that <code>SERVICE</code> and <code>USAGE_TYPE</code> dimensions are
     * automatically included in the cost comparison drivers analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return You can group results using the attributes <code>DIMENSION</code>, <code>TAG</code>, and
     *         <code>COST_CATEGORY</code>. Note that <code>SERVICE</code> and <code>USAGE_TYPE</code> dimensions are
     *         automatically included in the cost comparison drivers analysis.
     */
    public final List<GroupDefinition> groupBy() {
        return groupBy;
    }

    /**
     * <p>
     * The maximum number of results that are returned for the request.
     * </p>
     * 
     * @return The maximum number of results that are returned for the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next set of paginated results.
     * </p>
     * 
     * @return The token to retrieve the next set of paginated results.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(baselineTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(metricForComparison());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostComparisonDriversRequest)) {
            return false;
        }
        GetCostComparisonDriversRequest other = (GetCostComparisonDriversRequest) obj;
        return Objects.equals(billingViewArn(), other.billingViewArn())
                && Objects.equals(baselineTimePeriod(), other.baselineTimePeriod())
                && Objects.equals(comparisonTimePeriod(), other.comparisonTimePeriod())
                && Objects.equals(metricForComparison(), other.metricForComparison()) && Objects.equals(filter(), other.filter())
                && hasGroupBy() == other.hasGroupBy() && Objects.equals(groupBy(), other.groupBy())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCostComparisonDriversRequest").add("BillingViewArn", billingViewArn())
                .add("BaselineTimePeriod", baselineTimePeriod()).add("ComparisonTimePeriod", comparisonTimePeriod())
                .add("MetricForComparison", metricForComparison()).add("Filter", filter())
                .add("GroupBy", hasGroupBy() ? groupBy() : null).add("MaxResults", maxResults())
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingViewArn":
            return Optional.ofNullable(clazz.cast(billingViewArn()));
        case "BaselineTimePeriod":
            return Optional.ofNullable(clazz.cast(baselineTimePeriod()));
        case "ComparisonTimePeriod":
            return Optional.ofNullable(clazz.cast(comparisonTimePeriod()));
        case "MetricForComparison":
            return Optional.ofNullable(clazz.cast(metricForComparison()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BillingViewArn", BILLING_VIEW_ARN_FIELD);
        map.put("BaselineTimePeriod", BASELINE_TIME_PERIOD_FIELD);
        map.put("ComparisonTimePeriod", COMPARISON_TIME_PERIOD_FIELD);
        map.put("MetricForComparison", METRIC_FOR_COMPARISON_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostComparisonDriversRequest, T> g) {
        return obj -> g.apply((GetCostComparisonDriversRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCostComparisonDriversRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to specify
         * which particular billing view you want to interact with or retrieve information from when making API calls
         * related to Amazon Web Services Billing and Cost Management features. The BillingViewArn can be retrieved by
         * calling the ListBillingViews API.
         * </p>
         * 
         * @param billingViewArn
         *        The Amazon Resource Name (ARN) that uniquely identifies a specific billing view. The ARN is used to
         *        specify which particular billing view you want to interact with or retrieve information from when
         *        making API calls related to Amazon Web Services Billing and Cost Management features. The
         *        BillingViewArn can be retrieved by calling the ListBillingViews API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingViewArn(String billingViewArn);

        /**
         * <p>
         * The reference time period for comparison. This time period serves as the baseline against which other cost
         * and usage data will be compared. The interval must start and end on the first day of a month, with a duration
         * of exactly one month.
         * </p>
         * 
         * @param baselineTimePeriod
         *        The reference time period for comparison. This time period serves as the baseline against which other
         *        cost and usage data will be compared. The interval must start and end on the first day of a month,
         *        with a duration of exactly one month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineTimePeriod(DateInterval baselineTimePeriod);

        /**
         * <p>
         * The reference time period for comparison. This time period serves as the baseline against which other cost
         * and usage data will be compared. The interval must start and end on the first day of a month, with a duration
         * of exactly one month.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #baselineTimePeriod(DateInterval)}.
         * 
         * @param baselineTimePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baselineTimePeriod(DateInterval)
         */
        default Builder baselineTimePeriod(Consumer<DateInterval.Builder> baselineTimePeriod) {
            return baselineTimePeriod(DateInterval.builder().applyMutation(baselineTimePeriod).build());
        }

        /**
         * <p>
         * The comparison time period for analysis. This time period's cost and usage data will be compared against the
         * baseline time period. The interval must start and end on the first day of a month, with a duration of exactly
         * one month.
         * </p>
         * 
         * @param comparisonTimePeriod
         *        The comparison time period for analysis. This time period's cost and usage data will be compared
         *        against the baseline time period. The interval must start and end on the first day of a month, with a
         *        duration of exactly one month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonTimePeriod(DateInterval comparisonTimePeriod);

        /**
         * <p>
         * The comparison time period for analysis. This time period's cost and usage data will be compared against the
         * baseline time period. The interval must start and end on the first day of a month, with a duration of exactly
         * one month.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #comparisonTimePeriod(DateInterval)}.
         * 
         * @param comparisonTimePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparisonTimePeriod(DateInterval)
         */
        default Builder comparisonTimePeriod(Consumer<DateInterval.Builder> comparisonTimePeriod) {
            return comparisonTimePeriod(DateInterval.builder().applyMutation(comparisonTimePeriod).build());
        }

        /**
         * <p>
         * The cost and usage metric to compare. Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>,
         * <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>,
         * <code>UnblendedCost</code>, and <code>UsageQuantity</code>.
         * </p>
         * 
         * @param metricForComparison
         *        The cost and usage metric to compare. Valid values are <code>AmortizedCost</code>,
         *        <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>,
         *        <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricForComparison(String metricForComparison);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * You can group results using the attributes <code>DIMENSION</code>, <code>TAG</code>, and
         * <code>COST_CATEGORY</code>. Note that <code>SERVICE</code> and <code>USAGE_TYPE</code> dimensions are
         * automatically included in the cost comparison drivers analysis.
         * </p>
         * 
         * @param groupBy
         *        You can group results using the attributes <code>DIMENSION</code>, <code>TAG</code>, and
         *        <code>COST_CATEGORY</code>. Note that <code>SERVICE</code> and <code>USAGE_TYPE</code> dimensions are
         *        automatically included in the cost comparison drivers analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<GroupDefinition> groupBy);

        /**
         * <p>
         * You can group results using the attributes <code>DIMENSION</code>, <code>TAG</code>, and
         * <code>COST_CATEGORY</code>. Note that <code>SERVICE</code> and <code>USAGE_TYPE</code> dimensions are
         * automatically included in the cost comparison drivers analysis.
         * </p>
         * 
         * @param groupBy
         *        You can group results using the attributes <code>DIMENSION</code>, <code>TAG</code>, and
         *        <code>COST_CATEGORY</code>. Note that <code>SERVICE</code> and <code>USAGE_TYPE</code> dimensions are
         *        automatically included in the cost comparison drivers analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(GroupDefinition... groupBy);

        /**
         * <p>
         * You can group results using the attributes <code>DIMENSION</code>, <code>TAG</code>, and
         * <code>COST_CATEGORY</code>. Note that <code>SERVICE</code> and <code>USAGE_TYPE</code> dimensions are
         * automatically included in the cost comparison drivers analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #groupBy(List<GroupDefinition>)}.
         * 
         * @param groupBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupBy(java.util.Collection<GroupDefinition>)
         */
        Builder groupBy(Consumer<GroupDefinition.Builder>... groupBy);

        /**
         * <p>
         * The maximum number of results that are returned for the request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that are returned for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next set of paginated results.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String billingViewArn;

        private DateInterval baselineTimePeriod;

        private DateInterval comparisonTimePeriod;

        private String metricForComparison;

        private Expression filter;

        private List<GroupDefinition> groupBy = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostComparisonDriversRequest model) {
            super(model);
            billingViewArn(model.billingViewArn);
            baselineTimePeriod(model.baselineTimePeriod);
            comparisonTimePeriod(model.comparisonTimePeriod);
            metricForComparison(model.metricForComparison);
            filter(model.filter);
            groupBy(model.groupBy);
            maxResults(model.maxResults);
            nextPageToken(model.nextPageToken);
        }

        public final String getBillingViewArn() {
            return billingViewArn;
        }

        public final void setBillingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
        }

        @Override
        public final Builder billingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        public final DateInterval.Builder getBaselineTimePeriod() {
            return baselineTimePeriod != null ? baselineTimePeriod.toBuilder() : null;
        }

        public final void setBaselineTimePeriod(DateInterval.BuilderImpl baselineTimePeriod) {
            this.baselineTimePeriod = baselineTimePeriod != null ? baselineTimePeriod.build() : null;
        }

        @Override
        public final Builder baselineTimePeriod(DateInterval baselineTimePeriod) {
            this.baselineTimePeriod = baselineTimePeriod;
            return this;
        }

        public final DateInterval.Builder getComparisonTimePeriod() {
            return comparisonTimePeriod != null ? comparisonTimePeriod.toBuilder() : null;
        }

        public final void setComparisonTimePeriod(DateInterval.BuilderImpl comparisonTimePeriod) {
            this.comparisonTimePeriod = comparisonTimePeriod != null ? comparisonTimePeriod.build() : null;
        }

        @Override
        public final Builder comparisonTimePeriod(DateInterval comparisonTimePeriod) {
            this.comparisonTimePeriod = comparisonTimePeriod;
            return this;
        }

        public final String getMetricForComparison() {
            return metricForComparison;
        }

        public final void setMetricForComparison(String metricForComparison) {
            this.metricForComparison = metricForComparison;
        }

        @Override
        public final Builder metricForComparison(String metricForComparison) {
            this.metricForComparison = metricForComparison;
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final List<GroupDefinition.Builder> getGroupBy() {
            List<GroupDefinition.Builder> result = GroupDefinitionsCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<GroupDefinition.BuilderImpl> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<GroupDefinition> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupDefinition... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<GroupDefinition.Builder>... groupBy) {
            groupBy(Stream.of(groupBy).map(c -> GroupDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCostComparisonDriversRequest build() {
            return new GetCostComparisonDriversRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
