/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the reservations that Amazon Web Services recommends that you purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedCapacityDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedCapacityDetails.Builder, ReservedCapacityDetails> {
    private static final SdkField<DynamoDBCapacityDetails> DYNAMO_DB_CAPACITY_DETAILS_FIELD = SdkField
            .<DynamoDBCapacityDetails> builder(MarshallingType.SDK_POJO).memberName("DynamoDBCapacityDetails")
            .getter(getter(ReservedCapacityDetails::dynamoDBCapacityDetails)).setter(setter(Builder::dynamoDBCapacityDetails))
            .constructor(DynamoDBCapacityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDBCapacityDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DYNAMO_DB_CAPACITY_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DynamoDBCapacityDetails dynamoDBCapacityDetails;

    private ReservedCapacityDetails(BuilderImpl builder) {
        this.dynamoDBCapacityDetails = builder.dynamoDBCapacityDetails;
    }

    /**
     * <p>
     * The DynamoDB reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The DynamoDB reservations that Amazon Web Services recommends that you purchase.
     */
    public final DynamoDBCapacityDetails dynamoDBCapacityDetails() {
        return dynamoDBCapacityDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDBCapacityDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedCapacityDetails)) {
            return false;
        }
        ReservedCapacityDetails other = (ReservedCapacityDetails) obj;
        return Objects.equals(dynamoDBCapacityDetails(), other.dynamoDBCapacityDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedCapacityDetails").add("DynamoDBCapacityDetails", dynamoDBCapacityDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DynamoDBCapacityDetails":
            return Optional.ofNullable(clazz.cast(dynamoDBCapacityDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DynamoDBCapacityDetails", DYNAMO_DB_CAPACITY_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedCapacityDetails, T> g) {
        return obj -> g.apply((ReservedCapacityDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedCapacityDetails> {
        /**
         * <p>
         * The DynamoDB reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param dynamoDBCapacityDetails
         *        The DynamoDB reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBCapacityDetails(DynamoDBCapacityDetails dynamoDBCapacityDetails);

        /**
         * <p>
         * The DynamoDB reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamoDBCapacityDetails.Builder} avoiding
         * the need to create one manually via {@link DynamoDBCapacityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamoDBCapacityDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #dynamoDBCapacityDetails(DynamoDBCapacityDetails)}.
         * 
         * @param dynamoDBCapacityDetails
         *        a consumer that will call methods on {@link DynamoDBCapacityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDBCapacityDetails(DynamoDBCapacityDetails)
         */
        default Builder dynamoDBCapacityDetails(Consumer<DynamoDBCapacityDetails.Builder> dynamoDBCapacityDetails) {
            return dynamoDBCapacityDetails(DynamoDBCapacityDetails.builder().applyMutation(dynamoDBCapacityDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DynamoDBCapacityDetails dynamoDBCapacityDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedCapacityDetails model) {
            dynamoDBCapacityDetails(model.dynamoDBCapacityDetails);
        }

        public final DynamoDBCapacityDetails.Builder getDynamoDBCapacityDetails() {
            return dynamoDBCapacityDetails != null ? dynamoDBCapacityDetails.toBuilder() : null;
        }

        public final void setDynamoDBCapacityDetails(DynamoDBCapacityDetails.BuilderImpl dynamoDBCapacityDetails) {
            this.dynamoDBCapacityDetails = dynamoDBCapacityDetails != null ? dynamoDBCapacityDetails.build() : null;
        }

        @Override
        public final Builder dynamoDBCapacityDetails(DynamoDBCapacityDetails dynamoDBCapacityDetails) {
            this.dynamoDBCapacityDetails = dynamoDBCapacityDetails;
            return this;
        }

        @Override
        public ReservedCapacityDetails build() {
            return new ReservedCapacityDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
