/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftInstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftInstanceDetails> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Family").getter(RedshiftInstanceDetails.getter(RedshiftInstanceDetails::family)).setter(RedshiftInstanceDetails.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(RedshiftInstanceDetails.getter(RedshiftInstanceDetails::nodeType)).setter(RedshiftInstanceDetails.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(RedshiftInstanceDetails.getter(RedshiftInstanceDetails::region)).setter(RedshiftInstanceDetails.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CurrentGeneration").getter(RedshiftInstanceDetails.getter(RedshiftInstanceDetails::currentGeneration)).setter(RedshiftInstanceDetails.setter(Builder::currentGeneration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").build()}).build();
    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SizeFlexEligible").getter(RedshiftInstanceDetails.getter(RedshiftInstanceDetails::sizeFlexEligible)).setter(RedshiftInstanceDetails.setter(Builder::sizeFlexEligible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeFlexEligible").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, NODE_TYPE_FIELD, REGION_FIELD, CURRENT_GENERATION_FIELD, SIZE_FLEX_ELIGIBLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftInstanceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String family;
    private final String nodeType;
    private final String region;
    private final Boolean currentGeneration;
    private final Boolean sizeFlexEligible;

    private RedshiftInstanceDetails(BuilderImpl builder) {
        this.family = builder.family;
        this.nodeType = builder.nodeType;
        this.region = builder.region;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    public final String family() {
        return this.family;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String region() {
        return this.region;
    }

    public final Boolean currentGeneration() {
        return this.currentGeneration;
    }

    public final Boolean sizeFlexEligible() {
        return this.sizeFlexEligible;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeFlexEligible());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftInstanceDetails)) {
            return false;
        }
        RedshiftInstanceDetails other = (RedshiftInstanceDetails)obj;
        return Objects.equals(this.family(), other.family()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.currentGeneration(), other.currentGeneration()) && Objects.equals(this.sizeFlexEligible(), other.sizeFlexEligible());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftInstanceDetails").add("Family", (Object)this.family()).add("NodeType", (Object)this.nodeType()).add("Region", (Object)this.region()).add("CurrentGeneration", (Object)this.currentGeneration()).add("SizeFlexEligible", (Object)this.sizeFlexEligible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "CurrentGeneration": {
                return Optional.ofNullable(clazz.cast(this.currentGeneration()));
            }
            case "SizeFlexEligible": {
                return Optional.ofNullable(clazz.cast(this.sizeFlexEligible()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Family", FAMILY_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("CurrentGeneration", CURRENT_GENERATION_FIELD);
        map.put("SizeFlexEligible", SIZE_FLEX_ELIGIBLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftInstanceDetails, T> g) {
        return obj -> g.apply((RedshiftInstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String family;
        private String nodeType;
        private String region;
        private Boolean currentGeneration;
        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftInstanceDetails model) {
            this.family(model.family);
            this.nodeType(model.nodeType);
            this.region(model.region);
            this.currentGeneration(model.currentGeneration);
            this.sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getFamily() {
            return this.family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Boolean getCurrentGeneration() {
            return this.currentGeneration;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final Boolean getSizeFlexEligible() {
            return this.sizeFlexEligible;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public RedshiftInstanceDetails build() {
            return new RedshiftInstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftInstanceDetails> {
        public Builder family(String var1);

        public Builder nodeType(String var1);

        public Builder region(String var1);

        public Builder currentGeneration(Boolean var1);

        public Builder sizeFlexEligible(Boolean var1);
    }
}

