/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.AnomalySubscription;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse;

public class GetAnomalySubscriptionsIterable
implements SdkIterable<GetAnomalySubscriptionsResponse> {
    private final CostExplorerClient client;
    private final GetAnomalySubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAnomalySubscriptionsIterable(CostExplorerClient client, GetAnomalySubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAnomalySubscriptionsResponseFetcher();
    }

    public Iterator<GetAnomalySubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnomalySubscription> anomalySubscriptions() {
        Function<GetAnomalySubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalySubscriptions() != null) {
                return response.anomalySubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAnomalySubscriptionsResponseFetcher
    implements SyncPageFetcher<GetAnomalySubscriptionsResponse> {
        private GetAnomalySubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(GetAnomalySubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetAnomalySubscriptionsResponse nextPage(GetAnomalySubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return GetAnomalySubscriptionsIterable.this.client.getAnomalySubscriptions(GetAnomalySubscriptionsIterable.this.firstRequest);
            }
            return GetAnomalySubscriptionsIterable.this.client.getAnomalySubscriptions((GetAnomalySubscriptionsRequest)((Object)GetAnomalySubscriptionsIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

