/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum Dimension {
    AZ("AZ"),

    INSTANCE_TYPE("INSTANCE_TYPE"),

    LINKED_ACCOUNT("LINKED_ACCOUNT"),

    PAYER_ACCOUNT("PAYER_ACCOUNT"),

    LINKED_ACCOUNT_NAME("LINKED_ACCOUNT_NAME"),

    OPERATION("OPERATION"),

    PURCHASE_TYPE("PURCHASE_TYPE"),

    REGION("REGION"),

    SERVICE("SERVICE"),

    SERVICE_CODE("SERVICE_CODE"),

    USAGE_TYPE("USAGE_TYPE"),

    USAGE_TYPE_GROUP("USAGE_TYPE_GROUP"),

    RECORD_TYPE("RECORD_TYPE"),

    OPERATING_SYSTEM("OPERATING_SYSTEM"),

    TENANCY("TENANCY"),

    SCOPE("SCOPE"),

    PLATFORM("PLATFORM"),

    SUBSCRIPTION_ID("SUBSCRIPTION_ID"),

    LEGAL_ENTITY_NAME("LEGAL_ENTITY_NAME"),

    DEPLOYMENT_OPTION("DEPLOYMENT_OPTION"),

    DATABASE_ENGINE("DATABASE_ENGINE"),

    CACHE_ENGINE("CACHE_ENGINE"),

    INSTANCE_TYPE_FAMILY("INSTANCE_TYPE_FAMILY"),

    BILLING_ENTITY("BILLING_ENTITY"),

    RESERVATION_ID("RESERVATION_ID"),

    RESOURCE_ID("RESOURCE_ID"),

    RIGHTSIZING_TYPE("RIGHTSIZING_TYPE"),

    SAVINGS_PLANS_TYPE("SAVINGS_PLANS_TYPE"),

    SAVINGS_PLAN_ARN("SAVINGS_PLAN_ARN"),

    PAYMENT_OPTION("PAYMENT_OPTION"),

    AGREEMENT_END_DATE_TIME_AFTER("AGREEMENT_END_DATE_TIME_AFTER"),

    AGREEMENT_END_DATE_TIME_BEFORE("AGREEMENT_END_DATE_TIME_BEFORE"),

    INVOICING_ENTITY("INVOICING_ENTITY"),

    ANOMALY_TOTAL_IMPACT_ABSOLUTE("ANOMALY_TOTAL_IMPACT_ABSOLUTE"),

    ANOMALY_TOTAL_IMPACT_PERCENTAGE("ANOMALY_TOTAL_IMPACT_PERCENTAGE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Dimension> VALUE_MAP = EnumUtils.uniqueIndex(Dimension.class, Dimension::toString);

    private final String value;

    private Dimension(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Dimension corresponding to the value
     */
    public static Dimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Dimension}s
     */
    public static Set<Dimension> knownValues() {
        Set<Dimension> knownValues = EnumSet.allOf(Dimension.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
