/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansCoverageResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetSavingsPlansCoverageResponse.Builder, GetSavingsPlansCoverageResponse> {
    private static final SdkField<List<SavingsPlansCoverage>> SAVINGS_PLANS_COVERAGES_FIELD = SdkField
            .<List<SavingsPlansCoverage>> builder(MarshallingType.LIST)
            .memberName("SavingsPlansCoverages")
            .getter(getter(GetSavingsPlansCoverageResponse::savingsPlansCoverages))
            .setter(setter(Builder::savingsPlansCoverages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansCoverages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlansCoverage> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlansCoverage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSavingsPlansCoverageResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_COVERAGES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SavingsPlansCoverage> savingsPlansCoverages;

    private final String nextToken;

    private GetSavingsPlansCoverageResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlansCoverages = builder.savingsPlansCoverages;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SavingsPlansCoverages property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSavingsPlansCoverages() {
        return savingsPlansCoverages != null && !(savingsPlansCoverages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The amount of spend that your Savings Plans covered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSavingsPlansCoverages} method.
     * </p>
     * 
     * @return The amount of spend that your Savings Plans covered.
     */
    public final List<SavingsPlansCoverage> savingsPlansCoverages() {
        return savingsPlansCoverages;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlansCoverages() ? savingsPlansCoverages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansCoverageResponse)) {
            return false;
        }
        GetSavingsPlansCoverageResponse other = (GetSavingsPlansCoverageResponse) obj;
        return hasSavingsPlansCoverages() == other.hasSavingsPlansCoverages()
                && Objects.equals(savingsPlansCoverages(), other.savingsPlansCoverages())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSavingsPlansCoverageResponse")
                .add("SavingsPlansCoverages", hasSavingsPlansCoverages() ? savingsPlansCoverages() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansCoverages":
            return Optional.ofNullable(clazz.cast(savingsPlansCoverages()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SavingsPlansCoverages", SAVINGS_PLANS_COVERAGES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansCoverageResponse, T> g) {
        return obj -> g.apply((GetSavingsPlansCoverageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansCoverageResponse> {
        /**
         * <p>
         * The amount of spend that your Savings Plans covered.
         * </p>
         * 
         * @param savingsPlansCoverages
         *        The amount of spend that your Savings Plans covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansCoverages(Collection<SavingsPlansCoverage> savingsPlansCoverages);

        /**
         * <p>
         * The amount of spend that your Savings Plans covered.
         * </p>
         * 
         * @param savingsPlansCoverages
         *        The amount of spend that your Savings Plans covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansCoverages(SavingsPlansCoverage... savingsPlansCoverages);

        /**
         * <p>
         * The amount of spend that your Savings Plans covered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage.Builder#build()} is called
         * immediately and its result is passed to {@link #savingsPlansCoverages(List<SavingsPlansCoverage>)}.
         * 
         * @param savingsPlansCoverages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansCoverages(java.util.Collection<SavingsPlansCoverage>)
         */
        Builder savingsPlansCoverages(Consumer<SavingsPlansCoverage.Builder>... savingsPlansCoverages);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<SavingsPlansCoverage> savingsPlansCoverages = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansCoverageResponse model) {
            super(model);
            savingsPlansCoverages(model.savingsPlansCoverages);
            nextToken(model.nextToken);
        }

        public final List<SavingsPlansCoverage.Builder> getSavingsPlansCoverages() {
            List<SavingsPlansCoverage.Builder> result = SavingsPlansCoveragesCopier.copyToBuilder(this.savingsPlansCoverages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSavingsPlansCoverages(Collection<SavingsPlansCoverage.BuilderImpl> savingsPlansCoverages) {
            this.savingsPlansCoverages = SavingsPlansCoveragesCopier.copyFromBuilder(savingsPlansCoverages);
        }

        @Override
        public final Builder savingsPlansCoverages(Collection<SavingsPlansCoverage> savingsPlansCoverages) {
            this.savingsPlansCoverages = SavingsPlansCoveragesCopier.copy(savingsPlansCoverages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansCoverages(SavingsPlansCoverage... savingsPlansCoverages) {
            savingsPlansCoverages(Arrays.asList(savingsPlansCoverages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansCoverages(Consumer<SavingsPlansCoverage.Builder>... savingsPlansCoverages) {
            savingsPlansCoverages(Stream.of(savingsPlansCoverages)
                    .map(c -> SavingsPlansCoverage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSavingsPlansCoverageResponse build() {
            return new GetSavingsPlansCoverageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
