/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters cost anomalies based on the total impact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TotalImpactFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TotalImpactFilter.Builder, TotalImpactFilter> {
    private static final SdkField<String> NUMERIC_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumericOperator").getter(getter(TotalImpactFilter::numericOperatorAsString))
            .setter(setter(Builder::numericOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericOperator").build()).build();

    private static final SdkField<Double> START_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StartValue").getter(getter(TotalImpactFilter::startValue)).setter(setter(Builder::startValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartValue").build()).build();

    private static final SdkField<Double> END_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("EndValue").getter(getter(TotalImpactFilter::endValue)).setter(setter(Builder::endValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERIC_OPERATOR_FIELD,
            START_VALUE_FIELD, END_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String numericOperator;

    private final Double startValue;

    private final Double endValue;

    private TotalImpactFilter(BuilderImpl builder) {
        this.numericOperator = builder.numericOperator;
        this.startValue = builder.startValue;
        this.endValue = builder.endValue;
    }

    /**
     * <p>
     * The comparing value that's used in the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numericOperator}
     * will return {@link NumericOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numericOperatorAsString}.
     * </p>
     * 
     * @return The comparing value that's used in the filter.
     * @see NumericOperator
     */
    public final NumericOperator numericOperator() {
        return NumericOperator.fromValue(numericOperator);
    }

    /**
     * <p>
     * The comparing value that's used in the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #numericOperator}
     * will return {@link NumericOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #numericOperatorAsString}.
     * </p>
     * 
     * @return The comparing value that's used in the filter.
     * @see NumericOperator
     */
    public final String numericOperatorAsString() {
        return numericOperator;
    }

    /**
     * <p>
     * The lower bound dollar value that's used in the filter.
     * </p>
     * 
     * @return The lower bound dollar value that's used in the filter.
     */
    public final Double startValue() {
        return startValue;
    }

    /**
     * <p>
     * The upper bound dollar value that's used in the filter.
     * </p>
     * 
     * @return The upper bound dollar value that's used in the filter.
     */
    public final Double endValue() {
        return endValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numericOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startValue());
        hashCode = 31 * hashCode + Objects.hashCode(endValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TotalImpactFilter)) {
            return false;
        }
        TotalImpactFilter other = (TotalImpactFilter) obj;
        return Objects.equals(numericOperatorAsString(), other.numericOperatorAsString())
                && Objects.equals(startValue(), other.startValue()) && Objects.equals(endValue(), other.endValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TotalImpactFilter").add("NumericOperator", numericOperatorAsString())
                .add("StartValue", startValue()).add("EndValue", endValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumericOperator":
            return Optional.ofNullable(clazz.cast(numericOperatorAsString()));
        case "StartValue":
            return Optional.ofNullable(clazz.cast(startValue()));
        case "EndValue":
            return Optional.ofNullable(clazz.cast(endValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumericOperator", NUMERIC_OPERATOR_FIELD);
        map.put("StartValue", START_VALUE_FIELD);
        map.put("EndValue", END_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TotalImpactFilter, T> g) {
        return obj -> g.apply((TotalImpactFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TotalImpactFilter> {
        /**
         * <p>
         * The comparing value that's used in the filter.
         * </p>
         * 
         * @param numericOperator
         *        The comparing value that's used in the filter.
         * @see NumericOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericOperator
         */
        Builder numericOperator(String numericOperator);

        /**
         * <p>
         * The comparing value that's used in the filter.
         * </p>
         * 
         * @param numericOperator
         *        The comparing value that's used in the filter.
         * @see NumericOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericOperator
         */
        Builder numericOperator(NumericOperator numericOperator);

        /**
         * <p>
         * The lower bound dollar value that's used in the filter.
         * </p>
         * 
         * @param startValue
         *        The lower bound dollar value that's used in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startValue(Double startValue);

        /**
         * <p>
         * The upper bound dollar value that's used in the filter.
         * </p>
         * 
         * @param endValue
         *        The upper bound dollar value that's used in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endValue(Double endValue);
    }

    static final class BuilderImpl implements Builder {
        private String numericOperator;

        private Double startValue;

        private Double endValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TotalImpactFilter model) {
            numericOperator(model.numericOperator);
            startValue(model.startValue);
            endValue(model.endValue);
        }

        public final String getNumericOperator() {
            return numericOperator;
        }

        public final void setNumericOperator(String numericOperator) {
            this.numericOperator = numericOperator;
        }

        @Override
        public final Builder numericOperator(String numericOperator) {
            this.numericOperator = numericOperator;
            return this;
        }

        @Override
        public final Builder numericOperator(NumericOperator numericOperator) {
            this.numericOperator(numericOperator == null ? null : numericOperator.toString());
            return this;
        }

        public final Double getStartValue() {
            return startValue;
        }

        public final void setStartValue(Double startValue) {
            this.startValue = startValue;
        }

        @Override
        public final Builder startValue(Double startValue) {
            this.startValue = startValue;
            return this;
        }

        public final Double getEndValue() {
            return endValue;
        }

        public final void setEndValue(Double endValue) {
            this.endValue = endValue;
        }

        @Override
        public final Builder endValue(Double endValue) {
            this.endValue = endValue;
            return this;
        }

        @Override
        public TotalImpactFilter build() {
            return new TotalImpactFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
