/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cost allocation tag backfill request structure that contains metadata and details of a certain backfill.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostAllocationTagBackfillRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CostAllocationTagBackfillRequest.Builder, CostAllocationTagBackfillRequest> {
    private static final SdkField<String> BACKFILL_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackfillFrom").getter(getter(CostAllocationTagBackfillRequest::backfillFrom))
            .setter(setter(Builder::backfillFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillFrom").build()).build();

    private static final SdkField<String> REQUESTED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestedAt").getter(getter(CostAllocationTagBackfillRequest::requestedAt))
            .setter(setter(Builder::requestedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedAt").build()).build();

    private static final SdkField<String> COMPLETED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompletedAt").getter(getter(CostAllocationTagBackfillRequest::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build()).build();

    private static final SdkField<String> BACKFILL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackfillStatus").getter(getter(CostAllocationTagBackfillRequest::backfillStatusAsString))
            .setter(setter(Builder::backfillStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillStatus").build()).build();

    private static final SdkField<String> LAST_UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedAt").getter(getter(CostAllocationTagBackfillRequest::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKFILL_FROM_FIELD,
            REQUESTED_AT_FIELD, COMPLETED_AT_FIELD, BACKFILL_STATUS_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backfillFrom;

    private final String requestedAt;

    private final String completedAt;

    private final String backfillStatus;

    private final String lastUpdatedAt;

    private CostAllocationTagBackfillRequest(BuilderImpl builder) {
        this.backfillFrom = builder.backfillFrom;
        this.requestedAt = builder.requestedAt;
        this.completedAt = builder.completedAt;
        this.backfillStatus = builder.backfillStatus;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The date the backfill starts from.
     * </p>
     * 
     * @return The date the backfill starts from.
     */
    public final String backfillFrom() {
        return backfillFrom;
    }

    /**
     * <p>
     * The time when the backfill was requested.
     * </p>
     * 
     * @return The time when the backfill was requested.
     */
    public final String requestedAt() {
        return requestedAt;
    }

    /**
     * <p>
     * The backfill completion time.
     * </p>
     * 
     * @return The backfill completion time.
     */
    public final String completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The status of the cost allocation tag backfill request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backfillStatus}
     * will return {@link CostAllocationTagBackfillStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #backfillStatusAsString}.
     * </p>
     * 
     * @return The status of the cost allocation tag backfill request.
     * @see CostAllocationTagBackfillStatus
     */
    public final CostAllocationTagBackfillStatus backfillStatus() {
        return CostAllocationTagBackfillStatus.fromValue(backfillStatus);
    }

    /**
     * <p>
     * The status of the cost allocation tag backfill request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backfillStatus}
     * will return {@link CostAllocationTagBackfillStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #backfillStatusAsString}.
     * </p>
     * 
     * @return The status of the cost allocation tag backfill request.
     * @see CostAllocationTagBackfillStatus
     */
    public final String backfillStatusAsString() {
        return backfillStatus;
    }

    /**
     * <p>
     * The time when the backfill status was last updated.
     * </p>
     * 
     * @return The time when the backfill status was last updated.
     */
    public final String lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backfillFrom());
        hashCode = 31 * hashCode + Objects.hashCode(requestedAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(backfillStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostAllocationTagBackfillRequest)) {
            return false;
        }
        CostAllocationTagBackfillRequest other = (CostAllocationTagBackfillRequest) obj;
        return Objects.equals(backfillFrom(), other.backfillFrom()) && Objects.equals(requestedAt(), other.requestedAt())
                && Objects.equals(completedAt(), other.completedAt())
                && Objects.equals(backfillStatusAsString(), other.backfillStatusAsString())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostAllocationTagBackfillRequest").add("BackfillFrom", backfillFrom())
                .add("RequestedAt", requestedAt()).add("CompletedAt", completedAt())
                .add("BackfillStatus", backfillStatusAsString()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackfillFrom":
            return Optional.ofNullable(clazz.cast(backfillFrom()));
        case "RequestedAt":
            return Optional.ofNullable(clazz.cast(requestedAt()));
        case "CompletedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "BackfillStatus":
            return Optional.ofNullable(clazz.cast(backfillStatusAsString()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackfillFrom", BACKFILL_FROM_FIELD);
        map.put("RequestedAt", REQUESTED_AT_FIELD);
        map.put("CompletedAt", COMPLETED_AT_FIELD);
        map.put("BackfillStatus", BACKFILL_STATUS_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostAllocationTagBackfillRequest, T> g) {
        return obj -> g.apply((CostAllocationTagBackfillRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostAllocationTagBackfillRequest> {
        /**
         * <p>
         * The date the backfill starts from.
         * </p>
         * 
         * @param backfillFrom
         *        The date the backfill starts from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backfillFrom(String backfillFrom);

        /**
         * <p>
         * The time when the backfill was requested.
         * </p>
         * 
         * @param requestedAt
         *        The time when the backfill was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedAt(String requestedAt);

        /**
         * <p>
         * The backfill completion time.
         * </p>
         * 
         * @param completedAt
         *        The backfill completion time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(String completedAt);

        /**
         * <p>
         * The status of the cost allocation tag backfill request.
         * </p>
         * 
         * @param backfillStatus
         *        The status of the cost allocation tag backfill request.
         * @see CostAllocationTagBackfillStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagBackfillStatus
         */
        Builder backfillStatus(String backfillStatus);

        /**
         * <p>
         * The status of the cost allocation tag backfill request.
         * </p>
         * 
         * @param backfillStatus
         *        The status of the cost allocation tag backfill request.
         * @see CostAllocationTagBackfillStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagBackfillStatus
         */
        Builder backfillStatus(CostAllocationTagBackfillStatus backfillStatus);

        /**
         * <p>
         * The time when the backfill status was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time when the backfill status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(String lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String backfillFrom;

        private String requestedAt;

        private String completedAt;

        private String backfillStatus;

        private String lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CostAllocationTagBackfillRequest model) {
            backfillFrom(model.backfillFrom);
            requestedAt(model.requestedAt);
            completedAt(model.completedAt);
            backfillStatus(model.backfillStatus);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getBackfillFrom() {
            return backfillFrom;
        }

        public final void setBackfillFrom(String backfillFrom) {
            this.backfillFrom = backfillFrom;
        }

        @Override
        public final Builder backfillFrom(String backfillFrom) {
            this.backfillFrom = backfillFrom;
            return this;
        }

        public final String getRequestedAt() {
            return requestedAt;
        }

        public final void setRequestedAt(String requestedAt) {
            this.requestedAt = requestedAt;
        }

        @Override
        public final Builder requestedAt(String requestedAt) {
            this.requestedAt = requestedAt;
            return this;
        }

        public final String getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getBackfillStatus() {
            return backfillStatus;
        }

        public final void setBackfillStatus(String backfillStatus) {
            this.backfillStatus = backfillStatus;
        }

        @Override
        public final Builder backfillStatus(String backfillStatus) {
            this.backfillStatus = backfillStatus;
            return this;
        }

        @Override
        public final Builder backfillStatus(CostAllocationTagBackfillStatus backfillStatus) {
            this.backfillStatus(backfillStatus == null ? null : backfillStatus.toString());
            return this;
        }

        public final String getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(String lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(String lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public CostAllocationTagBackfillRequest build() {
            return new CostAllocationTagBackfillRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
