/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationsRequest extends CostOptimizationHubRequest implements
        ToCopyableBuilder<ListRecommendationsRequest.Builder, ListRecommendationsRequest> {
    private static final SdkField<Filter> FILTER_FIELD = SdkField.<Filter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListRecommendationsRequest::filter)).setter(setter(Builder::filter)).constructor(Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Boolean> INCLUDE_ALL_RECOMMENDATIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("includeAllRecommendations")
            .getter(getter(ListRecommendationsRequest::includeAllRecommendations))
            .setter(setter(Builder::includeAllRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAllRecommendations").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRecommendationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecommendationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<OrderBy> ORDER_BY_FIELD = SdkField.<OrderBy> builder(MarshallingType.SDK_POJO)
            .memberName("orderBy").getter(getter(ListRecommendationsRequest::orderBy)).setter(setter(Builder::orderBy))
            .constructor(OrderBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            INCLUDE_ALL_RECOMMENDATIONS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_BY_FIELD));

    private final Filter filter;

    private final Boolean includeAllRecommendations;

    private final Integer maxResults;

    private final String nextToken;

    private final OrderBy orderBy;

    private ListRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.includeAllRecommendations = builder.includeAllRecommendations;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.orderBy = builder.orderBy;
    }

    /**
     * <p>
     * The constraints that you want all returned recommendations to match.
     * </p>
     * 
     * @return The constraints that you want all returned recommendations to match.
     */
    public final Filter filter() {
        return filter;
    }

    /**
     * <p>
     * List of all recommendations for a resource, or a single recommendation if de-duped by <code>resourceId</code>.
     * </p>
     * 
     * @return List of all recommendations for a resource, or a single recommendation if de-duped by
     *         <code>resourceId</code>.
     */
    public final Boolean includeAllRecommendations() {
        return includeAllRecommendations;
    }

    /**
     * <p>
     * The maximum number of recommendations that are returned for the request.
     * </p>
     * 
     * @return The maximum number of recommendations that are returned for the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ordering of recommendations by a dimension.
     * </p>
     * 
     * @return The ordering of recommendations by a dimension.
     */
    public final OrderBy orderBy() {
        return orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(includeAllRecommendations());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(orderBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsRequest)) {
            return false;
        }
        ListRecommendationsRequest other = (ListRecommendationsRequest) obj;
        return Objects.equals(filter(), other.filter())
                && Objects.equals(includeAllRecommendations(), other.includeAllRecommendations())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(orderBy(), other.orderBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationsRequest").add("Filter", filter())
                .add("IncludeAllRecommendations", includeAllRecommendations()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("OrderBy", orderBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "includeAllRecommendations":
            return Optional.ofNullable(clazz.cast(includeAllRecommendations()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationsRequest, T> g) {
        return obj -> g.apply((ListRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostOptimizationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecommendationsRequest> {
        /**
         * <p>
         * The constraints that you want all returned recommendations to match.
         * </p>
         * 
         * @param filter
         *        The constraints that you want all returned recommendations to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter filter);

        /**
         * <p>
         * The constraints that you want all returned recommendations to match.
         * </p>
         * This is a convenience method that creates an instance of the {@link Filter.Builder} avoiding the need to
         * create one manually via {@link Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filter.Builder#build()} is called immediately and its result is
         * passed to {@link #filter(Filter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Filter)
         */
        default Builder filter(Consumer<Filter.Builder> filter) {
            return filter(Filter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * List of all recommendations for a resource, or a single recommendation if de-duped by <code>resourceId</code>
         * .
         * </p>
         * 
         * @param includeAllRecommendations
         *        List of all recommendations for a resource, or a single recommendation if de-duped by
         *        <code>resourceId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllRecommendations(Boolean includeAllRecommendations);

        /**
         * <p>
         * The maximum number of recommendations that are returned for the request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of recommendations that are returned for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ordering of recommendations by a dimension.
         * </p>
         * 
         * @param orderBy
         *        The ordering of recommendations by a dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(OrderBy orderBy);

        /**
         * <p>
         * The ordering of recommendations by a dimension.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrderBy.Builder} avoiding the need to
         * create one manually via {@link OrderBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrderBy.Builder#build()} is called immediately and its result is
         * passed to {@link #orderBy(OrderBy)}.
         * 
         * @param orderBy
         *        a consumer that will call methods on {@link OrderBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderBy(OrderBy)
         */
        default Builder orderBy(Consumer<OrderBy.Builder> orderBy) {
            return orderBy(OrderBy.builder().applyMutation(orderBy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostOptimizationHubRequest.BuilderImpl implements Builder {
        private Filter filter;

        private Boolean includeAllRecommendations;

        private Integer maxResults;

        private String nextToken;

        private OrderBy orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationsRequest model) {
            super(model);
            filter(model.filter);
            includeAllRecommendations(model.includeAllRecommendations);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            orderBy(model.orderBy);
        }

        public final Filter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getIncludeAllRecommendations() {
            return includeAllRecommendations;
        }

        public final void setIncludeAllRecommendations(Boolean includeAllRecommendations) {
            this.includeAllRecommendations = includeAllRecommendations;
        }

        @Override
        public final Builder includeAllRecommendations(Boolean includeAllRecommendations) {
            this.includeAllRecommendations = includeAllRecommendations;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final OrderBy.Builder getOrderBy() {
            return orderBy != null ? orderBy.toBuilder() : null;
        }

        public final void setOrderBy(OrderBy.BuilderImpl orderBy) {
            this.orderBy = orderBy != null ? orderBy.build() : null;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationsRequest build() {
            return new ListRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
