/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Cost impact of the purchase recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstancesCostCalculation implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstancesCostCalculation.Builder, ReservedInstancesCostCalculation> {
    private static final SdkField<ReservedInstancesPricing> PRICING_FIELD = SdkField
            .<ReservedInstancesPricing> builder(MarshallingType.SDK_POJO).memberName("pricing")
            .getter(getter(ReservedInstancesCostCalculation::pricing)).setter(setter(Builder::pricing))
            .constructor(ReservedInstancesPricing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricing").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReservedInstancesPricing pricing;

    private ReservedInstancesCostCalculation(BuilderImpl builder) {
        this.pricing = builder.pricing;
    }

    /**
     * <p>
     * Pricing details of the purchase recommendation.
     * </p>
     * 
     * @return Pricing details of the purchase recommendation.
     */
    public final ReservedInstancesPricing pricing() {
        return pricing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pricing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesCostCalculation)) {
            return false;
        }
        ReservedInstancesCostCalculation other = (ReservedInstancesCostCalculation) obj;
        return Objects.equals(pricing(), other.pricing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedInstancesCostCalculation").add("Pricing", pricing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pricing":
            return Optional.ofNullable(clazz.cast(pricing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesCostCalculation, T> g) {
        return obj -> g.apply((ReservedInstancesCostCalculation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstancesCostCalculation> {
        /**
         * <p>
         * Pricing details of the purchase recommendation.
         * </p>
         * 
         * @param pricing
         *        Pricing details of the purchase recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricing(ReservedInstancesPricing pricing);

        /**
         * <p>
         * Pricing details of the purchase recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservedInstancesPricing.Builder}
         * avoiding the need to create one manually via {@link ReservedInstancesPricing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservedInstancesPricing.Builder#build()} is called immediately
         * and its result is passed to {@link #pricing(ReservedInstancesPricing)}.
         * 
         * @param pricing
         *        a consumer that will call methods on {@link ReservedInstancesPricing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pricing(ReservedInstancesPricing)
         */
        default Builder pricing(Consumer<ReservedInstancesPricing.Builder> pricing) {
            return pricing(ReservedInstancesPricing.builder().applyMutation(pricing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReservedInstancesPricing pricing;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesCostCalculation model) {
            pricing(model.pricing);
        }

        public final ReservedInstancesPricing.Builder getPricing() {
            return pricing != null ? pricing.toBuilder() : null;
        }

        public final void setPricing(ReservedInstancesPricing.BuilderImpl pricing) {
            this.pricing = pricing != null ? pricing.build() : null;
        }

        @Override
        public final Builder pricing(ReservedInstancesPricing pricing) {
            this.pricing = pricing;
            return this;
        }

        @Override
        public ReservedInstancesCostCalculation build() {
            return new ReservedInstancesCostCalculation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
