/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Compute Savings Plans configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeSavingsPlansConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeSavingsPlansConfiguration.Builder, ComputeSavingsPlansConfiguration> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountScope").getter(getter(ComputeSavingsPlansConfiguration::accountScope))
            .setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountScope").build()).build();

    private static final SdkField<String> TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("term")
            .getter(getter(ComputeSavingsPlansConfiguration::term)).setter(setter(Builder::term))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(ComputeSavingsPlansConfiguration::paymentOption))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<String> HOURLY_COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hourlyCommitment").getter(getter(ComputeSavingsPlansConfiguration::hourlyCommitment))
            .setter(setter(Builder::hourlyCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hourlyCommitment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            TERM_FIELD, PAYMENT_OPTION_FIELD, HOURLY_COMMITMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountScope;

    private final String term;

    private final String paymentOption;

    private final String hourlyCommitment;

    private ComputeSavingsPlansConfiguration(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.term = builder.term;
        this.paymentOption = builder.paymentOption;
        this.hourlyCommitment = builder.hourlyCommitment;
    }

    /**
     * <p>
     * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     * including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is
     * <code>LINKED</code>, recommendations are calculated for individual member accounts only.
     * </p>
     * 
     * @return The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
     *         including the management account and member accounts if the value is set to <code>PAYER</code>. If the
     *         value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.
     */
    public final String accountScope() {
        return accountScope;
    }

    /**
     * <p>
     * The Savings Plans recommendation term in years.
     * </p>
     * 
     * @return The Savings Plans recommendation term in years.
     */
    public final String term() {
        return term;
    }

    /**
     * <p>
     * The payment option for the commitment.
     * </p>
     * 
     * @return The payment option for the commitment.
     */
    public final String paymentOption() {
        return paymentOption;
    }

    /**
     * <p>
     * The hourly commitment for the Savings Plans type.
     * </p>
     * 
     * @return The hourly commitment for the Savings Plans type.
     */
    public final String hourlyCommitment() {
        return hourlyCommitment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScope());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyCommitment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeSavingsPlansConfiguration)) {
            return false;
        }
        ComputeSavingsPlansConfiguration other = (ComputeSavingsPlansConfiguration) obj;
        return Objects.equals(accountScope(), other.accountScope()) && Objects.equals(term(), other.term())
                && Objects.equals(paymentOption(), other.paymentOption())
                && Objects.equals(hourlyCommitment(), other.hourlyCommitment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeSavingsPlansConfiguration").add("AccountScope", accountScope()).add("Term", term())
                .add("PaymentOption", paymentOption()).add("HourlyCommitment", hourlyCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountScope":
            return Optional.ofNullable(clazz.cast(accountScope()));
        case "term":
            return Optional.ofNullable(clazz.cast(term()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOption()));
        case "hourlyCommitment":
            return Optional.ofNullable(clazz.cast(hourlyCommitment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeSavingsPlansConfiguration, T> g) {
        return obj -> g.apply((ComputeSavingsPlansConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeSavingsPlansConfiguration> {
        /**
         * <p>
         * The account scope that you want your recommendations for. Amazon Web Services calculates recommendations
         * including the management account and member accounts if the value is set to <code>PAYER</code>. If the value
         * is <code>LINKED</code>, recommendations are calculated for individual member accounts only.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your recommendations for. Amazon Web Services calculates
         *        recommendations including the management account and member accounts if the value is set to
         *        <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual
         *        member accounts only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * The Savings Plans recommendation term in years.
         * </p>
         * 
         * @param term
         *        The Savings Plans recommendation term in years.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(String term);

        /**
         * <p>
         * The payment option for the commitment.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The hourly commitment for the Savings Plans type.
         * </p>
         * 
         * @param hourlyCommitment
         *        The hourly commitment for the Savings Plans type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyCommitment(String hourlyCommitment);
    }

    static final class BuilderImpl implements Builder {
        private String accountScope;

        private String term;

        private String paymentOption;

        private String hourlyCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeSavingsPlansConfiguration model) {
            accountScope(model.accountScope);
            term(model.term);
            paymentOption(model.paymentOption);
            hourlyCommitment(model.hourlyCommitment);
        }

        public final String getAccountScope() {
            return accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        public final String getTerm() {
            return term;
        }

        public final void setTerm(String term) {
            this.term = term;
        }

        @Override
        public final Builder term(String term) {
            this.term = term;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        public final String getHourlyCommitment() {
            return hourlyCommitment;
        }

        public final void setHourlyCommitment(String hourlyCommitment) {
            this.hourlyCommitment = hourlyCommitment;
        }

        @Override
        public final Builder hourlyCommitment(String hourlyCommitment) {
            this.hourlyCommitment = hourlyCommitment;
            return this;
        }

        @Override
        public ComputeSavingsPlansConfiguration build() {
            return new ComputeSavingsPlansConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
