/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Estimated discount details of the current and recommended resource configuration for a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EstimatedDiscounts implements SdkPojo, Serializable,
        ToCopyableBuilder<EstimatedDiscounts.Builder, EstimatedDiscounts> {
    private static final SdkField<Double> SAVINGS_PLANS_DISCOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("savingsPlansDiscount").getter(getter(EstimatedDiscounts::savingsPlansDiscount))
            .setter(setter(Builder::savingsPlansDiscount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlansDiscount").build())
            .build();

    private static final SdkField<Double> RESERVED_INSTANCES_DISCOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("reservedInstancesDiscount").getter(getter(EstimatedDiscounts::reservedInstancesDiscount))
            .setter(setter(Builder::reservedInstancesDiscount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedInstancesDiscount").build())
            .build();

    private static final SdkField<Double> OTHER_DISCOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("otherDiscount").getter(getter(EstimatedDiscounts::otherDiscount)).setter(setter(Builder::otherDiscount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otherDiscount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_DISCOUNT_FIELD,
            RESERVED_INSTANCES_DISCOUNT_FIELD, OTHER_DISCOUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double savingsPlansDiscount;

    private final Double reservedInstancesDiscount;

    private final Double otherDiscount;

    private EstimatedDiscounts(BuilderImpl builder) {
        this.savingsPlansDiscount = builder.savingsPlansDiscount;
        this.reservedInstancesDiscount = builder.reservedInstancesDiscount;
        this.otherDiscount = builder.otherDiscount;
    }

    /**
     * <p>
     * Estimated Savings Plans discounts.
     * </p>
     * 
     * @return Estimated Savings Plans discounts.
     */
    public final Double savingsPlansDiscount() {
        return savingsPlansDiscount;
    }

    /**
     * <p>
     * Estimated reserved instance discounts.
     * </p>
     * 
     * @return Estimated reserved instance discounts.
     */
    public final Double reservedInstancesDiscount() {
        return reservedInstancesDiscount;
    }

    /**
     * <p>
     * Estimated other discounts include all discounts that are not itemized. Itemized discounts include
     * <code>reservedInstanceDiscount</code> and <code>savingsPlansDiscount</code>.
     * </p>
     * 
     * @return Estimated other discounts include all discounts that are not itemized. Itemized discounts include
     *         <code>reservedInstanceDiscount</code> and <code>savingsPlansDiscount</code>.
     */
    public final Double otherDiscount() {
        return otherDiscount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansDiscount());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesDiscount());
        hashCode = 31 * hashCode + Objects.hashCode(otherDiscount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimatedDiscounts)) {
            return false;
        }
        EstimatedDiscounts other = (EstimatedDiscounts) obj;
        return Objects.equals(savingsPlansDiscount(), other.savingsPlansDiscount())
                && Objects.equals(reservedInstancesDiscount(), other.reservedInstancesDiscount())
                && Objects.equals(otherDiscount(), other.otherDiscount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EstimatedDiscounts").add("SavingsPlansDiscount", savingsPlansDiscount())
                .add("ReservedInstancesDiscount", reservedInstancesDiscount()).add("OtherDiscount", otherDiscount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlansDiscount":
            return Optional.ofNullable(clazz.cast(savingsPlansDiscount()));
        case "reservedInstancesDiscount":
            return Optional.ofNullable(clazz.cast(reservedInstancesDiscount()));
        case "otherDiscount":
            return Optional.ofNullable(clazz.cast(otherDiscount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EstimatedDiscounts, T> g) {
        return obj -> g.apply((EstimatedDiscounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EstimatedDiscounts> {
        /**
         * <p>
         * Estimated Savings Plans discounts.
         * </p>
         * 
         * @param savingsPlansDiscount
         *        Estimated Savings Plans discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansDiscount(Double savingsPlansDiscount);

        /**
         * <p>
         * Estimated reserved instance discounts.
         * </p>
         * 
         * @param reservedInstancesDiscount
         *        Estimated reserved instance discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesDiscount(Double reservedInstancesDiscount);

        /**
         * <p>
         * Estimated other discounts include all discounts that are not itemized. Itemized discounts include
         * <code>reservedInstanceDiscount</code> and <code>savingsPlansDiscount</code>.
         * </p>
         * 
         * @param otherDiscount
         *        Estimated other discounts include all discounts that are not itemized. Itemized discounts include
         *        <code>reservedInstanceDiscount</code> and <code>savingsPlansDiscount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherDiscount(Double otherDiscount);
    }

    static final class BuilderImpl implements Builder {
        private Double savingsPlansDiscount;

        private Double reservedInstancesDiscount;

        private Double otherDiscount;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimatedDiscounts model) {
            savingsPlansDiscount(model.savingsPlansDiscount);
            reservedInstancesDiscount(model.reservedInstancesDiscount);
            otherDiscount(model.otherDiscount);
        }

        public final Double getSavingsPlansDiscount() {
            return savingsPlansDiscount;
        }

        public final void setSavingsPlansDiscount(Double savingsPlansDiscount) {
            this.savingsPlansDiscount = savingsPlansDiscount;
        }

        @Override
        public final Builder savingsPlansDiscount(Double savingsPlansDiscount) {
            this.savingsPlansDiscount = savingsPlansDiscount;
            return this;
        }

        public final Double getReservedInstancesDiscount() {
            return reservedInstancesDiscount;
        }

        public final void setReservedInstancesDiscount(Double reservedInstancesDiscount) {
            this.reservedInstancesDiscount = reservedInstancesDiscount;
        }

        @Override
        public final Builder reservedInstancesDiscount(Double reservedInstancesDiscount) {
            this.reservedInstancesDiscount = reservedInstancesDiscount;
            return this;
        }

        public final Double getOtherDiscount() {
            return otherDiscount;
        }

        public final void setOtherDiscount(Double otherDiscount) {
            this.otherDiscount = otherDiscount;
        }

        @Override
        public final Builder otherDiscount(Double otherDiscount) {
            this.otherDiscount = otherDiscount;
            return this;
        }

        @Override
        public EstimatedDiscounts build() {
            return new EstimatedDiscounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
