/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationSummariesResponse extends CostOptimizationHubResponse implements
        ToCopyableBuilder<ListRecommendationSummariesResponse.Builder, ListRecommendationSummariesResponse> {
    private static final SdkField<Double> ESTIMATED_TOTAL_DEDUPED_SAVINGS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedTotalDedupedSavings")
            .getter(getter(ListRecommendationSummariesResponse::estimatedTotalDedupedSavings))
            .setter(setter(Builder::estimatedTotalDedupedSavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedTotalDedupedSavings")
                    .build()).build();

    private static final SdkField<List<RecommendationSummary>> ITEMS_FIELD = SdkField
            .<List<RecommendationSummary>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(ListRecommendationSummariesResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GROUP_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupBy").getter(getter(ListRecommendationSummariesResponse::groupBy)).setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currencyCode").getter(getter(ListRecommendationSummariesResponse::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecommendationSummariesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_TOTAL_DEDUPED_SAVINGS_FIELD, ITEMS_FIELD, GROUP_BY_FIELD, CURRENCY_CODE_FIELD, NEXT_TOKEN_FIELD));

    private final Double estimatedTotalDedupedSavings;

    private final List<RecommendationSummary> items;

    private final String groupBy;

    private final String currencyCode;

    private final String nextToken;

    private ListRecommendationSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.estimatedTotalDedupedSavings = builder.estimatedTotalDedupedSavings;
        this.items = builder.items;
        this.groupBy = builder.groupBy;
        this.currencyCode = builder.currencyCode;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The total overall savings for the aggregated view.
     * </p>
     * 
     * @return The total overall savings for the aggregated view.
     */
    public final Double estimatedTotalDedupedSavings() {
        return estimatedTotalDedupedSavings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of all savings recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return List of all savings recommendations.
     */
    public final List<RecommendationSummary> items() {
        return items;
    }

    /**
     * <p>
     * The dimension used to group the recommendations by.
     * </p>
     * 
     * @return The dimension used to group the recommendations by.
     */
    public final String groupBy() {
        return groupBy;
    }

    /**
     * <p>
     * The currency code used for the recommendation.
     * </p>
     * 
     * @return The currency code used for the recommendation.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTotalDedupedSavings());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationSummariesResponse)) {
            return false;
        }
        ListRecommendationSummariesResponse other = (ListRecommendationSummariesResponse) obj;
        return Objects.equals(estimatedTotalDedupedSavings(), other.estimatedTotalDedupedSavings())
                && hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(groupBy(), other.groupBy()) && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationSummariesResponse")
                .add("EstimatedTotalDedupedSavings", estimatedTotalDedupedSavings()).add("Items", hasItems() ? items() : null)
                .add("GroupBy", groupBy()).add("CurrencyCode", currencyCode()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedTotalDedupedSavings":
            return Optional.ofNullable(clazz.cast(estimatedTotalDedupedSavings()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "groupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationSummariesResponse, T> g) {
        return obj -> g.apply((ListRecommendationSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostOptimizationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecommendationSummariesResponse> {
        /**
         * <p>
         * The total overall savings for the aggregated view.
         * </p>
         * 
         * @param estimatedTotalDedupedSavings
         *        The total overall savings for the aggregated view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTotalDedupedSavings(Double estimatedTotalDedupedSavings);

        /**
         * <p>
         * List of all savings recommendations.
         * </p>
         * 
         * @param items
         *        List of all savings recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<RecommendationSummary> items);

        /**
         * <p>
         * List of all savings recommendations.
         * </p>
         * 
         * @param items
         *        List of all savings recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(RecommendationSummary... items);

        /**
         * <p>
         * List of all savings recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.RecommendationSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.RecommendationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.RecommendationSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #items(List<RecommendationSummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costoptimizationhub.model.RecommendationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<RecommendationSummary>)
         */
        Builder items(Consumer<RecommendationSummary.Builder>... items);

        /**
         * <p>
         * The dimension used to group the recommendations by.
         * </p>
         * 
         * @param groupBy
         *        The dimension used to group the recommendations by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(String groupBy);

        /**
         * <p>
         * The currency code used for the recommendation.
         * </p>
         * 
         * @param currencyCode
         *        The currency code used for the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CostOptimizationHubResponse.BuilderImpl implements Builder {
        private Double estimatedTotalDedupedSavings;

        private List<RecommendationSummary> items = DefaultSdkAutoConstructList.getInstance();

        private String groupBy;

        private String currencyCode;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationSummariesResponse model) {
            super(model);
            estimatedTotalDedupedSavings(model.estimatedTotalDedupedSavings);
            items(model.items);
            groupBy(model.groupBy);
            currencyCode(model.currencyCode);
            nextToken(model.nextToken);
        }

        public final Double getEstimatedTotalDedupedSavings() {
            return estimatedTotalDedupedSavings;
        }

        public final void setEstimatedTotalDedupedSavings(Double estimatedTotalDedupedSavings) {
            this.estimatedTotalDedupedSavings = estimatedTotalDedupedSavings;
        }

        @Override
        public final Builder estimatedTotalDedupedSavings(Double estimatedTotalDedupedSavings) {
            this.estimatedTotalDedupedSavings = estimatedTotalDedupedSavings;
            return this;
        }

        public final List<RecommendationSummary.Builder> getItems() {
            List<RecommendationSummary.Builder> result = RecommendationSummariesListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<RecommendationSummary.BuilderImpl> items) {
            this.items = RecommendationSummariesListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<RecommendationSummary> items) {
            this.items = RecommendationSummariesListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RecommendationSummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RecommendationSummary.Builder>... items) {
            items(Stream.of(items).map(c -> RecommendationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGroupBy() {
            return groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRecommendationSummariesResponse build() {
            return new ListRecommendationSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
