/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Pricing information about a Savings Plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPricing implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPricing.Builder, SavingsPlansPricing> {
    private static final SdkField<Double> MONTHLY_SAVINGS_PLANS_ELIGIBLE_COST_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("monthlySavingsPlansEligibleCost")
            .getter(getter(SavingsPlansPricing::monthlySavingsPlansEligibleCost))
            .setter(setter(Builder::monthlySavingsPlansEligibleCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlySavingsPlansEligibleCost")
                    .build()).build();

    private static final SdkField<Double> ESTIMATED_MONTHLY_COMMITMENT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedMonthlyCommitment")
            .getter(getter(SavingsPlansPricing::estimatedMonthlyCommitment))
            .setter(setter(Builder::estimatedMonthlyCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlyCommitment").build())
            .build();

    private static final SdkField<Double> SAVINGS_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("savingsPercentage").getter(getter(SavingsPlansPricing::savingsPercentage))
            .setter(setter(Builder::savingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPercentage").build()).build();

    private static final SdkField<Double> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedOnDemandCost").getter(getter(SavingsPlansPricing::estimatedOnDemandCost))
            .setter(setter(Builder::estimatedOnDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedOnDemandCost").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONTHLY_SAVINGS_PLANS_ELIGIBLE_COST_FIELD, ESTIMATED_MONTHLY_COMMITMENT_FIELD, SAVINGS_PERCENTAGE_FIELD,
            ESTIMATED_ON_DEMAND_COST_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double monthlySavingsPlansEligibleCost;

    private final Double estimatedMonthlyCommitment;

    private final Double savingsPercentage;

    private final Double estimatedOnDemandCost;

    private SavingsPlansPricing(BuilderImpl builder) {
        this.monthlySavingsPlansEligibleCost = builder.monthlySavingsPlansEligibleCost;
        this.estimatedMonthlyCommitment = builder.estimatedMonthlyCommitment;
        this.savingsPercentage = builder.savingsPercentage;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
    }

    /**
     * <p>
     * The cost of paying for the recommended Savings Plan monthly.
     * </p>
     * 
     * @return The cost of paying for the recommended Savings Plan monthly.
     */
    public final Double monthlySavingsPlansEligibleCost() {
        return monthlySavingsPlansEligibleCost;
    }

    /**
     * <p>
     * Estimated monthly commitment for the Savings Plan.
     * </p>
     * 
     * @return Estimated monthly commitment for the Savings Plan.
     */
    public final Double estimatedMonthlyCommitment() {
        return estimatedMonthlyCommitment;
    }

    /**
     * <p>
     * Estimated savings as a percentage of your overall costs after buying the Savings Plan.
     * </p>
     * 
     * @return Estimated savings as a percentage of your overall costs after buying the Savings Plan.
     */
    public final Double savingsPercentage() {
        return savingsPercentage;
    }

    /**
     * <p>
     * Estimated On-Demand cost you will pay after buying the Savings Plan.
     * </p>
     * 
     * @return Estimated On-Demand cost you will pay after buying the Savings Plan.
     */
    public final Double estimatedOnDemandCost() {
        return estimatedOnDemandCost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monthlySavingsPlansEligibleCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlyCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCost());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPricing)) {
            return false;
        }
        SavingsPlansPricing other = (SavingsPlansPricing) obj;
        return Objects.equals(monthlySavingsPlansEligibleCost(), other.monthlySavingsPlansEligibleCost())
                && Objects.equals(estimatedMonthlyCommitment(), other.estimatedMonthlyCommitment())
                && Objects.equals(savingsPercentage(), other.savingsPercentage())
                && Objects.equals(estimatedOnDemandCost(), other.estimatedOnDemandCost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansPricing").add("MonthlySavingsPlansEligibleCost", monthlySavingsPlansEligibleCost())
                .add("EstimatedMonthlyCommitment", estimatedMonthlyCommitment()).add("SavingsPercentage", savingsPercentage())
                .add("EstimatedOnDemandCost", estimatedOnDemandCost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monthlySavingsPlansEligibleCost":
            return Optional.ofNullable(clazz.cast(monthlySavingsPlansEligibleCost()));
        case "estimatedMonthlyCommitment":
            return Optional.ofNullable(clazz.cast(estimatedMonthlyCommitment()));
        case "savingsPercentage":
            return Optional.ofNullable(clazz.cast(savingsPercentage()));
        case "estimatedOnDemandCost":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPricing, T> g) {
        return obj -> g.apply((SavingsPlansPricing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPricing> {
        /**
         * <p>
         * The cost of paying for the recommended Savings Plan monthly.
         * </p>
         * 
         * @param monthlySavingsPlansEligibleCost
         *        The cost of paying for the recommended Savings Plan monthly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlySavingsPlansEligibleCost(Double monthlySavingsPlansEligibleCost);

        /**
         * <p>
         * Estimated monthly commitment for the Savings Plan.
         * </p>
         * 
         * @param estimatedMonthlyCommitment
         *        Estimated monthly commitment for the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlyCommitment(Double estimatedMonthlyCommitment);

        /**
         * <p>
         * Estimated savings as a percentage of your overall costs after buying the Savings Plan.
         * </p>
         * 
         * @param savingsPercentage
         *        Estimated savings as a percentage of your overall costs after buying the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPercentage(Double savingsPercentage);

        /**
         * <p>
         * Estimated On-Demand cost you will pay after buying the Savings Plan.
         * </p>
         * 
         * @param estimatedOnDemandCost
         *        Estimated On-Demand cost you will pay after buying the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCost(Double estimatedOnDemandCost);
    }

    static final class BuilderImpl implements Builder {
        private Double monthlySavingsPlansEligibleCost;

        private Double estimatedMonthlyCommitment;

        private Double savingsPercentage;

        private Double estimatedOnDemandCost;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPricing model) {
            monthlySavingsPlansEligibleCost(model.monthlySavingsPlansEligibleCost);
            estimatedMonthlyCommitment(model.estimatedMonthlyCommitment);
            savingsPercentage(model.savingsPercentage);
            estimatedOnDemandCost(model.estimatedOnDemandCost);
        }

        public final Double getMonthlySavingsPlansEligibleCost() {
            return monthlySavingsPlansEligibleCost;
        }

        public final void setMonthlySavingsPlansEligibleCost(Double monthlySavingsPlansEligibleCost) {
            this.monthlySavingsPlansEligibleCost = monthlySavingsPlansEligibleCost;
        }

        @Override
        public final Builder monthlySavingsPlansEligibleCost(Double monthlySavingsPlansEligibleCost) {
            this.monthlySavingsPlansEligibleCost = monthlySavingsPlansEligibleCost;
            return this;
        }

        public final Double getEstimatedMonthlyCommitment() {
            return estimatedMonthlyCommitment;
        }

        public final void setEstimatedMonthlyCommitment(Double estimatedMonthlyCommitment) {
            this.estimatedMonthlyCommitment = estimatedMonthlyCommitment;
        }

        @Override
        public final Builder estimatedMonthlyCommitment(Double estimatedMonthlyCommitment) {
            this.estimatedMonthlyCommitment = estimatedMonthlyCommitment;
            return this;
        }

        public final Double getSavingsPercentage() {
            return savingsPercentage;
        }

        public final void setSavingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
        }

        @Override
        public final Builder savingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
            return this;
        }

        public final Double getEstimatedOnDemandCost() {
            return estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        @Override
        public SavingsPlansPricing build() {
            return new SavingsPlansPricing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
