/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of rightsizing recommendations, including de-duped savings from all types of recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationSummary.Builder, RecommendationSummary> {
    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(RecommendationSummary::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<Double> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedMonthlySavings").getter(getter(RecommendationSummary::estimatedMonthlySavings))
            .setter(setter(Builder::estimatedMonthlySavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build())
            .build();

    private static final SdkField<Integer> RECOMMENDATION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("recommendationCount").getter(getter(RecommendationSummary::recommendationCount))
            .setter(setter(Builder::recommendationCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD,
            ESTIMATED_MONTHLY_SAVINGS_FIELD, RECOMMENDATION_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String group;

    private final Double estimatedMonthlySavings;

    private final Integer recommendationCount;

    private RecommendationSummary(BuilderImpl builder) {
        this.group = builder.group;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.recommendationCount = builder.recommendationCount;
    }

    /**
     * <p>
     * The grouping of recommendations.
     * </p>
     * 
     * @return The grouping of recommendations.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The estimated total savings resulting from modifications, on a monthly basis.
     * </p>
     * 
     * @return The estimated total savings resulting from modifications, on a monthly basis.
     */
    public final Double estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    /**
     * <p>
     * The total number of instance recommendations.
     * </p>
     * 
     * @return The total number of instance recommendations.
     */
    public final Integer recommendationCount() {
        return recommendationCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary) obj;
        return Objects.equals(group(), other.group())
                && Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings())
                && Objects.equals(recommendationCount(), other.recommendationCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationSummary").add("Group", group())
                .add("EstimatedMonthlySavings", estimatedMonthlySavings()).add("RecommendationCount", recommendationCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "estimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        case "recommendationCount":
            return Optional.ofNullable(clazz.cast(recommendationCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationSummary> {
        /**
         * <p>
         * The grouping of recommendations.
         * </p>
         * 
         * @param group
         *        The grouping of recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The estimated total savings resulting from modifications, on a monthly basis.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        The estimated total savings resulting from modifications, on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(Double estimatedMonthlySavings);

        /**
         * <p>
         * The total number of instance recommendations.
         * </p>
         * 
         * @param recommendationCount
         *        The total number of instance recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationCount(Integer recommendationCount);
    }

    static final class BuilderImpl implements Builder {
        private String group;

        private Double estimatedMonthlySavings;

        private Integer recommendationCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            group(model.group);
            estimatedMonthlySavings(model.estimatedMonthlySavings);
            recommendationCount(model.recommendationCount);
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final Double getEstimatedMonthlySavings() {
            return estimatedMonthlySavings;
        }

        public final void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final Integer getRecommendationCount() {
            return recommendationCount;
        }

        public final void setRecommendationCount(Integer recommendationCount) {
            this.recommendationCount = recommendationCount;
        }

        @Override
        public final Builder recommendationCount(Integer recommendationCount) {
            this.recommendationCount = recommendationCount;
            return this;
        }

        @Override
        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
