/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains pricing information about the specified resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePricing implements SdkPojo, Serializable, ToCopyableBuilder<ResourcePricing.Builder, ResourcePricing> {
    private static final SdkField<Double> ESTIMATED_COST_BEFORE_DISCOUNTS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedCostBeforeDiscounts")
            .getter(getter(ResourcePricing::estimatedCostBeforeDiscounts))
            .setter(setter(Builder::estimatedCostBeforeDiscounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCostBeforeDiscounts")
                    .build()).build();

    private static final SdkField<Double> ESTIMATED_NET_UNUSED_AMORTIZED_COMMITMENTS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedNetUnusedAmortizedCommitments")
            .getter(getter(ResourcePricing::estimatedNetUnusedAmortizedCommitments))
            .setter(setter(Builder::estimatedNetUnusedAmortizedCommitments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("estimatedNetUnusedAmortizedCommitments").build()).build();

    private static final SdkField<EstimatedDiscounts> ESTIMATED_DISCOUNTS_FIELD = SdkField
            .<EstimatedDiscounts> builder(MarshallingType.SDK_POJO).memberName("estimatedDiscounts")
            .getter(getter(ResourcePricing::estimatedDiscounts)).setter(setter(Builder::estimatedDiscounts))
            .constructor(EstimatedDiscounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedDiscounts").build())
            .build();

    private static final SdkField<Double> ESTIMATED_COST_AFTER_DISCOUNTS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedCostAfterDiscounts")
            .getter(getter(ResourcePricing::estimatedCostAfterDiscounts))
            .setter(setter(Builder::estimatedCostAfterDiscounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCostAfterDiscounts")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_COST_BEFORE_DISCOUNTS_FIELD, ESTIMATED_NET_UNUSED_AMORTIZED_COMMITMENTS_FIELD, ESTIMATED_DISCOUNTS_FIELD,
            ESTIMATED_COST_AFTER_DISCOUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double estimatedCostBeforeDiscounts;

    private final Double estimatedNetUnusedAmortizedCommitments;

    private final EstimatedDiscounts estimatedDiscounts;

    private final Double estimatedCostAfterDiscounts;

    private ResourcePricing(BuilderImpl builder) {
        this.estimatedCostBeforeDiscounts = builder.estimatedCostBeforeDiscounts;
        this.estimatedNetUnusedAmortizedCommitments = builder.estimatedNetUnusedAmortizedCommitments;
        this.estimatedDiscounts = builder.estimatedDiscounts;
        this.estimatedCostAfterDiscounts = builder.estimatedCostAfterDiscounts;
    }

    /**
     * <p>
     * The savings estimate using Amazon Web Services public pricing without incorporating any discounts.
     * </p>
     * 
     * @return The savings estimate using Amazon Web Services public pricing without incorporating any discounts.
     */
    public final Double estimatedCostBeforeDiscounts() {
        return estimatedCostBeforeDiscounts;
    }

    /**
     * <p>
     * The estimated net unused amortized commitment for the recommendation.
     * </p>
     * 
     * @return The estimated net unused amortized commitment for the recommendation.
     */
    public final Double estimatedNetUnusedAmortizedCommitments() {
        return estimatedNetUnusedAmortizedCommitments;
    }

    /**
     * <p>
     * The estimated discounts for a recommendation.
     * </p>
     * 
     * @return The estimated discounts for a recommendation.
     */
    public final EstimatedDiscounts estimatedDiscounts() {
        return estimatedDiscounts;
    }

    /**
     * <p>
     * The savings estimate incorporating all discounts with Amazon Web Services, such as Reserved Instances and Savings
     * Plans.
     * </p>
     * 
     * @return The savings estimate incorporating all discounts with Amazon Web Services, such as Reserved Instances and
     *         Savings Plans.
     */
    public final Double estimatedCostAfterDiscounts() {
        return estimatedCostAfterDiscounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCostBeforeDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedNetUnusedAmortizedCommitments());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCostAfterDiscounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePricing)) {
            return false;
        }
        ResourcePricing other = (ResourcePricing) obj;
        return Objects.equals(estimatedCostBeforeDiscounts(), other.estimatedCostBeforeDiscounts())
                && Objects.equals(estimatedNetUnusedAmortizedCommitments(), other.estimatedNetUnusedAmortizedCommitments())
                && Objects.equals(estimatedDiscounts(), other.estimatedDiscounts())
                && Objects.equals(estimatedCostAfterDiscounts(), other.estimatedCostAfterDiscounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcePricing").add("EstimatedCostBeforeDiscounts", estimatedCostBeforeDiscounts())
                .add("EstimatedNetUnusedAmortizedCommitments", estimatedNetUnusedAmortizedCommitments())
                .add("EstimatedDiscounts", estimatedDiscounts())
                .add("EstimatedCostAfterDiscounts", estimatedCostAfterDiscounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedCostBeforeDiscounts":
            return Optional.ofNullable(clazz.cast(estimatedCostBeforeDiscounts()));
        case "estimatedNetUnusedAmortizedCommitments":
            return Optional.ofNullable(clazz.cast(estimatedNetUnusedAmortizedCommitments()));
        case "estimatedDiscounts":
            return Optional.ofNullable(clazz.cast(estimatedDiscounts()));
        case "estimatedCostAfterDiscounts":
            return Optional.ofNullable(clazz.cast(estimatedCostAfterDiscounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePricing, T> g) {
        return obj -> g.apply((ResourcePricing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePricing> {
        /**
         * <p>
         * The savings estimate using Amazon Web Services public pricing without incorporating any discounts.
         * </p>
         * 
         * @param estimatedCostBeforeDiscounts
         *        The savings estimate using Amazon Web Services public pricing without incorporating any discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCostBeforeDiscounts(Double estimatedCostBeforeDiscounts);

        /**
         * <p>
         * The estimated net unused amortized commitment for the recommendation.
         * </p>
         * 
         * @param estimatedNetUnusedAmortizedCommitments
         *        The estimated net unused amortized commitment for the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedNetUnusedAmortizedCommitments(Double estimatedNetUnusedAmortizedCommitments);

        /**
         * <p>
         * The estimated discounts for a recommendation.
         * </p>
         * 
         * @param estimatedDiscounts
         *        The estimated discounts for a recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedDiscounts(EstimatedDiscounts estimatedDiscounts);

        /**
         * <p>
         * The estimated discounts for a recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EstimatedDiscounts.Builder} avoiding the
         * need to create one manually via {@link EstimatedDiscounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EstimatedDiscounts.Builder#build()} is called immediately and its
         * result is passed to {@link #estimatedDiscounts(EstimatedDiscounts)}.
         * 
         * @param estimatedDiscounts
         *        a consumer that will call methods on {@link EstimatedDiscounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #estimatedDiscounts(EstimatedDiscounts)
         */
        default Builder estimatedDiscounts(Consumer<EstimatedDiscounts.Builder> estimatedDiscounts) {
            return estimatedDiscounts(EstimatedDiscounts.builder().applyMutation(estimatedDiscounts).build());
        }

        /**
         * <p>
         * The savings estimate incorporating all discounts with Amazon Web Services, such as Reserved Instances and
         * Savings Plans.
         * </p>
         * 
         * @param estimatedCostAfterDiscounts
         *        The savings estimate incorporating all discounts with Amazon Web Services, such as Reserved Instances
         *        and Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCostAfterDiscounts(Double estimatedCostAfterDiscounts);
    }

    static final class BuilderImpl implements Builder {
        private Double estimatedCostBeforeDiscounts;

        private Double estimatedNetUnusedAmortizedCommitments;

        private EstimatedDiscounts estimatedDiscounts;

        private Double estimatedCostAfterDiscounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePricing model) {
            estimatedCostBeforeDiscounts(model.estimatedCostBeforeDiscounts);
            estimatedNetUnusedAmortizedCommitments(model.estimatedNetUnusedAmortizedCommitments);
            estimatedDiscounts(model.estimatedDiscounts);
            estimatedCostAfterDiscounts(model.estimatedCostAfterDiscounts);
        }

        public final Double getEstimatedCostBeforeDiscounts() {
            return estimatedCostBeforeDiscounts;
        }

        public final void setEstimatedCostBeforeDiscounts(Double estimatedCostBeforeDiscounts) {
            this.estimatedCostBeforeDiscounts = estimatedCostBeforeDiscounts;
        }

        @Override
        public final Builder estimatedCostBeforeDiscounts(Double estimatedCostBeforeDiscounts) {
            this.estimatedCostBeforeDiscounts = estimatedCostBeforeDiscounts;
            return this;
        }

        public final Double getEstimatedNetUnusedAmortizedCommitments() {
            return estimatedNetUnusedAmortizedCommitments;
        }

        public final void setEstimatedNetUnusedAmortizedCommitments(Double estimatedNetUnusedAmortizedCommitments) {
            this.estimatedNetUnusedAmortizedCommitments = estimatedNetUnusedAmortizedCommitments;
        }

        @Override
        public final Builder estimatedNetUnusedAmortizedCommitments(Double estimatedNetUnusedAmortizedCommitments) {
            this.estimatedNetUnusedAmortizedCommitments = estimatedNetUnusedAmortizedCommitments;
            return this;
        }

        public final EstimatedDiscounts.Builder getEstimatedDiscounts() {
            return estimatedDiscounts != null ? estimatedDiscounts.toBuilder() : null;
        }

        public final void setEstimatedDiscounts(EstimatedDiscounts.BuilderImpl estimatedDiscounts) {
            this.estimatedDiscounts = estimatedDiscounts != null ? estimatedDiscounts.build() : null;
        }

        @Override
        public final Builder estimatedDiscounts(EstimatedDiscounts estimatedDiscounts) {
            this.estimatedDiscounts = estimatedDiscounts;
            return this;
        }

        public final Double getEstimatedCostAfterDiscounts() {
            return estimatedCostAfterDiscounts;
        }

        public final void setEstimatedCostAfterDiscounts(Double estimatedCostAfterDiscounts) {
            this.estimatedCostAfterDiscounts = estimatedCostAfterDiscounts;
        }

        @Override
        public final Builder estimatedCostAfterDiscounts(Double estimatedCostAfterDiscounts) {
            this.estimatedCostAfterDiscounts = estimatedCostAfterDiscounts;
            return this;
        }

        @Override
        public ResourcePricing build() {
            return new ResourcePricing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
