/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RDS reserved instances configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsReservedInstancesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsReservedInstancesConfiguration.Builder, RdsReservedInstancesConfiguration> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountScope").getter(getter(RdsReservedInstancesConfiguration::accountScope))
            .setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountScope").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(RdsReservedInstancesConfiguration::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> NORMALIZED_UNITS_TO_PURCHASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("normalizedUnitsToPurchase").getter(getter(RdsReservedInstancesConfiguration::normalizedUnitsToPurchase))
            .setter(setter(Builder::normalizedUnitsToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("normalizedUnitsToPurchase").build())
            .build();

    private static final SdkField<String> TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("term")
            .getter(getter(RdsReservedInstancesConfiguration::term)).setter(setter(Builder::term))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(RdsReservedInstancesConfiguration::paymentOption))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<String> NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("numberOfInstancesToPurchase")
            .getter(getter(RdsReservedInstancesConfiguration::numberOfInstancesToPurchase))
            .setter(setter(Builder::numberOfInstancesToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfInstancesToPurchase")
                    .build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceFamily").getter(getter(RdsReservedInstancesConfiguration::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceFamily").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(RdsReservedInstancesConfiguration::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reservedInstancesRegion").getter(getter(RdsReservedInstancesConfiguration::reservedInstancesRegion))
            .setter(setter(Builder::reservedInstancesRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedInstancesRegion").build())
            .build();

    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sizeFlexEligible").getter(getter(RdsReservedInstancesConfiguration::sizeFlexEligible))
            .setter(setter(Builder::sizeFlexEligible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeFlexEligible").build()).build();

    private static final SdkField<String> CURRENT_GENERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentGeneration").getter(getter(RdsReservedInstancesConfiguration::currentGeneration))
            .setter(setter(Builder::currentGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentGeneration").build()).build();

    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upfrontCost").getter(getter(RdsReservedInstancesConfiguration::upfrontCost))
            .setter(setter(Builder::upfrontCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontCost").build()).build();

    private static final SdkField<String> MONTHLY_RECURRING_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monthlyRecurringCost").getter(getter(RdsReservedInstancesConfiguration::monthlyRecurringCost))
            .setter(setter(Builder::monthlyRecurringCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyRecurringCost").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseModel").getter(getter(RdsReservedInstancesConfiguration::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()).build();

    private static final SdkField<String> DATABASE_EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseEdition").getter(getter(RdsReservedInstancesConfiguration::databaseEdition))
            .setter(setter(Builder::databaseEdition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseEdition").build()).build();

    private static final SdkField<String> DATABASE_ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseEngine").getter(getter(RdsReservedInstancesConfiguration::databaseEngine))
            .setter(setter(Builder::databaseEngine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseEngine").build()).build();

    private static final SdkField<String> DEPLOYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentOption").getter(getter(RdsReservedInstancesConfiguration::deploymentOption))
            .setter(setter(Builder::deploymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            SERVICE_FIELD, NORMALIZED_UNITS_TO_PURCHASE_FIELD, TERM_FIELD, PAYMENT_OPTION_FIELD,
            NUMBER_OF_INSTANCES_TO_PURCHASE_FIELD, INSTANCE_FAMILY_FIELD, INSTANCE_TYPE_FIELD, RESERVED_INSTANCES_REGION_FIELD,
            SIZE_FLEX_ELIGIBLE_FIELD, CURRENT_GENERATION_FIELD, UPFRONT_COST_FIELD, MONTHLY_RECURRING_COST_FIELD,
            LICENSE_MODEL_FIELD, DATABASE_EDITION_FIELD, DATABASE_ENGINE_FIELD, DEPLOYMENT_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountScope;

    private final String service;

    private final String normalizedUnitsToPurchase;

    private final String term;

    private final String paymentOption;

    private final String numberOfInstancesToPurchase;

    private final String instanceFamily;

    private final String instanceType;

    private final String reservedInstancesRegion;

    private final Boolean sizeFlexEligible;

    private final String currentGeneration;

    private final String upfrontCost;

    private final String monthlyRecurringCost;

    private final String licenseModel;

    private final String databaseEdition;

    private final String databaseEngine;

    private final String deploymentOption;

    private RdsReservedInstancesConfiguration(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.service = builder.service;
        this.normalizedUnitsToPurchase = builder.normalizedUnitsToPurchase;
        this.term = builder.term;
        this.paymentOption = builder.paymentOption;
        this.numberOfInstancesToPurchase = builder.numberOfInstancesToPurchase;
        this.instanceFamily = builder.instanceFamily;
        this.instanceType = builder.instanceType;
        this.reservedInstancesRegion = builder.reservedInstancesRegion;
        this.sizeFlexEligible = builder.sizeFlexEligible;
        this.currentGeneration = builder.currentGeneration;
        this.upfrontCost = builder.upfrontCost;
        this.monthlyRecurringCost = builder.monthlyRecurringCost;
        this.licenseModel = builder.licenseModel;
        this.databaseEdition = builder.databaseEdition;
        this.databaseEngine = builder.databaseEngine;
        this.deploymentOption = builder.deploymentOption;
    }

    /**
     * <p>
     * The account scope that you want your recommendations for.
     * </p>
     * 
     * @return The account scope that you want your recommendations for.
     */
    public final String accountScope() {
        return accountScope;
    }

    /**
     * <p>
     * The service that you want your recommendations for.
     * </p>
     * 
     * @return The service that you want your recommendations for.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The number of normalized units that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The number of normalized units that Amazon Web Services recommends that you purchase.
     */
    public final String normalizedUnitsToPurchase() {
        return normalizedUnitsToPurchase;
    }

    /**
     * <p>
     * The reserved instances recommendation term in years.
     * </p>
     * 
     * @return The reserved instances recommendation term in years.
     */
    public final String term() {
        return term;
    }

    /**
     * <p>
     * The payment option for the commitment.
     * </p>
     * 
     * @return The payment option for the commitment.
     */
    public final String paymentOption() {
        return paymentOption;
    }

    /**
     * <p>
     * The number of instances that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The number of instances that Amazon Web Services recommends that you purchase.
     */
    public final String numberOfInstancesToPurchase() {
        return numberOfInstancesToPurchase;
    }

    /**
     * <p>
     * The instance family of the recommended reservation.
     * </p>
     * 
     * @return The instance family of the recommended reservation.
     */
    public final String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The type of instance that Amazon Web Services recommends.
     * </p>
     * 
     * @return The type of instance that Amazon Web Services recommends.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the commitment.
     * </p>
     * 
     * @return The Amazon Web Services Region of the commitment.
     */
    public final String reservedInstancesRegion() {
        return reservedInstancesRegion;
    }

    /**
     * <p>
     * Determines whether the recommendation is size flexible.
     * </p>
     * 
     * @return Determines whether the recommendation is size flexible.
     */
    public final Boolean sizeFlexEligible() {
        return sizeFlexEligible;
    }

    /**
     * <p>
     * Determines whether the recommendation is for a current generation instance.
     * </p>
     * 
     * @return Determines whether the recommendation is for a current generation instance.
     */
    public final String currentGeneration() {
        return currentGeneration;
    }

    /**
     * <p>
     * How much purchasing this instance costs you upfront.
     * </p>
     * 
     * @return How much purchasing this instance costs you upfront.
     */
    public final String upfrontCost() {
        return upfrontCost;
    }

    /**
     * <p>
     * How much purchasing this instance costs you on a monthly basis.
     * </p>
     * 
     * @return How much purchasing this instance costs you on a monthly basis.
     */
    public final String monthlyRecurringCost() {
        return monthlyRecurringCost;
    }

    /**
     * <p>
     * The license model that the recommended reservation supports.
     * </p>
     * 
     * @return The license model that the recommended reservation supports.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The database edition that the recommended reservation supports.
     * </p>
     * 
     * @return The database edition that the recommended reservation supports.
     */
    public final String databaseEdition() {
        return databaseEdition;
    }

    /**
     * <p>
     * The database engine that the recommended reservation supports.
     * </p>
     * 
     * @return The database engine that the recommended reservation supports.
     */
    public final String databaseEngine() {
        return databaseEngine;
    }

    /**
     * <p>
     * Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation with a
     * backup in a second Availability Zone.
     * </p>
     * 
     * @return Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation
     *         with a backup in a second Availability Zone.
     */
    public final String deploymentOption() {
        return deploymentOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScope());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(normalizedUnitsToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfInstancesToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesRegion());
        hashCode = 31 * hashCode + Objects.hashCode(sizeFlexEligible());
        hashCode = 31 * hashCode + Objects.hashCode(currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyRecurringCost());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(databaseEdition());
        hashCode = 31 * hashCode + Objects.hashCode(databaseEngine());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsReservedInstancesConfiguration)) {
            return false;
        }
        RdsReservedInstancesConfiguration other = (RdsReservedInstancesConfiguration) obj;
        return Objects.equals(accountScope(), other.accountScope()) && Objects.equals(service(), other.service())
                && Objects.equals(normalizedUnitsToPurchase(), other.normalizedUnitsToPurchase())
                && Objects.equals(term(), other.term()) && Objects.equals(paymentOption(), other.paymentOption())
                && Objects.equals(numberOfInstancesToPurchase(), other.numberOfInstancesToPurchase())
                && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(reservedInstancesRegion(), other.reservedInstancesRegion())
                && Objects.equals(sizeFlexEligible(), other.sizeFlexEligible())
                && Objects.equals(currentGeneration(), other.currentGeneration())
                && Objects.equals(upfrontCost(), other.upfrontCost())
                && Objects.equals(monthlyRecurringCost(), other.monthlyRecurringCost())
                && Objects.equals(licenseModel(), other.licenseModel())
                && Objects.equals(databaseEdition(), other.databaseEdition())
                && Objects.equals(databaseEngine(), other.databaseEngine())
                && Objects.equals(deploymentOption(), other.deploymentOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsReservedInstancesConfiguration").add("AccountScope", accountScope())
                .add("Service", service()).add("NormalizedUnitsToPurchase", normalizedUnitsToPurchase()).add("Term", term())
                .add("PaymentOption", paymentOption()).add("NumberOfInstancesToPurchase", numberOfInstancesToPurchase())
                .add("InstanceFamily", instanceFamily()).add("InstanceType", instanceType())
                .add("ReservedInstancesRegion", reservedInstancesRegion()).add("SizeFlexEligible", sizeFlexEligible())
                .add("CurrentGeneration", currentGeneration()).add("UpfrontCost", upfrontCost())
                .add("MonthlyRecurringCost", monthlyRecurringCost()).add("LicenseModel", licenseModel())
                .add("DatabaseEdition", databaseEdition()).add("DatabaseEngine", databaseEngine())
                .add("DeploymentOption", deploymentOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountScope":
            return Optional.ofNullable(clazz.cast(accountScope()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "normalizedUnitsToPurchase":
            return Optional.ofNullable(clazz.cast(normalizedUnitsToPurchase()));
        case "term":
            return Optional.ofNullable(clazz.cast(term()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOption()));
        case "numberOfInstancesToPurchase":
            return Optional.ofNullable(clazz.cast(numberOfInstancesToPurchase()));
        case "instanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "reservedInstancesRegion":
            return Optional.ofNullable(clazz.cast(reservedInstancesRegion()));
        case "sizeFlexEligible":
            return Optional.ofNullable(clazz.cast(sizeFlexEligible()));
        case "currentGeneration":
            return Optional.ofNullable(clazz.cast(currentGeneration()));
        case "upfrontCost":
            return Optional.ofNullable(clazz.cast(upfrontCost()));
        case "monthlyRecurringCost":
            return Optional.ofNullable(clazz.cast(monthlyRecurringCost()));
        case "licenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "databaseEdition":
            return Optional.ofNullable(clazz.cast(databaseEdition()));
        case "databaseEngine":
            return Optional.ofNullable(clazz.cast(databaseEngine()));
        case "deploymentOption":
            return Optional.ofNullable(clazz.cast(deploymentOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsReservedInstancesConfiguration, T> g) {
        return obj -> g.apply((RdsReservedInstancesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsReservedInstancesConfiguration> {
        /**
         * <p>
         * The account scope that you want your recommendations for.
         * </p>
         * 
         * @param accountScope
         *        The account scope that you want your recommendations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * The service that you want your recommendations for.
         * </p>
         * 
         * @param service
         *        The service that you want your recommendations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The number of normalized units that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param normalizedUnitsToPurchase
         *        The number of normalized units that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normalizedUnitsToPurchase(String normalizedUnitsToPurchase);

        /**
         * <p>
         * The reserved instances recommendation term in years.
         * </p>
         * 
         * @param term
         *        The reserved instances recommendation term in years.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(String term);

        /**
         * <p>
         * The payment option for the commitment.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The number of instances that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param numberOfInstancesToPurchase
         *        The number of instances that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfInstancesToPurchase(String numberOfInstancesToPurchase);

        /**
         * <p>
         * The instance family of the recommended reservation.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The type of instance that Amazon Web Services recommends.
         * </p>
         * 
         * @param instanceType
         *        The type of instance that Amazon Web Services recommends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon Web Services Region of the commitment.
         * </p>
         * 
         * @param reservedInstancesRegion
         *        The Amazon Web Services Region of the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesRegion(String reservedInstancesRegion);

        /**
         * <p>
         * Determines whether the recommendation is size flexible.
         * </p>
         * 
         * @param sizeFlexEligible
         *        Determines whether the recommendation is size flexible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeFlexEligible(Boolean sizeFlexEligible);

        /**
         * <p>
         * Determines whether the recommendation is for a current generation instance.
         * </p>
         * 
         * @param currentGeneration
         *        Determines whether the recommendation is for a current generation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentGeneration(String currentGeneration);

        /**
         * <p>
         * How much purchasing this instance costs you upfront.
         * </p>
         * 
         * @param upfrontCost
         *        How much purchasing this instance costs you upfront.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontCost(String upfrontCost);

        /**
         * <p>
         * How much purchasing this instance costs you on a monthly basis.
         * </p>
         * 
         * @param monthlyRecurringCost
         *        How much purchasing this instance costs you on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyRecurringCost(String monthlyRecurringCost);

        /**
         * <p>
         * The license model that the recommended reservation supports.
         * </p>
         * 
         * @param licenseModel
         *        The license model that the recommended reservation supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The database edition that the recommended reservation supports.
         * </p>
         * 
         * @param databaseEdition
         *        The database edition that the recommended reservation supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseEdition(String databaseEdition);

        /**
         * <p>
         * The database engine that the recommended reservation supports.
         * </p>
         * 
         * @param databaseEngine
         *        The database engine that the recommended reservation supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseEngine(String databaseEngine);

        /**
         * <p>
         * Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation
         * with a backup in a second Availability Zone.
         * </p>
         * 
         * @param deploymentOption
         *        Determines whether the recommendation is for a reservation in a single Availability Zone or a
         *        reservation with a backup in a second Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentOption(String deploymentOption);
    }

    static final class BuilderImpl implements Builder {
        private String accountScope;

        private String service;

        private String normalizedUnitsToPurchase;

        private String term;

        private String paymentOption;

        private String numberOfInstancesToPurchase;

        private String instanceFamily;

        private String instanceType;

        private String reservedInstancesRegion;

        private Boolean sizeFlexEligible;

        private String currentGeneration;

        private String upfrontCost;

        private String monthlyRecurringCost;

        private String licenseModel;

        private String databaseEdition;

        private String databaseEngine;

        private String deploymentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsReservedInstancesConfiguration model) {
            accountScope(model.accountScope);
            service(model.service);
            normalizedUnitsToPurchase(model.normalizedUnitsToPurchase);
            term(model.term);
            paymentOption(model.paymentOption);
            numberOfInstancesToPurchase(model.numberOfInstancesToPurchase);
            instanceFamily(model.instanceFamily);
            instanceType(model.instanceType);
            reservedInstancesRegion(model.reservedInstancesRegion);
            sizeFlexEligible(model.sizeFlexEligible);
            currentGeneration(model.currentGeneration);
            upfrontCost(model.upfrontCost);
            monthlyRecurringCost(model.monthlyRecurringCost);
            licenseModel(model.licenseModel);
            databaseEdition(model.databaseEdition);
            databaseEngine(model.databaseEngine);
            deploymentOption(model.deploymentOption);
        }

        public final String getAccountScope() {
            return accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getNormalizedUnitsToPurchase() {
            return normalizedUnitsToPurchase;
        }

        public final void setNormalizedUnitsToPurchase(String normalizedUnitsToPurchase) {
            this.normalizedUnitsToPurchase = normalizedUnitsToPurchase;
        }

        @Override
        public final Builder normalizedUnitsToPurchase(String normalizedUnitsToPurchase) {
            this.normalizedUnitsToPurchase = normalizedUnitsToPurchase;
            return this;
        }

        public final String getTerm() {
            return term;
        }

        public final void setTerm(String term) {
            this.term = term;
        }

        @Override
        public final Builder term(String term) {
            this.term = term;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        public final String getNumberOfInstancesToPurchase() {
            return numberOfInstancesToPurchase;
        }

        public final void setNumberOfInstancesToPurchase(String numberOfInstancesToPurchase) {
            this.numberOfInstancesToPurchase = numberOfInstancesToPurchase;
        }

        @Override
        public final Builder numberOfInstancesToPurchase(String numberOfInstancesToPurchase) {
            this.numberOfInstancesToPurchase = numberOfInstancesToPurchase;
            return this;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getReservedInstancesRegion() {
            return reservedInstancesRegion;
        }

        public final void setReservedInstancesRegion(String reservedInstancesRegion) {
            this.reservedInstancesRegion = reservedInstancesRegion;
        }

        @Override
        public final Builder reservedInstancesRegion(String reservedInstancesRegion) {
            this.reservedInstancesRegion = reservedInstancesRegion;
            return this;
        }

        public final Boolean getSizeFlexEligible() {
            return sizeFlexEligible;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public final String getCurrentGeneration() {
            return currentGeneration;
        }

        public final void setCurrentGeneration(String currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        @Override
        public final Builder currentGeneration(String currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final String getUpfrontCost() {
            return upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final String getMonthlyRecurringCost() {
            return monthlyRecurringCost;
        }

        public final void setMonthlyRecurringCost(String monthlyRecurringCost) {
            this.monthlyRecurringCost = monthlyRecurringCost;
        }

        @Override
        public final Builder monthlyRecurringCost(String monthlyRecurringCost) {
            this.monthlyRecurringCost = monthlyRecurringCost;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final String getDatabaseEdition() {
            return databaseEdition;
        }

        public final void setDatabaseEdition(String databaseEdition) {
            this.databaseEdition = databaseEdition;
        }

        @Override
        public final Builder databaseEdition(String databaseEdition) {
            this.databaseEdition = databaseEdition;
            return this;
        }

        public final String getDatabaseEngine() {
            return databaseEngine;
        }

        public final void setDatabaseEngine(String databaseEngine) {
            this.databaseEngine = databaseEngine;
        }

        @Override
        public final Builder databaseEngine(String databaseEngine) {
            this.databaseEngine = databaseEngine;
            return this;
        }

        public final String getDeploymentOption() {
            return deploymentOption;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        @Override
        public RdsReservedInstancesConfiguration build() {
            return new RdsReservedInstancesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
