/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.costoptimizationhub.model.GetPreferencesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.GetPreferencesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.GetRecommendationRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.GetRecommendationResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.UpdateEnrollmentStatusRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.UpdateEnrollmentStatusResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.UpdatePreferencesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.UpdatePreferencesResponse;
import software.amazon.awssdk.services.costoptimizationhub.paginators.ListEnrollmentStatusesPublisher;
import software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationSummariesPublisher;
import software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationsPublisher;

/**
 * Service client for accessing Cost Optimization Hub asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * You can use the Cost Optimization Hub API to programmatically identify, filter, aggregate, and quantify savings for
 * your cost optimization recommendations across multiple Amazon Web Services Regions and Amazon Web Services accounts
 * in your organization.
 * </p>
 * <p>
 * The Cost Optimization Hub API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * https://cost-optimization-hub.us-east-1.amazonaws.com
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CostOptimizationHubAsyncClient extends AwsClient {
    String SERVICE_NAME = "cost-optimization-hub";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cost-optimization-hub";

    /**
     * <p>
     * Returns a set of preferences for an account in order to add account-specific preferences into the service. These
     * preferences impact how the savings associated with recommendations are presented—estimated savings after
     * discounts or estimated savings before discounts, for example.
     * </p>
     *
     * @param getPreferencesRequest
     * @return A Java Future containing the result of the GetPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.GetPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/GetPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPreferencesResponse> getPreferences(GetPreferencesRequest getPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a set of preferences for an account in order to add account-specific preferences into the service. These
     * preferences impact how the savings associated with recommendations are presented—estimated savings after
     * discounts or estimated savings before discounts, for example.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPreferencesRequest.Builder} avoiding the need to
     * create one manually via {@link GetPreferencesRequest#builder()}
     * </p>
     *
     * @param getPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.GetPreferencesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.GetPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/GetPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPreferencesResponse> getPreferences(Consumer<GetPreferencesRequest.Builder> getPreferencesRequest) {
        return getPreferences(GetPreferencesRequest.builder().applyMutation(getPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns both the current and recommended resource configuration and the estimated cost impact for a
     * recommendation.
     * </p>
     * <p>
     * The <code>recommendationId</code> is only valid for up to a maximum of 24 hours as recommendations are refreshed
     * daily. To retrieve the <code>recommendationId</code>, use the <code>ListRecommendations</code> API.
     * </p>
     *
     * @param getRecommendationRequest
     * @return A Java Future containing the result of the GetRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ResourceNotFoundException The specified Amazon Resource Name (ARN) in the request doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.GetRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/GetRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationResponse> getRecommendation(GetRecommendationRequest getRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns both the current and recommended resource configuration and the estimated cost impact for a
     * recommendation.
     * </p>
     * <p>
     * The <code>recommendationId</code> is only valid for up to a maximum of 24 hours as recommendations are refreshed
     * daily. To retrieve the <code>recommendationId</code>, use the <code>ListRecommendations</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationRequest.Builder} avoiding the need
     * to create one manually via {@link GetRecommendationRequest#builder()}
     * </p>
     *
     * @param getRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.GetRecommendationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ResourceNotFoundException The specified Amazon Resource Name (ARN) in the request doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.GetRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/GetRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationResponse> getRecommendation(
            Consumer<GetRecommendationRequest.Builder> getRecommendationRequest) {
        return getRecommendation(GetRecommendationRequest.builder().applyMutation(getRecommendationRequest).build());
    }

    /**
     * <p>
     * Retrieves the enrollment status for an account. It can also return the list of accounts that are enrolled under
     * the organization.
     * </p>
     *
     * @param listEnrollmentStatusesRequest
     * @return A Java Future containing the result of the ListEnrollmentStatuses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListEnrollmentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListEnrollmentStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnrollmentStatusesResponse> listEnrollmentStatuses(
            ListEnrollmentStatusesRequest listEnrollmentStatusesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the enrollment status for an account. It can also return the list of accounts that are enrolled under
     * the organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnrollmentStatusesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnrollmentStatusesRequest#builder()}
     * </p>
     *
     * @param listEnrollmentStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEnrollmentStatuses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListEnrollmentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListEnrollmentStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEnrollmentStatusesResponse> listEnrollmentStatuses(
            Consumer<ListEnrollmentStatusesRequest.Builder> listEnrollmentStatusesRequest) {
        return listEnrollmentStatuses(ListEnrollmentStatusesRequest.builder().applyMutation(listEnrollmentStatusesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnrollmentStatuses(software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListEnrollmentStatusesPublisher publisher = client.listEnrollmentStatusesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListEnrollmentStatusesPublisher publisher = client.listEnrollmentStatusesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnrollmentStatuses(software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnrollmentStatusesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListEnrollmentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListEnrollmentStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnrollmentStatusesPublisher listEnrollmentStatusesPaginator(
            ListEnrollmentStatusesRequest listEnrollmentStatusesRequest) {
        return new ListEnrollmentStatusesPublisher(this, listEnrollmentStatusesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnrollmentStatuses(software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListEnrollmentStatusesPublisher publisher = client.listEnrollmentStatusesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListEnrollmentStatusesPublisher publisher = client.listEnrollmentStatusesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnrollmentStatuses(software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnrollmentStatusesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEnrollmentStatusesRequest#builder()}
     * </p>
     *
     * @param listEnrollmentStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.ListEnrollmentStatusesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListEnrollmentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListEnrollmentStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnrollmentStatusesPublisher listEnrollmentStatusesPaginator(
            Consumer<ListEnrollmentStatusesRequest.Builder> listEnrollmentStatusesRequest) {
        return listEnrollmentStatusesPaginator(ListEnrollmentStatusesRequest.builder()
                .applyMutation(listEnrollmentStatusesRequest).build());
    }

    /**
     * <p>
     * Returns a concise representation of savings estimates for resources. Also returns de-duped savings across
     * different types of recommendations.
     * </p>
     * <note>
     * <p>
     * The following filters are not supported for this API: <code>recommendationIds</code>, <code>resourceArns</code>,
     * and <code>resourceIds</code>.
     * </p>
     * </note>
     *
     * @param listRecommendationSummariesRequest
     * @return A Java Future containing the result of the ListRecommendationSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListRecommendationSummaries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationSummariesResponse> listRecommendationSummaries(
            ListRecommendationSummariesRequest listRecommendationSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a concise representation of savings estimates for resources. Also returns de-duped savings across
     * different types of recommendations.
     * </p>
     * <note>
     * <p>
     * The following filters are not supported for this API: <code>recommendationIds</code>, <code>resourceArns</code>,
     * and <code>resourceIds</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecommendationSummariesRequest#builder()}
     * </p>
     *
     * @param listRecommendationSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListRecommendationSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListRecommendationSummaries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationSummariesResponse> listRecommendationSummaries(
            Consumer<ListRecommendationSummariesRequest.Builder> listRecommendationSummariesRequest) {
        return listRecommendationSummaries(ListRecommendationSummariesRequest.builder()
                .applyMutation(listRecommendationSummariesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendationSummaries(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationSummariesPublisher publisher = client.listRecommendationSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationSummariesPublisher publisher = client.listRecommendationSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationSummaries(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListRecommendationSummaries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationSummariesPublisher listRecommendationSummariesPaginator(
            ListRecommendationSummariesRequest listRecommendationSummariesRequest) {
        return new ListRecommendationSummariesPublisher(this, listRecommendationSummariesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendationSummaries(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationSummariesPublisher publisher = client.listRecommendationSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationSummariesPublisher publisher = client.listRecommendationSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationSummaries(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecommendationSummariesRequest#builder()}
     * </p>
     *
     * @param listRecommendationSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListRecommendationSummaries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendationSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationSummariesPublisher listRecommendationSummariesPaginator(
            Consumer<ListRecommendationSummariesRequest.Builder> listRecommendationSummariesRequest) {
        return listRecommendationSummariesPaginator(ListRecommendationSummariesRequest.builder()
                .applyMutation(listRecommendationSummariesRequest).build());
    }

    /**
     * <p>
     * Returns a list of recommendations.
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationsResponse> listRecommendations(
            ListRecommendationsRequest listRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationsResponse> listRecommendations(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) {
        return listRecommendations(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsPublisher listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest) {
        return new ListRecommendationsPublisher(this, listRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.costoptimizationhub.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsPublisher listRecommendationsPaginator(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) {
        return listRecommendationsPaginator(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Updates the enrollment (opt in and opt out) status of an account to the Cost Optimization Hub service.
     * </p>
     * <p>
     * If the account is a management account or delegated administrator of an organization, this action can also be
     * used to enroll member accounts of the organization.
     * </p>
     * <p>
     * You must have the appropriate permissions to opt in to Cost Optimization Hub and to view its recommendations.
     * When you opt in, Cost Optimization Hub automatically creates a service-linked role in your account to access its
     * data.
     * </p>
     *
     * @param updateEnrollmentStatusRequest
     * @return A Java Future containing the result of the UpdateEnrollmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.UpdateEnrollmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/UpdateEnrollmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnrollmentStatusResponse> updateEnrollmentStatus(
            UpdateEnrollmentStatusRequest updateEnrollmentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the enrollment (opt in and opt out) status of an account to the Cost Optimization Hub service.
     * </p>
     * <p>
     * If the account is a management account or delegated administrator of an organization, this action can also be
     * used to enroll member accounts of the organization.
     * </p>
     * <p>
     * You must have the appropriate permissions to opt in to Cost Optimization Hub and to view its recommendations.
     * When you opt in, Cost Optimization Hub automatically creates a service-linked role in your account to access its
     * data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnrollmentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEnrollmentStatusRequest#builder()}
     * </p>
     *
     * @param updateEnrollmentStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.UpdateEnrollmentStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateEnrollmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.UpdateEnrollmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/UpdateEnrollmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnrollmentStatusResponse> updateEnrollmentStatus(
            Consumer<UpdateEnrollmentStatusRequest.Builder> updateEnrollmentStatusRequest) {
        return updateEnrollmentStatus(UpdateEnrollmentStatusRequest.builder().applyMutation(updateEnrollmentStatusRequest)
                .build());
    }

    /**
     * <p>
     * Updates a set of preferences for an account in order to add account-specific preferences into the service. These
     * preferences impact how the savings associated with recommendations are presented.
     * </p>
     *
     * @param updatePreferencesRequest
     * @return A Java Future containing the result of the UpdatePreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.UpdatePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/UpdatePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePreferencesResponse> updatePreferences(UpdatePreferencesRequest updatePreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a set of preferences for an account in order to add account-specific preferences into the service. These
     * preferences impact how the savings associated with recommendations are presented.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePreferencesRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePreferencesRequest#builder()}
     * </p>
     *
     * @param updatePreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.costoptimizationhub.model.UpdatePreferencesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdatePreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CostOptimizationHubException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample CostOptimizationHubAsyncClient.UpdatePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cost-optimization-hub-2022-07-26/UpdatePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePreferencesResponse> updatePreferences(
            Consumer<UpdatePreferencesRequest.Builder> updatePreferencesRequest) {
        return updatePreferences(UpdatePreferencesRequest.builder().applyMutation(updatePreferencesRequest).build());
    }

    @Override
    default CostOptimizationHubServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CostOptimizationHubAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CostOptimizationHubAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CostOptimizationHubAsyncClient}.
     */
    static CostOptimizationHubAsyncClientBuilder builder() {
        return new DefaultCostOptimizationHubAsyncClientBuilder();
    }
}
