/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EC2 auto scaling group configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2AutoScalingGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2AutoScalingGroupConfiguration.Builder, Ec2AutoScalingGroupConfiguration> {
    private static final SdkField<InstanceConfiguration> INSTANCE_FIELD = SdkField
            .<InstanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("instance")
            .getter(getter(Ec2AutoScalingGroupConfiguration::instance)).setter(setter(Builder::instance))
            .constructor(InstanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InstanceConfiguration instance;

    private Ec2AutoScalingGroupConfiguration(BuilderImpl builder) {
        this.instance = builder.instance;
    }

    /**
     * <p>
     * Details about the instance.
     * </p>
     * 
     * @return Details about the instance.
     */
    public final InstanceConfiguration instance() {
        return instance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AutoScalingGroupConfiguration)) {
            return false;
        }
        Ec2AutoScalingGroupConfiguration other = (Ec2AutoScalingGroupConfiguration) obj;
        return Objects.equals(instance(), other.instance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2AutoScalingGroupConfiguration").add("Instance", instance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instance":
            return Optional.ofNullable(clazz.cast(instance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instance", INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2AutoScalingGroupConfiguration, T> g) {
        return obj -> g.apply((Ec2AutoScalingGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2AutoScalingGroupConfiguration> {
        /**
         * <p>
         * Details about the instance.
         * </p>
         * 
         * @param instance
         *        Details about the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(InstanceConfiguration instance);

        /**
         * <p>
         * Details about the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceConfiguration.Builder} avoiding
         * the need to create one manually via {@link InstanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #instance(InstanceConfiguration)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link InstanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(InstanceConfiguration)
         */
        default Builder instance(Consumer<InstanceConfiguration.Builder> instance) {
            return instance(InstanceConfiguration.builder().applyMutation(instance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceConfiguration instance;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AutoScalingGroupConfiguration model) {
            instance(model.instance);
        }

        public final InstanceConfiguration.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        public final void setInstance(InstanceConfiguration.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public final Builder instance(InstanceConfiguration instance) {
            this.instance = instance;
            return this;
        }

        @Override
        public Ec2AutoScalingGroupConfiguration build() {
            return new Ec2AutoScalingGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
