/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationSummariesRequest extends CostOptimizationHubRequest implements
        ToCopyableBuilder<ListRecommendationSummariesRequest.Builder, ListRecommendationSummariesRequest> {
    private static final SdkField<Filter> FILTER_FIELD = SdkField.<Filter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListRecommendationSummariesRequest::filter)).setter(setter(Builder::filter))
            .constructor(Filter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> GROUP_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupBy").getter(getter(ListRecommendationSummariesRequest::groupBy)).setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRecommendationSummariesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("metrics")
            .getter(getter(ListRecommendationSummariesRequest::metricsAsStrings))
            .setter(setter(Builder::metricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecommendationSummariesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, GROUP_BY_FIELD,
            MAX_RESULTS_FIELD, METRICS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Filter filter;

    private final String groupBy;

    private final Integer maxResults;

    private final List<String> metrics;

    private final String nextToken;

    private ListRecommendationSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.groupBy = builder.groupBy;
        this.maxResults = builder.maxResults;
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final Filter filter() {
        return filter;
    }

    /**
     * <p>
     * The grouping of recommendations by a dimension.
     * </p>
     * 
     * @return The grouping of recommendations by a dimension.
     */
    public final String groupBy() {
        return groupBy;
    }

    /**
     * <p>
     * The maximum number of recommendations to be returned for the request.
     * </p>
     * 
     * @return The maximum number of recommendations to be returned for the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Additional metrics to be returned for the request. The only valid value is <code>savingsPercentage</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return Additional metrics to be returned for the request. The only valid value is <code>savingsPercentage</code>
     *         .
     */
    public final List<SummaryMetrics> metrics() {
        return SummaryMetricsListCopier.copyStringToEnum(metrics);
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional metrics to be returned for the request. The only valid value is <code>savingsPercentage</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return Additional metrics to be returned for the request. The only valid value is <code>savingsPercentage</code>
     *         .
     */
    public final List<String> metricsAsStrings() {
        return metrics;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationSummariesRequest)) {
            return false;
        }
        ListRecommendationSummariesRequest other = (ListRecommendationSummariesRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(groupBy(), other.groupBy())
                && Objects.equals(maxResults(), other.maxResults()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metricsAsStrings(), other.metricsAsStrings()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationSummariesRequest").add("Filter", filter()).add("GroupBy", groupBy())
                .add("MaxResults", maxResults()).add("Metrics", hasMetrics() ? metricsAsStrings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "groupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metricsAsStrings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filter", FILTER_FIELD);
        map.put("groupBy", GROUP_BY_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("metrics", METRICS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationSummariesRequest, T> g) {
        return obj -> g.apply((ListRecommendationSummariesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostOptimizationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecommendationSummariesRequest> {
        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Filter.Builder} avoiding the need to
         * create one manually via {@link Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filter.Builder#build()} is called immediately and its result is
         * passed to {@link #filter(Filter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Filter)
         */
        default Builder filter(Consumer<Filter.Builder> filter) {
            return filter(Filter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The grouping of recommendations by a dimension.
         * </p>
         * 
         * @param groupBy
         *        The grouping of recommendations by a dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(String groupBy);

        /**
         * <p>
         * The maximum number of recommendations to be returned for the request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of recommendations to be returned for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Additional metrics to be returned for the request. The only valid value is <code>savingsPercentage</code>.
         * </p>
         * 
         * @param metrics
         *        Additional metrics to be returned for the request. The only valid value is
         *        <code>savingsPercentage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsWithStrings(Collection<String> metrics);

        /**
         * <p>
         * Additional metrics to be returned for the request. The only valid value is <code>savingsPercentage</code>.
         * </p>
         * 
         * @param metrics
         *        Additional metrics to be returned for the request. The only valid value is
         *        <code>savingsPercentage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsWithStrings(String... metrics);

        /**
         * <p>
         * Additional metrics to be returned for the request. The only valid value is <code>savingsPercentage</code>.
         * </p>
         * 
         * @param metrics
         *        Additional metrics to be returned for the request. The only valid value is
         *        <code>savingsPercentage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<SummaryMetrics> metrics);

        /**
         * <p>
         * Additional metrics to be returned for the request. The only valid value is <code>savingsPercentage</code>.
         * </p>
         * 
         * @param metrics
         *        Additional metrics to be returned for the request. The only valid value is
         *        <code>savingsPercentage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(SummaryMetrics... metrics);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostOptimizationHubRequest.BuilderImpl implements Builder {
        private Filter filter;

        private String groupBy;

        private Integer maxResults;

        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationSummariesRequest model) {
            super(model);
            filter(model.filter);
            groupBy(model.groupBy);
            maxResults(model.maxResults);
            metricsWithStrings(model.metrics);
            nextToken(model.nextToken);
        }

        public final Filter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final String getGroupBy() {
            return groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getMetrics() {
            if (metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = SummaryMetricsListCopier.copy(metrics);
        }

        @Override
        public final Builder metricsWithStrings(Collection<String> metrics) {
            this.metrics = SummaryMetricsListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsWithStrings(String... metrics) {
            metricsWithStrings(Arrays.asList(metrics));
            return this;
        }

        @Override
        public final Builder metrics(Collection<SummaryMetrics> metrics) {
            this.metrics = SummaryMetricsListCopier.copyEnumToString(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(SummaryMetrics... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationSummariesRequest build() {
            return new ListRecommendationSummariesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
