/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon RDS DB instance storage configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsDbInstanceStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsDbInstanceStorageConfiguration.Builder, RdsDbInstanceStorageConfiguration> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(RdsDbInstanceStorageConfiguration::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<Double> ALLOCATED_STORAGE_IN_GB_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("allocatedStorageInGb").getter(getter(RdsDbInstanceStorageConfiguration::allocatedStorageInGb))
            .setter(setter(Builder::allocatedStorageInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorageInGb").build())
            .build();

    private static final SdkField<Double> IOPS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("iops")
            .getter(getter(RdsDbInstanceStorageConfiguration::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()).build();

    private static final SdkField<Double> STORAGE_THROUGHPUT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("storageThroughput").getter(getter(RdsDbInstanceStorageConfiguration::storageThroughput))
            .setter(setter(Builder::storageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageThroughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD,
            ALLOCATED_STORAGE_IN_GB_FIELD, IOPS_FIELD, STORAGE_THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String storageType;

    private final Double allocatedStorageInGb;

    private final Double iops;

    private final Double storageThroughput;

    private RdsDbInstanceStorageConfiguration(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.allocatedStorageInGb = builder.allocatedStorageInGb;
        this.iops = builder.iops;
        this.storageThroughput = builder.storageThroughput;
    }

    /**
     * <p>
     * The storage type to associate with the DB instance.
     * </p>
     * 
     * @return The storage type to associate with the DB instance.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The new amount of storage in GB to allocate for the DB instance.
     * </p>
     * 
     * @return The new amount of storage in GB to allocate for the DB instance.
     */
    public final Double allocatedStorageInGb() {
        return allocatedStorageInGb;
    }

    /**
     * <p>
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB
     * instance.
     * </p>
     * 
     * @return The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB
     *         instance.
     */
    public final Double iops() {
        return iops;
    }

    /**
     * <p>
     * The storage throughput for the DB instance.
     * </p>
     * 
     * @return The storage throughput for the DB instance.
     */
    public final Double storageThroughput() {
        return storageThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorageInGb());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(storageThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbInstanceStorageConfiguration)) {
            return false;
        }
        RdsDbInstanceStorageConfiguration other = (RdsDbInstanceStorageConfiguration) obj;
        return Objects.equals(storageType(), other.storageType())
                && Objects.equals(allocatedStorageInGb(), other.allocatedStorageInGb()) && Objects.equals(iops(), other.iops())
                && Objects.equals(storageThroughput(), other.storageThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsDbInstanceStorageConfiguration").add("StorageType", storageType())
                .add("AllocatedStorageInGb", allocatedStorageInGb()).add("Iops", iops())
                .add("StorageThroughput", storageThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "allocatedStorageInGb":
            return Optional.ofNullable(clazz.cast(allocatedStorageInGb()));
        case "iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "storageThroughput":
            return Optional.ofNullable(clazz.cast(storageThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("allocatedStorageInGb", ALLOCATED_STORAGE_IN_GB_FIELD);
        map.put("iops", IOPS_FIELD);
        map.put("storageThroughput", STORAGE_THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsDbInstanceStorageConfiguration, T> g) {
        return obj -> g.apply((RdsDbInstanceStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsDbInstanceStorageConfiguration> {
        /**
         * <p>
         * The storage type to associate with the DB instance.
         * </p>
         * 
         * @param storageType
         *        The storage type to associate with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The new amount of storage in GB to allocate for the DB instance.
         * </p>
         * 
         * @param allocatedStorageInGb
         *        The new amount of storage in GB to allocate for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorageInGb(Double allocatedStorageInGb);

        /**
         * <p>
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB
         * instance.
         * </p>
         * 
         * @param iops
         *        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the
         *        DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Double iops);

        /**
         * <p>
         * The storage throughput for the DB instance.
         * </p>
         * 
         * @param storageThroughput
         *        The storage throughput for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageThroughput(Double storageThroughput);
    }

    static final class BuilderImpl implements Builder {
        private String storageType;

        private Double allocatedStorageInGb;

        private Double iops;

        private Double storageThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbInstanceStorageConfiguration model) {
            storageType(model.storageType);
            allocatedStorageInGb(model.allocatedStorageInGb);
            iops(model.iops);
            storageThroughput(model.storageThroughput);
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Double getAllocatedStorageInGb() {
            return allocatedStorageInGb;
        }

        public final void setAllocatedStorageInGb(Double allocatedStorageInGb) {
            this.allocatedStorageInGb = allocatedStorageInGb;
        }

        @Override
        public final Builder allocatedStorageInGb(Double allocatedStorageInGb) {
            this.allocatedStorageInGb = allocatedStorageInGb;
            return this;
        }

        public final Double getIops() {
            return iops;
        }

        public final void setIops(Double iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Double iops) {
            this.iops = iops;
            return this;
        }

        public final Double getStorageThroughput() {
            return storageThroughput;
        }

        public final void setStorageThroughput(Double storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Double storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        @Override
        public RdsDbInstanceStorageConfiguration build() {
            return new RdsDbInstanceStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
