/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Cost impact of the resource recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceCostCalculation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceCostCalculation.Builder, ResourceCostCalculation> {
    private static final SdkField<List<Usage>> USAGES_FIELD = SdkField
            .<List<Usage>> builder(MarshallingType.LIST)
            .memberName("usages")
            .getter(getter(ResourceCostCalculation::usages))
            .setter(setter(Builder::usages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Usage> builder(MarshallingType.SDK_POJO)
                                            .constructor(Usage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResourcePricing> PRICING_FIELD = SdkField.<ResourcePricing> builder(MarshallingType.SDK_POJO)
            .memberName("pricing").getter(getter(ResourceCostCalculation::pricing)).setter(setter(Builder::pricing))
            .constructor(ResourcePricing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricing").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGES_FIELD, PRICING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Usage> usages;

    private final ResourcePricing pricing;

    private ResourceCostCalculation(BuilderImpl builder) {
        this.usages = builder.usages;
        this.pricing = builder.pricing;
    }

    /**
     * For responses, this returns true if the service returned a value for the Usages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUsages() {
        return usages != null && !(usages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Usage details of the resource recommendation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsages} method.
     * </p>
     * 
     * @return Usage details of the resource recommendation.
     */
    public final List<Usage> usages() {
        return usages;
    }

    /**
     * <p>
     * Pricing details of the resource recommendation.
     * </p>
     * 
     * @return Pricing details of the resource recommendation.
     */
    public final ResourcePricing pricing() {
        return pricing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUsages() ? usages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pricing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCostCalculation)) {
            return false;
        }
        ResourceCostCalculation other = (ResourceCostCalculation) obj;
        return hasUsages() == other.hasUsages() && Objects.equals(usages(), other.usages())
                && Objects.equals(pricing(), other.pricing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceCostCalculation").add("Usages", hasUsages() ? usages() : null).add("Pricing", pricing())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usages":
            return Optional.ofNullable(clazz.cast(usages()));
        case "pricing":
            return Optional.ofNullable(clazz.cast(pricing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("usages", USAGES_FIELD);
        map.put("pricing", PRICING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceCostCalculation, T> g) {
        return obj -> g.apply((ResourceCostCalculation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceCostCalculation> {
        /**
         * <p>
         * Usage details of the resource recommendation.
         * </p>
         * 
         * @param usages
         *        Usage details of the resource recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usages(Collection<Usage> usages);

        /**
         * <p>
         * Usage details of the resource recommendation.
         * </p>
         * 
         * @param usages
         *        Usage details of the resource recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usages(Usage... usages);

        /**
         * <p>
         * Usage details of the resource recommendation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.Usage.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.costoptimizationhub.model.Usage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.Usage.Builder#build()} is called immediately
         * and its result is passed to {@link #usages(List<Usage>)}.
         * 
         * @param usages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costoptimizationhub.model.Usage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usages(java.util.Collection<Usage>)
         */
        Builder usages(Consumer<Usage.Builder>... usages);

        /**
         * <p>
         * Pricing details of the resource recommendation.
         * </p>
         * 
         * @param pricing
         *        Pricing details of the resource recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricing(ResourcePricing pricing);

        /**
         * <p>
         * Pricing details of the resource recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcePricing.Builder} avoiding the
         * need to create one manually via {@link ResourcePricing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourcePricing.Builder#build()} is called immediately and its
         * result is passed to {@link #pricing(ResourcePricing)}.
         * 
         * @param pricing
         *        a consumer that will call methods on {@link ResourcePricing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pricing(ResourcePricing)
         */
        default Builder pricing(Consumer<ResourcePricing.Builder> pricing) {
            return pricing(ResourcePricing.builder().applyMutation(pricing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Usage> usages = DefaultSdkAutoConstructList.getInstance();

        private ResourcePricing pricing;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCostCalculation model) {
            usages(model.usages);
            pricing(model.pricing);
        }

        public final List<Usage.Builder> getUsages() {
            List<Usage.Builder> result = UsageListCopier.copyToBuilder(this.usages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsages(Collection<Usage.BuilderImpl> usages) {
            this.usages = UsageListCopier.copyFromBuilder(usages);
        }

        @Override
        public final Builder usages(Collection<Usage> usages) {
            this.usages = UsageListCopier.copy(usages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usages(Usage... usages) {
            usages(Arrays.asList(usages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usages(Consumer<Usage.Builder>... usages) {
            usages(Stream.of(usages).map(c -> Usage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResourcePricing.Builder getPricing() {
            return pricing != null ? pricing.toBuilder() : null;
        }

        public final void setPricing(ResourcePricing.BuilderImpl pricing) {
            this.pricing = pricing != null ? pricing.build() : null;
        }

        @Override
        public final Builder pricing(ResourcePricing pricing) {
            this.pricing = pricing;
            return this;
        }

        @Override
        public ResourceCostCalculation build() {
            return new ResourceCostCalculation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
