/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about the specified resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDetails.Builder, ResourceDetails> {
    private static final SdkField<LambdaFunction> LAMBDA_FUNCTION_FIELD = SdkField
            .<LambdaFunction> builder(MarshallingType.SDK_POJO).memberName("lambdaFunction")
            .getter(getter(ResourceDetails::lambdaFunction)).setter(setter(Builder::lambdaFunction))
            .constructor(LambdaFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunction").build()).build();

    private static final SdkField<EcsService> ECS_SERVICE_FIELD = SdkField.<EcsService> builder(MarshallingType.SDK_POJO)
            .memberName("ecsService").getter(getter(ResourceDetails::ecsService)).setter(setter(Builder::ecsService))
            .constructor(EcsService::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsService").build()).build();

    private static final SdkField<Ec2Instance> EC2_INSTANCE_FIELD = SdkField.<Ec2Instance> builder(MarshallingType.SDK_POJO)
            .memberName("ec2Instance").getter(getter(ResourceDetails::ec2Instance)).setter(setter(Builder::ec2Instance))
            .constructor(Ec2Instance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Instance").build()).build();

    private static final SdkField<EbsVolume> EBS_VOLUME_FIELD = SdkField.<EbsVolume> builder(MarshallingType.SDK_POJO)
            .memberName("ebsVolume").getter(getter(ResourceDetails::ebsVolume)).setter(setter(Builder::ebsVolume))
            .constructor(EbsVolume::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolume").build()).build();

    private static final SdkField<Ec2AutoScalingGroup> EC2_AUTO_SCALING_GROUP_FIELD = SdkField
            .<Ec2AutoScalingGroup> builder(MarshallingType.SDK_POJO).memberName("ec2AutoScalingGroup")
            .getter(getter(ResourceDetails::ec2AutoScalingGroup)).setter(setter(Builder::ec2AutoScalingGroup))
            .constructor(Ec2AutoScalingGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2AutoScalingGroup").build())
            .build();

    private static final SdkField<Ec2ReservedInstances> EC2_RESERVED_INSTANCES_FIELD = SdkField
            .<Ec2ReservedInstances> builder(MarshallingType.SDK_POJO).memberName("ec2ReservedInstances")
            .getter(getter(ResourceDetails::ec2ReservedInstances)).setter(setter(Builder::ec2ReservedInstances))
            .constructor(Ec2ReservedInstances::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2ReservedInstances").build())
            .build();

    private static final SdkField<RdsReservedInstances> RDS_RESERVED_INSTANCES_FIELD = SdkField
            .<RdsReservedInstances> builder(MarshallingType.SDK_POJO).memberName("rdsReservedInstances")
            .getter(getter(ResourceDetails::rdsReservedInstances)).setter(setter(Builder::rdsReservedInstances))
            .constructor(RdsReservedInstances::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsReservedInstances").build())
            .build();

    private static final SdkField<ElastiCacheReservedInstances> ELASTI_CACHE_RESERVED_INSTANCES_FIELD = SdkField
            .<ElastiCacheReservedInstances> builder(MarshallingType.SDK_POJO)
            .memberName("elastiCacheReservedInstances")
            .getter(getter(ResourceDetails::elastiCacheReservedInstances))
            .setter(setter(Builder::elastiCacheReservedInstances))
            .constructor(ElastiCacheReservedInstances::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elastiCacheReservedInstances")
                    .build()).build();

    private static final SdkField<OpenSearchReservedInstances> OPEN_SEARCH_RESERVED_INSTANCES_FIELD = SdkField
            .<OpenSearchReservedInstances> builder(MarshallingType.SDK_POJO)
            .memberName("openSearchReservedInstances")
            .getter(getter(ResourceDetails::openSearchReservedInstances))
            .setter(setter(Builder::openSearchReservedInstances))
            .constructor(OpenSearchReservedInstances::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearchReservedInstances")
                    .build()).build();

    private static final SdkField<RedshiftReservedInstances> REDSHIFT_RESERVED_INSTANCES_FIELD = SdkField
            .<RedshiftReservedInstances> builder(MarshallingType.SDK_POJO).memberName("redshiftReservedInstances")
            .getter(getter(ResourceDetails::redshiftReservedInstances)).setter(setter(Builder::redshiftReservedInstances))
            .constructor(RedshiftReservedInstances::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftReservedInstances").build())
            .build();

    private static final SdkField<Ec2InstanceSavingsPlans> EC2_INSTANCE_SAVINGS_PLANS_FIELD = SdkField
            .<Ec2InstanceSavingsPlans> builder(MarshallingType.SDK_POJO).memberName("ec2InstanceSavingsPlans")
            .getter(getter(ResourceDetails::ec2InstanceSavingsPlans)).setter(setter(Builder::ec2InstanceSavingsPlans))
            .constructor(Ec2InstanceSavingsPlans::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceSavingsPlans").build())
            .build();

    private static final SdkField<ComputeSavingsPlans> COMPUTE_SAVINGS_PLANS_FIELD = SdkField
            .<ComputeSavingsPlans> builder(MarshallingType.SDK_POJO).memberName("computeSavingsPlans")
            .getter(getter(ResourceDetails::computeSavingsPlans)).setter(setter(Builder::computeSavingsPlans))
            .constructor(ComputeSavingsPlans::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeSavingsPlans").build())
            .build();

    private static final SdkField<SageMakerSavingsPlans> SAGE_MAKER_SAVINGS_PLANS_FIELD = SdkField
            .<SageMakerSavingsPlans> builder(MarshallingType.SDK_POJO).memberName("sageMakerSavingsPlans")
            .getter(getter(ResourceDetails::sageMakerSavingsPlans)).setter(setter(Builder::sageMakerSavingsPlans))
            .constructor(SageMakerSavingsPlans::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sageMakerSavingsPlans").build())
            .build();

    private static final SdkField<RdsDbInstance> RDS_DB_INSTANCE_FIELD = SdkField
            .<RdsDbInstance> builder(MarshallingType.SDK_POJO).memberName("rdsDbInstance")
            .getter(getter(ResourceDetails::rdsDbInstance)).setter(setter(Builder::rdsDbInstance))
            .constructor(RdsDbInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbInstance").build()).build();

    private static final SdkField<RdsDbInstanceStorage> RDS_DB_INSTANCE_STORAGE_FIELD = SdkField
            .<RdsDbInstanceStorage> builder(MarshallingType.SDK_POJO).memberName("rdsDbInstanceStorage")
            .getter(getter(ResourceDetails::rdsDbInstanceStorage)).setter(setter(Builder::rdsDbInstanceStorage))
            .constructor(RdsDbInstanceStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbInstanceStorage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FUNCTION_FIELD,
            ECS_SERVICE_FIELD, EC2_INSTANCE_FIELD, EBS_VOLUME_FIELD, EC2_AUTO_SCALING_GROUP_FIELD, EC2_RESERVED_INSTANCES_FIELD,
            RDS_RESERVED_INSTANCES_FIELD, ELASTI_CACHE_RESERVED_INSTANCES_FIELD, OPEN_SEARCH_RESERVED_INSTANCES_FIELD,
            REDSHIFT_RESERVED_INSTANCES_FIELD, EC2_INSTANCE_SAVINGS_PLANS_FIELD, COMPUTE_SAVINGS_PLANS_FIELD,
            SAGE_MAKER_SAVINGS_PLANS_FIELD, RDS_DB_INSTANCE_FIELD, RDS_DB_INSTANCE_STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LambdaFunction lambdaFunction;

    private final EcsService ecsService;

    private final Ec2Instance ec2Instance;

    private final EbsVolume ebsVolume;

    private final Ec2AutoScalingGroup ec2AutoScalingGroup;

    private final Ec2ReservedInstances ec2ReservedInstances;

    private final RdsReservedInstances rdsReservedInstances;

    private final ElastiCacheReservedInstances elastiCacheReservedInstances;

    private final OpenSearchReservedInstances openSearchReservedInstances;

    private final RedshiftReservedInstances redshiftReservedInstances;

    private final Ec2InstanceSavingsPlans ec2InstanceSavingsPlans;

    private final ComputeSavingsPlans computeSavingsPlans;

    private final SageMakerSavingsPlans sageMakerSavingsPlans;

    private final RdsDbInstance rdsDbInstance;

    private final RdsDbInstanceStorage rdsDbInstanceStorage;

    private final Type type;

    private ResourceDetails(BuilderImpl builder) {
        this.lambdaFunction = builder.lambdaFunction;
        this.ecsService = builder.ecsService;
        this.ec2Instance = builder.ec2Instance;
        this.ebsVolume = builder.ebsVolume;
        this.ec2AutoScalingGroup = builder.ec2AutoScalingGroup;
        this.ec2ReservedInstances = builder.ec2ReservedInstances;
        this.rdsReservedInstances = builder.rdsReservedInstances;
        this.elastiCacheReservedInstances = builder.elastiCacheReservedInstances;
        this.openSearchReservedInstances = builder.openSearchReservedInstances;
        this.redshiftReservedInstances = builder.redshiftReservedInstances;
        this.ec2InstanceSavingsPlans = builder.ec2InstanceSavingsPlans;
        this.computeSavingsPlans = builder.computeSavingsPlans;
        this.sageMakerSavingsPlans = builder.sageMakerSavingsPlans;
        this.rdsDbInstance = builder.rdsDbInstance;
        this.rdsDbInstanceStorage = builder.rdsDbInstanceStorage;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Lambda function recommendation details.
     * </p>
     * 
     * @return The Lambda function recommendation details.
     */
    public final LambdaFunction lambdaFunction() {
        return lambdaFunction;
    }

    /**
     * <p>
     * The ECS service recommendation details.
     * </p>
     * 
     * @return The ECS service recommendation details.
     */
    public final EcsService ecsService() {
        return ecsService;
    }

    /**
     * <p>
     * The EC2 instance recommendation details.
     * </p>
     * 
     * @return The EC2 instance recommendation details.
     */
    public final Ec2Instance ec2Instance() {
        return ec2Instance;
    }

    /**
     * <p>
     * The Amazon Elastic Block Store volume recommendation details.
     * </p>
     * 
     * @return The Amazon Elastic Block Store volume recommendation details.
     */
    public final EbsVolume ebsVolume() {
        return ebsVolume;
    }

    /**
     * <p>
     * The EC2 Auto Scaling group recommendation details.
     * </p>
     * 
     * @return The EC2 Auto Scaling group recommendation details.
     */
    public final Ec2AutoScalingGroup ec2AutoScalingGroup() {
        return ec2AutoScalingGroup;
    }

    /**
     * <p>
     * The EC2 reserved instances recommendation details.
     * </p>
     * 
     * @return The EC2 reserved instances recommendation details.
     */
    public final Ec2ReservedInstances ec2ReservedInstances() {
        return ec2ReservedInstances;
    }

    /**
     * <p>
     * The RDS reserved instances recommendation details.
     * </p>
     * 
     * @return The RDS reserved instances recommendation details.
     */
    public final RdsReservedInstances rdsReservedInstances() {
        return rdsReservedInstances;
    }

    /**
     * <p>
     * The ElastiCache reserved instances recommendation details.
     * </p>
     * 
     * @return The ElastiCache reserved instances recommendation details.
     */
    public final ElastiCacheReservedInstances elastiCacheReservedInstances() {
        return elastiCacheReservedInstances;
    }

    /**
     * <p>
     * The OpenSearch reserved instances recommendation details.
     * </p>
     * 
     * @return The OpenSearch reserved instances recommendation details.
     */
    public final OpenSearchReservedInstances openSearchReservedInstances() {
        return openSearchReservedInstances;
    }

    /**
     * <p>
     * The Redshift reserved instances recommendation details.
     * </p>
     * 
     * @return The Redshift reserved instances recommendation details.
     */
    public final RedshiftReservedInstances redshiftReservedInstances() {
        return redshiftReservedInstances;
    }

    /**
     * <p>
     * The EC2 instance Savings Plans recommendation details.
     * </p>
     * 
     * @return The EC2 instance Savings Plans recommendation details.
     */
    public final Ec2InstanceSavingsPlans ec2InstanceSavingsPlans() {
        return ec2InstanceSavingsPlans;
    }

    /**
     * <p>
     * The Compute Savings Plans recommendation details.
     * </p>
     * 
     * @return The Compute Savings Plans recommendation details.
     */
    public final ComputeSavingsPlans computeSavingsPlans() {
        return computeSavingsPlans;
    }

    /**
     * <p>
     * The SageMaker Savings Plans recommendation details.
     * </p>
     * 
     * @return The SageMaker Savings Plans recommendation details.
     */
    public final SageMakerSavingsPlans sageMakerSavingsPlans() {
        return sageMakerSavingsPlans;
    }

    /**
     * <p>
     * The DB instance recommendation details.
     * </p>
     * 
     * @return The DB instance recommendation details.
     */
    public final RdsDbInstance rdsDbInstance() {
        return rdsDbInstance;
    }

    /**
     * <p>
     * The DB instance storage recommendation details.
     * </p>
     * 
     * @return The DB instance storage recommendation details.
     */
    public final RdsDbInstanceStorage rdsDbInstanceStorage() {
        return rdsDbInstanceStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(ecsService());
        hashCode = 31 * hashCode + Objects.hashCode(ec2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(ebsVolume());
        hashCode = 31 * hashCode + Objects.hashCode(ec2AutoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(rdsReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(elastiCacheReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(openSearchReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftReservedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceSavingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(computeSavingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerSavingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstanceStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails) obj;
        return Objects.equals(lambdaFunction(), other.lambdaFunction()) && Objects.equals(ecsService(), other.ecsService())
                && Objects.equals(ec2Instance(), other.ec2Instance()) && Objects.equals(ebsVolume(), other.ebsVolume())
                && Objects.equals(ec2AutoScalingGroup(), other.ec2AutoScalingGroup())
                && Objects.equals(ec2ReservedInstances(), other.ec2ReservedInstances())
                && Objects.equals(rdsReservedInstances(), other.rdsReservedInstances())
                && Objects.equals(elastiCacheReservedInstances(), other.elastiCacheReservedInstances())
                && Objects.equals(openSearchReservedInstances(), other.openSearchReservedInstances())
                && Objects.equals(redshiftReservedInstances(), other.redshiftReservedInstances())
                && Objects.equals(ec2InstanceSavingsPlans(), other.ec2InstanceSavingsPlans())
                && Objects.equals(computeSavingsPlans(), other.computeSavingsPlans())
                && Objects.equals(sageMakerSavingsPlans(), other.sageMakerSavingsPlans())
                && Objects.equals(rdsDbInstance(), other.rdsDbInstance())
                && Objects.equals(rdsDbInstanceStorage(), other.rdsDbInstanceStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDetails").add("LambdaFunction", lambdaFunction()).add("EcsService", ecsService())
                .add("Ec2Instance", ec2Instance()).add("EbsVolume", ebsVolume())
                .add("Ec2AutoScalingGroup", ec2AutoScalingGroup()).add("Ec2ReservedInstances", ec2ReservedInstances())
                .add("RdsReservedInstances", rdsReservedInstances())
                .add("ElastiCacheReservedInstances", elastiCacheReservedInstances())
                .add("OpenSearchReservedInstances", openSearchReservedInstances())
                .add("RedshiftReservedInstances", redshiftReservedInstances())
                .add("Ec2InstanceSavingsPlans", ec2InstanceSavingsPlans()).add("ComputeSavingsPlans", computeSavingsPlans())
                .add("SageMakerSavingsPlans", sageMakerSavingsPlans()).add("RdsDbInstance", rdsDbInstance())
                .add("RdsDbInstanceStorage", rdsDbInstanceStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaFunction":
            return Optional.ofNullable(clazz.cast(lambdaFunction()));
        case "ecsService":
            return Optional.ofNullable(clazz.cast(ecsService()));
        case "ec2Instance":
            return Optional.ofNullable(clazz.cast(ec2Instance()));
        case "ebsVolume":
            return Optional.ofNullable(clazz.cast(ebsVolume()));
        case "ec2AutoScalingGroup":
            return Optional.ofNullable(clazz.cast(ec2AutoScalingGroup()));
        case "ec2ReservedInstances":
            return Optional.ofNullable(clazz.cast(ec2ReservedInstances()));
        case "rdsReservedInstances":
            return Optional.ofNullable(clazz.cast(rdsReservedInstances()));
        case "elastiCacheReservedInstances":
            return Optional.ofNullable(clazz.cast(elastiCacheReservedInstances()));
        case "openSearchReservedInstances":
            return Optional.ofNullable(clazz.cast(openSearchReservedInstances()));
        case "redshiftReservedInstances":
            return Optional.ofNullable(clazz.cast(redshiftReservedInstances()));
        case "ec2InstanceSavingsPlans":
            return Optional.ofNullable(clazz.cast(ec2InstanceSavingsPlans()));
        case "computeSavingsPlans":
            return Optional.ofNullable(clazz.cast(computeSavingsPlans()));
        case "sageMakerSavingsPlans":
            return Optional.ofNullable(clazz.cast(sageMakerSavingsPlans()));
        case "rdsDbInstance":
            return Optional.ofNullable(clazz.cast(rdsDbInstance()));
        case "rdsDbInstanceStorage":
            return Optional.ofNullable(clazz.cast(rdsDbInstanceStorage()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #lambdaFunction()} initialized to the given value.
     *
     * <p>
     * The Lambda function recommendation details.
     * </p>
     * 
     * @param lambdaFunction
     *        The Lambda function recommendation details.
     */
    public static ResourceDetails fromLambdaFunction(LambdaFunction lambdaFunction) {
        return builder().lambdaFunction(lambdaFunction).build();
    }

    /**
     * Create an instance of this class with {@link #lambdaFunction()} initialized to the given value.
     *
     * <p>
     * The Lambda function recommendation details.
     * </p>
     * 
     * @param lambdaFunction
     *        The Lambda function recommendation details.
     */
    public static ResourceDetails fromLambdaFunction(Consumer<LambdaFunction.Builder> lambdaFunction) {
        LambdaFunction.Builder builder = LambdaFunction.builder();
        lambdaFunction.accept(builder);
        return fromLambdaFunction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ecsService()} initialized to the given value.
     *
     * <p>
     * The ECS service recommendation details.
     * </p>
     * 
     * @param ecsService
     *        The ECS service recommendation details.
     */
    public static ResourceDetails fromEcsService(EcsService ecsService) {
        return builder().ecsService(ecsService).build();
    }

    /**
     * Create an instance of this class with {@link #ecsService()} initialized to the given value.
     *
     * <p>
     * The ECS service recommendation details.
     * </p>
     * 
     * @param ecsService
     *        The ECS service recommendation details.
     */
    public static ResourceDetails fromEcsService(Consumer<EcsService.Builder> ecsService) {
        EcsService.Builder builder = EcsService.builder();
        ecsService.accept(builder);
        return fromEcsService(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ec2Instance()} initialized to the given value.
     *
     * <p>
     * The EC2 instance recommendation details.
     * </p>
     * 
     * @param ec2Instance
     *        The EC2 instance recommendation details.
     */
    public static ResourceDetails fromEc2Instance(Ec2Instance ec2Instance) {
        return builder().ec2Instance(ec2Instance).build();
    }

    /**
     * Create an instance of this class with {@link #ec2Instance()} initialized to the given value.
     *
     * <p>
     * The EC2 instance recommendation details.
     * </p>
     * 
     * @param ec2Instance
     *        The EC2 instance recommendation details.
     */
    public static ResourceDetails fromEc2Instance(Consumer<Ec2Instance.Builder> ec2Instance) {
        Ec2Instance.Builder builder = Ec2Instance.builder();
        ec2Instance.accept(builder);
        return fromEc2Instance(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ebsVolume()} initialized to the given value.
     *
     * <p>
     * The Amazon Elastic Block Store volume recommendation details.
     * </p>
     * 
     * @param ebsVolume
     *        The Amazon Elastic Block Store volume recommendation details.
     */
    public static ResourceDetails fromEbsVolume(EbsVolume ebsVolume) {
        return builder().ebsVolume(ebsVolume).build();
    }

    /**
     * Create an instance of this class with {@link #ebsVolume()} initialized to the given value.
     *
     * <p>
     * The Amazon Elastic Block Store volume recommendation details.
     * </p>
     * 
     * @param ebsVolume
     *        The Amazon Elastic Block Store volume recommendation details.
     */
    public static ResourceDetails fromEbsVolume(Consumer<EbsVolume.Builder> ebsVolume) {
        EbsVolume.Builder builder = EbsVolume.builder();
        ebsVolume.accept(builder);
        return fromEbsVolume(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ec2AutoScalingGroup()} initialized to the given value.
     *
     * <p>
     * The EC2 Auto Scaling group recommendation details.
     * </p>
     * 
     * @param ec2AutoScalingGroup
     *        The EC2 Auto Scaling group recommendation details.
     */
    public static ResourceDetails fromEc2AutoScalingGroup(Ec2AutoScalingGroup ec2AutoScalingGroup) {
        return builder().ec2AutoScalingGroup(ec2AutoScalingGroup).build();
    }

    /**
     * Create an instance of this class with {@link #ec2AutoScalingGroup()} initialized to the given value.
     *
     * <p>
     * The EC2 Auto Scaling group recommendation details.
     * </p>
     * 
     * @param ec2AutoScalingGroup
     *        The EC2 Auto Scaling group recommendation details.
     */
    public static ResourceDetails fromEc2AutoScalingGroup(Consumer<Ec2AutoScalingGroup.Builder> ec2AutoScalingGroup) {
        Ec2AutoScalingGroup.Builder builder = Ec2AutoScalingGroup.builder();
        ec2AutoScalingGroup.accept(builder);
        return fromEc2AutoScalingGroup(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ec2ReservedInstances()} initialized to the given value.
     *
     * <p>
     * The EC2 reserved instances recommendation details.
     * </p>
     * 
     * @param ec2ReservedInstances
     *        The EC2 reserved instances recommendation details.
     */
    public static ResourceDetails fromEc2ReservedInstances(Ec2ReservedInstances ec2ReservedInstances) {
        return builder().ec2ReservedInstances(ec2ReservedInstances).build();
    }

    /**
     * Create an instance of this class with {@link #ec2ReservedInstances()} initialized to the given value.
     *
     * <p>
     * The EC2 reserved instances recommendation details.
     * </p>
     * 
     * @param ec2ReservedInstances
     *        The EC2 reserved instances recommendation details.
     */
    public static ResourceDetails fromEc2ReservedInstances(Consumer<Ec2ReservedInstances.Builder> ec2ReservedInstances) {
        Ec2ReservedInstances.Builder builder = Ec2ReservedInstances.builder();
        ec2ReservedInstances.accept(builder);
        return fromEc2ReservedInstances(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rdsReservedInstances()} initialized to the given value.
     *
     * <p>
     * The RDS reserved instances recommendation details.
     * </p>
     * 
     * @param rdsReservedInstances
     *        The RDS reserved instances recommendation details.
     */
    public static ResourceDetails fromRdsReservedInstances(RdsReservedInstances rdsReservedInstances) {
        return builder().rdsReservedInstances(rdsReservedInstances).build();
    }

    /**
     * Create an instance of this class with {@link #rdsReservedInstances()} initialized to the given value.
     *
     * <p>
     * The RDS reserved instances recommendation details.
     * </p>
     * 
     * @param rdsReservedInstances
     *        The RDS reserved instances recommendation details.
     */
    public static ResourceDetails fromRdsReservedInstances(Consumer<RdsReservedInstances.Builder> rdsReservedInstances) {
        RdsReservedInstances.Builder builder = RdsReservedInstances.builder();
        rdsReservedInstances.accept(builder);
        return fromRdsReservedInstances(builder.build());
    }

    /**
     * Create an instance of this class with {@link #elastiCacheReservedInstances()} initialized to the given value.
     *
     * <p>
     * The ElastiCache reserved instances recommendation details.
     * </p>
     * 
     * @param elastiCacheReservedInstances
     *        The ElastiCache reserved instances recommendation details.
     */
    public static ResourceDetails fromElastiCacheReservedInstances(ElastiCacheReservedInstances elastiCacheReservedInstances) {
        return builder().elastiCacheReservedInstances(elastiCacheReservedInstances).build();
    }

    /**
     * Create an instance of this class with {@link #elastiCacheReservedInstances()} initialized to the given value.
     *
     * <p>
     * The ElastiCache reserved instances recommendation details.
     * </p>
     * 
     * @param elastiCacheReservedInstances
     *        The ElastiCache reserved instances recommendation details.
     */
    public static ResourceDetails fromElastiCacheReservedInstances(
            Consumer<ElastiCacheReservedInstances.Builder> elastiCacheReservedInstances) {
        ElastiCacheReservedInstances.Builder builder = ElastiCacheReservedInstances.builder();
        elastiCacheReservedInstances.accept(builder);
        return fromElastiCacheReservedInstances(builder.build());
    }

    /**
     * Create an instance of this class with {@link #openSearchReservedInstances()} initialized to the given value.
     *
     * <p>
     * The OpenSearch reserved instances recommendation details.
     * </p>
     * 
     * @param openSearchReservedInstances
     *        The OpenSearch reserved instances recommendation details.
     */
    public static ResourceDetails fromOpenSearchReservedInstances(OpenSearchReservedInstances openSearchReservedInstances) {
        return builder().openSearchReservedInstances(openSearchReservedInstances).build();
    }

    /**
     * Create an instance of this class with {@link #openSearchReservedInstances()} initialized to the given value.
     *
     * <p>
     * The OpenSearch reserved instances recommendation details.
     * </p>
     * 
     * @param openSearchReservedInstances
     *        The OpenSearch reserved instances recommendation details.
     */
    public static ResourceDetails fromOpenSearchReservedInstances(
            Consumer<OpenSearchReservedInstances.Builder> openSearchReservedInstances) {
        OpenSearchReservedInstances.Builder builder = OpenSearchReservedInstances.builder();
        openSearchReservedInstances.accept(builder);
        return fromOpenSearchReservedInstances(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftReservedInstances()} initialized to the given value.
     *
     * <p>
     * The Redshift reserved instances recommendation details.
     * </p>
     * 
     * @param redshiftReservedInstances
     *        The Redshift reserved instances recommendation details.
     */
    public static ResourceDetails fromRedshiftReservedInstances(RedshiftReservedInstances redshiftReservedInstances) {
        return builder().redshiftReservedInstances(redshiftReservedInstances).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftReservedInstances()} initialized to the given value.
     *
     * <p>
     * The Redshift reserved instances recommendation details.
     * </p>
     * 
     * @param redshiftReservedInstances
     *        The Redshift reserved instances recommendation details.
     */
    public static ResourceDetails fromRedshiftReservedInstances(
            Consumer<RedshiftReservedInstances.Builder> redshiftReservedInstances) {
        RedshiftReservedInstances.Builder builder = RedshiftReservedInstances.builder();
        redshiftReservedInstances.accept(builder);
        return fromRedshiftReservedInstances(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ec2InstanceSavingsPlans()} initialized to the given value.
     *
     * <p>
     * The EC2 instance Savings Plans recommendation details.
     * </p>
     * 
     * @param ec2InstanceSavingsPlans
     *        The EC2 instance Savings Plans recommendation details.
     */
    public static ResourceDetails fromEc2InstanceSavingsPlans(Ec2InstanceSavingsPlans ec2InstanceSavingsPlans) {
        return builder().ec2InstanceSavingsPlans(ec2InstanceSavingsPlans).build();
    }

    /**
     * Create an instance of this class with {@link #ec2InstanceSavingsPlans()} initialized to the given value.
     *
     * <p>
     * The EC2 instance Savings Plans recommendation details.
     * </p>
     * 
     * @param ec2InstanceSavingsPlans
     *        The EC2 instance Savings Plans recommendation details.
     */
    public static ResourceDetails fromEc2InstanceSavingsPlans(Consumer<Ec2InstanceSavingsPlans.Builder> ec2InstanceSavingsPlans) {
        Ec2InstanceSavingsPlans.Builder builder = Ec2InstanceSavingsPlans.builder();
        ec2InstanceSavingsPlans.accept(builder);
        return fromEc2InstanceSavingsPlans(builder.build());
    }

    /**
     * Create an instance of this class with {@link #computeSavingsPlans()} initialized to the given value.
     *
     * <p>
     * The Compute Savings Plans recommendation details.
     * </p>
     * 
     * @param computeSavingsPlans
     *        The Compute Savings Plans recommendation details.
     */
    public static ResourceDetails fromComputeSavingsPlans(ComputeSavingsPlans computeSavingsPlans) {
        return builder().computeSavingsPlans(computeSavingsPlans).build();
    }

    /**
     * Create an instance of this class with {@link #computeSavingsPlans()} initialized to the given value.
     *
     * <p>
     * The Compute Savings Plans recommendation details.
     * </p>
     * 
     * @param computeSavingsPlans
     *        The Compute Savings Plans recommendation details.
     */
    public static ResourceDetails fromComputeSavingsPlans(Consumer<ComputeSavingsPlans.Builder> computeSavingsPlans) {
        ComputeSavingsPlans.Builder builder = ComputeSavingsPlans.builder();
        computeSavingsPlans.accept(builder);
        return fromComputeSavingsPlans(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sageMakerSavingsPlans()} initialized to the given value.
     *
     * <p>
     * The SageMaker Savings Plans recommendation details.
     * </p>
     * 
     * @param sageMakerSavingsPlans
     *        The SageMaker Savings Plans recommendation details.
     */
    public static ResourceDetails fromSageMakerSavingsPlans(SageMakerSavingsPlans sageMakerSavingsPlans) {
        return builder().sageMakerSavingsPlans(sageMakerSavingsPlans).build();
    }

    /**
     * Create an instance of this class with {@link #sageMakerSavingsPlans()} initialized to the given value.
     *
     * <p>
     * The SageMaker Savings Plans recommendation details.
     * </p>
     * 
     * @param sageMakerSavingsPlans
     *        The SageMaker Savings Plans recommendation details.
     */
    public static ResourceDetails fromSageMakerSavingsPlans(Consumer<SageMakerSavingsPlans.Builder> sageMakerSavingsPlans) {
        SageMakerSavingsPlans.Builder builder = SageMakerSavingsPlans.builder();
        sageMakerSavingsPlans.accept(builder);
        return fromSageMakerSavingsPlans(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rdsDbInstance()} initialized to the given value.
     *
     * <p>
     * The DB instance recommendation details.
     * </p>
     * 
     * @param rdsDbInstance
     *        The DB instance recommendation details.
     */
    public static ResourceDetails fromRdsDbInstance(RdsDbInstance rdsDbInstance) {
        return builder().rdsDbInstance(rdsDbInstance).build();
    }

    /**
     * Create an instance of this class with {@link #rdsDbInstance()} initialized to the given value.
     *
     * <p>
     * The DB instance recommendation details.
     * </p>
     * 
     * @param rdsDbInstance
     *        The DB instance recommendation details.
     */
    public static ResourceDetails fromRdsDbInstance(Consumer<RdsDbInstance.Builder> rdsDbInstance) {
        RdsDbInstance.Builder builder = RdsDbInstance.builder();
        rdsDbInstance.accept(builder);
        return fromRdsDbInstance(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rdsDbInstanceStorage()} initialized to the given value.
     *
     * <p>
     * The DB instance storage recommendation details.
     * </p>
     * 
     * @param rdsDbInstanceStorage
     *        The DB instance storage recommendation details.
     */
    public static ResourceDetails fromRdsDbInstanceStorage(RdsDbInstanceStorage rdsDbInstanceStorage) {
        return builder().rdsDbInstanceStorage(rdsDbInstanceStorage).build();
    }

    /**
     * Create an instance of this class with {@link #rdsDbInstanceStorage()} initialized to the given value.
     *
     * <p>
     * The DB instance storage recommendation details.
     * </p>
     * 
     * @param rdsDbInstanceStorage
     *        The DB instance storage recommendation details.
     */
    public static ResourceDetails fromRdsDbInstanceStorage(Consumer<RdsDbInstanceStorage.Builder> rdsDbInstanceStorage) {
        RdsDbInstanceStorage.Builder builder = RdsDbInstanceStorage.builder();
        rdsDbInstanceStorage.accept(builder);
        return fromRdsDbInstanceStorage(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambdaFunction", LAMBDA_FUNCTION_FIELD);
        map.put("ecsService", ECS_SERVICE_FIELD);
        map.put("ec2Instance", EC2_INSTANCE_FIELD);
        map.put("ebsVolume", EBS_VOLUME_FIELD);
        map.put("ec2AutoScalingGroup", EC2_AUTO_SCALING_GROUP_FIELD);
        map.put("ec2ReservedInstances", EC2_RESERVED_INSTANCES_FIELD);
        map.put("rdsReservedInstances", RDS_RESERVED_INSTANCES_FIELD);
        map.put("elastiCacheReservedInstances", ELASTI_CACHE_RESERVED_INSTANCES_FIELD);
        map.put("openSearchReservedInstances", OPEN_SEARCH_RESERVED_INSTANCES_FIELD);
        map.put("redshiftReservedInstances", REDSHIFT_RESERVED_INSTANCES_FIELD);
        map.put("ec2InstanceSavingsPlans", EC2_INSTANCE_SAVINGS_PLANS_FIELD);
        map.put("computeSavingsPlans", COMPUTE_SAVINGS_PLANS_FIELD);
        map.put("sageMakerSavingsPlans", SAGE_MAKER_SAVINGS_PLANS_FIELD);
        map.put("rdsDbInstance", RDS_DB_INSTANCE_FIELD);
        map.put("rdsDbInstanceStorage", RDS_DB_INSTANCE_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDetails> {
        /**
         * <p>
         * The Lambda function recommendation details.
         * </p>
         * 
         * @param lambdaFunction
         *        The Lambda function recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunction(LambdaFunction lambdaFunction);

        /**
         * <p>
         * The Lambda function recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaFunction.Builder} avoiding the need
         * to create one manually via {@link LambdaFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunction.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaFunction(LambdaFunction)}.
         * 
         * @param lambdaFunction
         *        a consumer that will call methods on {@link LambdaFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunction(LambdaFunction)
         */
        default Builder lambdaFunction(Consumer<LambdaFunction.Builder> lambdaFunction) {
            return lambdaFunction(LambdaFunction.builder().applyMutation(lambdaFunction).build());
        }

        /**
         * <p>
         * The ECS service recommendation details.
         * </p>
         * 
         * @param ecsService
         *        The ECS service recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsService(EcsService ecsService);

        /**
         * <p>
         * The ECS service recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcsService.Builder} avoiding the need to
         * create one manually via {@link EcsService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcsService.Builder#build()} is called immediately and its result
         * is passed to {@link #ecsService(EcsService)}.
         * 
         * @param ecsService
         *        a consumer that will call methods on {@link EcsService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsService(EcsService)
         */
        default Builder ecsService(Consumer<EcsService.Builder> ecsService) {
            return ecsService(EcsService.builder().applyMutation(ecsService).build());
        }

        /**
         * <p>
         * The EC2 instance recommendation details.
         * </p>
         * 
         * @param ec2Instance
         *        The EC2 instance recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Instance(Ec2Instance ec2Instance);

        /**
         * <p>
         * The EC2 instance recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2Instance.Builder} avoiding the need to
         * create one manually via {@link Ec2Instance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2Instance.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2Instance(Ec2Instance)}.
         * 
         * @param ec2Instance
         *        a consumer that will call methods on {@link Ec2Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Instance(Ec2Instance)
         */
        default Builder ec2Instance(Consumer<Ec2Instance.Builder> ec2Instance) {
            return ec2Instance(Ec2Instance.builder().applyMutation(ec2Instance).build());
        }

        /**
         * <p>
         * The Amazon Elastic Block Store volume recommendation details.
         * </p>
         * 
         * @param ebsVolume
         *        The Amazon Elastic Block Store volume recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsVolume(EbsVolume ebsVolume);

        /**
         * <p>
         * The Amazon Elastic Block Store volume recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link EbsVolume.Builder} avoiding the need to
         * create one manually via {@link EbsVolume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EbsVolume.Builder#build()} is called immediately and its result
         * is passed to {@link #ebsVolume(EbsVolume)}.
         * 
         * @param ebsVolume
         *        a consumer that will call methods on {@link EbsVolume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsVolume(EbsVolume)
         */
        default Builder ebsVolume(Consumer<EbsVolume.Builder> ebsVolume) {
            return ebsVolume(EbsVolume.builder().applyMutation(ebsVolume).build());
        }

        /**
         * <p>
         * The EC2 Auto Scaling group recommendation details.
         * </p>
         * 
         * @param ec2AutoScalingGroup
         *        The EC2 Auto Scaling group recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2AutoScalingGroup(Ec2AutoScalingGroup ec2AutoScalingGroup);

        /**
         * <p>
         * The EC2 Auto Scaling group recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2AutoScalingGroup.Builder} avoiding the
         * need to create one manually via {@link Ec2AutoScalingGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2AutoScalingGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2AutoScalingGroup(Ec2AutoScalingGroup)}.
         * 
         * @param ec2AutoScalingGroup
         *        a consumer that will call methods on {@link Ec2AutoScalingGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2AutoScalingGroup(Ec2AutoScalingGroup)
         */
        default Builder ec2AutoScalingGroup(Consumer<Ec2AutoScalingGroup.Builder> ec2AutoScalingGroup) {
            return ec2AutoScalingGroup(Ec2AutoScalingGroup.builder().applyMutation(ec2AutoScalingGroup).build());
        }

        /**
         * <p>
         * The EC2 reserved instances recommendation details.
         * </p>
         * 
         * @param ec2ReservedInstances
         *        The EC2 reserved instances recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ReservedInstances(Ec2ReservedInstances ec2ReservedInstances);

        /**
         * <p>
         * The EC2 reserved instances recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2ReservedInstances.Builder} avoiding
         * the need to create one manually via {@link Ec2ReservedInstances#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2ReservedInstances.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2ReservedInstances(Ec2ReservedInstances)}.
         * 
         * @param ec2ReservedInstances
         *        a consumer that will call methods on {@link Ec2ReservedInstances.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2ReservedInstances(Ec2ReservedInstances)
         */
        default Builder ec2ReservedInstances(Consumer<Ec2ReservedInstances.Builder> ec2ReservedInstances) {
            return ec2ReservedInstances(Ec2ReservedInstances.builder().applyMutation(ec2ReservedInstances).build());
        }

        /**
         * <p>
         * The RDS reserved instances recommendation details.
         * </p>
         * 
         * @param rdsReservedInstances
         *        The RDS reserved instances recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsReservedInstances(RdsReservedInstances rdsReservedInstances);

        /**
         * <p>
         * The RDS reserved instances recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsReservedInstances.Builder} avoiding
         * the need to create one manually via {@link RdsReservedInstances#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsReservedInstances.Builder#build()} is called immediately and
         * its result is passed to {@link #rdsReservedInstances(RdsReservedInstances)}.
         * 
         * @param rdsReservedInstances
         *        a consumer that will call methods on {@link RdsReservedInstances.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsReservedInstances(RdsReservedInstances)
         */
        default Builder rdsReservedInstances(Consumer<RdsReservedInstances.Builder> rdsReservedInstances) {
            return rdsReservedInstances(RdsReservedInstances.builder().applyMutation(rdsReservedInstances).build());
        }

        /**
         * <p>
         * The ElastiCache reserved instances recommendation details.
         * </p>
         * 
         * @param elastiCacheReservedInstances
         *        The ElastiCache reserved instances recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elastiCacheReservedInstances(ElastiCacheReservedInstances elastiCacheReservedInstances);

        /**
         * <p>
         * The ElastiCache reserved instances recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElastiCacheReservedInstances.Builder}
         * avoiding the need to create one manually via {@link ElastiCacheReservedInstances#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElastiCacheReservedInstances.Builder#build()} is called
         * immediately and its result is passed to {@link #elastiCacheReservedInstances(ElastiCacheReservedInstances)}.
         * 
         * @param elastiCacheReservedInstances
         *        a consumer that will call methods on {@link ElastiCacheReservedInstances.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elastiCacheReservedInstances(ElastiCacheReservedInstances)
         */
        default Builder elastiCacheReservedInstances(Consumer<ElastiCacheReservedInstances.Builder> elastiCacheReservedInstances) {
            return elastiCacheReservedInstances(ElastiCacheReservedInstances.builder()
                    .applyMutation(elastiCacheReservedInstances).build());
        }

        /**
         * <p>
         * The OpenSearch reserved instances recommendation details.
         * </p>
         * 
         * @param openSearchReservedInstances
         *        The OpenSearch reserved instances recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openSearchReservedInstances(OpenSearchReservedInstances openSearchReservedInstances);

        /**
         * <p>
         * The OpenSearch reserved instances recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenSearchReservedInstances.Builder}
         * avoiding the need to create one manually via {@link OpenSearchReservedInstances#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchReservedInstances.Builder#build()} is called
         * immediately and its result is passed to {@link #openSearchReservedInstances(OpenSearchReservedInstances)}.
         * 
         * @param openSearchReservedInstances
         *        a consumer that will call methods on {@link OpenSearchReservedInstances.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openSearchReservedInstances(OpenSearchReservedInstances)
         */
        default Builder openSearchReservedInstances(Consumer<OpenSearchReservedInstances.Builder> openSearchReservedInstances) {
            return openSearchReservedInstances(OpenSearchReservedInstances.builder().applyMutation(openSearchReservedInstances)
                    .build());
        }

        /**
         * <p>
         * The Redshift reserved instances recommendation details.
         * </p>
         * 
         * @param redshiftReservedInstances
         *        The Redshift reserved instances recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftReservedInstances(RedshiftReservedInstances redshiftReservedInstances);

        /**
         * <p>
         * The Redshift reserved instances recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftReservedInstances.Builder}
         * avoiding the need to create one manually via {@link RedshiftReservedInstances#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftReservedInstances.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftReservedInstances(RedshiftReservedInstances)}.
         * 
         * @param redshiftReservedInstances
         *        a consumer that will call methods on {@link RedshiftReservedInstances.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftReservedInstances(RedshiftReservedInstances)
         */
        default Builder redshiftReservedInstances(Consumer<RedshiftReservedInstances.Builder> redshiftReservedInstances) {
            return redshiftReservedInstances(RedshiftReservedInstances.builder().applyMutation(redshiftReservedInstances).build());
        }

        /**
         * <p>
         * The EC2 instance Savings Plans recommendation details.
         * </p>
         * 
         * @param ec2InstanceSavingsPlans
         *        The EC2 instance Savings Plans recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceSavingsPlans(Ec2InstanceSavingsPlans ec2InstanceSavingsPlans);

        /**
         * <p>
         * The EC2 instance Savings Plans recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2InstanceSavingsPlans.Builder} avoiding
         * the need to create one manually via {@link Ec2InstanceSavingsPlans#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2InstanceSavingsPlans.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2InstanceSavingsPlans(Ec2InstanceSavingsPlans)}.
         * 
         * @param ec2InstanceSavingsPlans
         *        a consumer that will call methods on {@link Ec2InstanceSavingsPlans.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceSavingsPlans(Ec2InstanceSavingsPlans)
         */
        default Builder ec2InstanceSavingsPlans(Consumer<Ec2InstanceSavingsPlans.Builder> ec2InstanceSavingsPlans) {
            return ec2InstanceSavingsPlans(Ec2InstanceSavingsPlans.builder().applyMutation(ec2InstanceSavingsPlans).build());
        }

        /**
         * <p>
         * The Compute Savings Plans recommendation details.
         * </p>
         * 
         * @param computeSavingsPlans
         *        The Compute Savings Plans recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeSavingsPlans(ComputeSavingsPlans computeSavingsPlans);

        /**
         * <p>
         * The Compute Savings Plans recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeSavingsPlans.Builder} avoiding the
         * need to create one manually via {@link ComputeSavingsPlans#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeSavingsPlans.Builder#build()} is called immediately and
         * its result is passed to {@link #computeSavingsPlans(ComputeSavingsPlans)}.
         * 
         * @param computeSavingsPlans
         *        a consumer that will call methods on {@link ComputeSavingsPlans.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeSavingsPlans(ComputeSavingsPlans)
         */
        default Builder computeSavingsPlans(Consumer<ComputeSavingsPlans.Builder> computeSavingsPlans) {
            return computeSavingsPlans(ComputeSavingsPlans.builder().applyMutation(computeSavingsPlans).build());
        }

        /**
         * <p>
         * The SageMaker Savings Plans recommendation details.
         * </p>
         * 
         * @param sageMakerSavingsPlans
         *        The SageMaker Savings Plans recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerSavingsPlans(SageMakerSavingsPlans sageMakerSavingsPlans);

        /**
         * <p>
         * The SageMaker Savings Plans recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link SageMakerSavingsPlans.Builder} avoiding
         * the need to create one manually via {@link SageMakerSavingsPlans#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SageMakerSavingsPlans.Builder#build()} is called immediately and
         * its result is passed to {@link #sageMakerSavingsPlans(SageMakerSavingsPlans)}.
         * 
         * @param sageMakerSavingsPlans
         *        a consumer that will call methods on {@link SageMakerSavingsPlans.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sageMakerSavingsPlans(SageMakerSavingsPlans)
         */
        default Builder sageMakerSavingsPlans(Consumer<SageMakerSavingsPlans.Builder> sageMakerSavingsPlans) {
            return sageMakerSavingsPlans(SageMakerSavingsPlans.builder().applyMutation(sageMakerSavingsPlans).build());
        }

        /**
         * <p>
         * The DB instance recommendation details.
         * </p>
         * 
         * @param rdsDbInstance
         *        The DB instance recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstance(RdsDbInstance rdsDbInstance);

        /**
         * <p>
         * The DB instance recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsDbInstance.Builder} avoiding the need
         * to create one manually via {@link RdsDbInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsDbInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #rdsDbInstance(RdsDbInstance)}.
         * 
         * @param rdsDbInstance
         *        a consumer that will call methods on {@link RdsDbInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsDbInstance(RdsDbInstance)
         */
        default Builder rdsDbInstance(Consumer<RdsDbInstance.Builder> rdsDbInstance) {
            return rdsDbInstance(RdsDbInstance.builder().applyMutation(rdsDbInstance).build());
        }

        /**
         * <p>
         * The DB instance storage recommendation details.
         * </p>
         * 
         * @param rdsDbInstanceStorage
         *        The DB instance storage recommendation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceStorage(RdsDbInstanceStorage rdsDbInstanceStorage);

        /**
         * <p>
         * The DB instance storage recommendation details.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsDbInstanceStorage.Builder} avoiding
         * the need to create one manually via {@link RdsDbInstanceStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsDbInstanceStorage.Builder#build()} is called immediately and
         * its result is passed to {@link #rdsDbInstanceStorage(RdsDbInstanceStorage)}.
         * 
         * @param rdsDbInstanceStorage
         *        a consumer that will call methods on {@link RdsDbInstanceStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsDbInstanceStorage(RdsDbInstanceStorage)
         */
        default Builder rdsDbInstanceStorage(Consumer<RdsDbInstanceStorage.Builder> rdsDbInstanceStorage) {
            return rdsDbInstanceStorage(RdsDbInstanceStorage.builder().applyMutation(rdsDbInstanceStorage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaFunction lambdaFunction;

        private EcsService ecsService;

        private Ec2Instance ec2Instance;

        private EbsVolume ebsVolume;

        private Ec2AutoScalingGroup ec2AutoScalingGroup;

        private Ec2ReservedInstances ec2ReservedInstances;

        private RdsReservedInstances rdsReservedInstances;

        private ElastiCacheReservedInstances elastiCacheReservedInstances;

        private OpenSearchReservedInstances openSearchReservedInstances;

        private RedshiftReservedInstances redshiftReservedInstances;

        private Ec2InstanceSavingsPlans ec2InstanceSavingsPlans;

        private ComputeSavingsPlans computeSavingsPlans;

        private SageMakerSavingsPlans sageMakerSavingsPlans;

        private RdsDbInstance rdsDbInstance;

        private RdsDbInstanceStorage rdsDbInstanceStorage;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            lambdaFunction(model.lambdaFunction);
            ecsService(model.ecsService);
            ec2Instance(model.ec2Instance);
            ebsVolume(model.ebsVolume);
            ec2AutoScalingGroup(model.ec2AutoScalingGroup);
            ec2ReservedInstances(model.ec2ReservedInstances);
            rdsReservedInstances(model.rdsReservedInstances);
            elastiCacheReservedInstances(model.elastiCacheReservedInstances);
            openSearchReservedInstances(model.openSearchReservedInstances);
            redshiftReservedInstances(model.redshiftReservedInstances);
            ec2InstanceSavingsPlans(model.ec2InstanceSavingsPlans);
            computeSavingsPlans(model.computeSavingsPlans);
            sageMakerSavingsPlans(model.sageMakerSavingsPlans);
            rdsDbInstance(model.rdsDbInstance);
            rdsDbInstanceStorage(model.rdsDbInstanceStorage);
        }

        public final LambdaFunction.Builder getLambdaFunction() {
            return lambdaFunction != null ? lambdaFunction.toBuilder() : null;
        }

        public final void setLambdaFunction(LambdaFunction.BuilderImpl lambdaFunction) {
            Object oldValue = this.lambdaFunction;
            this.lambdaFunction = lambdaFunction != null ? lambdaFunction.build() : null;
            handleUnionValueChange(Type.LAMBDA_FUNCTION, oldValue, this.lambdaFunction);
        }

        @Override
        public final Builder lambdaFunction(LambdaFunction lambdaFunction) {
            Object oldValue = this.lambdaFunction;
            this.lambdaFunction = lambdaFunction;
            handleUnionValueChange(Type.LAMBDA_FUNCTION, oldValue, this.lambdaFunction);
            return this;
        }

        public final EcsService.Builder getEcsService() {
            return ecsService != null ? ecsService.toBuilder() : null;
        }

        public final void setEcsService(EcsService.BuilderImpl ecsService) {
            Object oldValue = this.ecsService;
            this.ecsService = ecsService != null ? ecsService.build() : null;
            handleUnionValueChange(Type.ECS_SERVICE, oldValue, this.ecsService);
        }

        @Override
        public final Builder ecsService(EcsService ecsService) {
            Object oldValue = this.ecsService;
            this.ecsService = ecsService;
            handleUnionValueChange(Type.ECS_SERVICE, oldValue, this.ecsService);
            return this;
        }

        public final Ec2Instance.Builder getEc2Instance() {
            return ec2Instance != null ? ec2Instance.toBuilder() : null;
        }

        public final void setEc2Instance(Ec2Instance.BuilderImpl ec2Instance) {
            Object oldValue = this.ec2Instance;
            this.ec2Instance = ec2Instance != null ? ec2Instance.build() : null;
            handleUnionValueChange(Type.EC2_INSTANCE, oldValue, this.ec2Instance);
        }

        @Override
        public final Builder ec2Instance(Ec2Instance ec2Instance) {
            Object oldValue = this.ec2Instance;
            this.ec2Instance = ec2Instance;
            handleUnionValueChange(Type.EC2_INSTANCE, oldValue, this.ec2Instance);
            return this;
        }

        public final EbsVolume.Builder getEbsVolume() {
            return ebsVolume != null ? ebsVolume.toBuilder() : null;
        }

        public final void setEbsVolume(EbsVolume.BuilderImpl ebsVolume) {
            Object oldValue = this.ebsVolume;
            this.ebsVolume = ebsVolume != null ? ebsVolume.build() : null;
            handleUnionValueChange(Type.EBS_VOLUME, oldValue, this.ebsVolume);
        }

        @Override
        public final Builder ebsVolume(EbsVolume ebsVolume) {
            Object oldValue = this.ebsVolume;
            this.ebsVolume = ebsVolume;
            handleUnionValueChange(Type.EBS_VOLUME, oldValue, this.ebsVolume);
            return this;
        }

        public final Ec2AutoScalingGroup.Builder getEc2AutoScalingGroup() {
            return ec2AutoScalingGroup != null ? ec2AutoScalingGroup.toBuilder() : null;
        }

        public final void setEc2AutoScalingGroup(Ec2AutoScalingGroup.BuilderImpl ec2AutoScalingGroup) {
            Object oldValue = this.ec2AutoScalingGroup;
            this.ec2AutoScalingGroup = ec2AutoScalingGroup != null ? ec2AutoScalingGroup.build() : null;
            handleUnionValueChange(Type.EC2_AUTO_SCALING_GROUP, oldValue, this.ec2AutoScalingGroup);
        }

        @Override
        public final Builder ec2AutoScalingGroup(Ec2AutoScalingGroup ec2AutoScalingGroup) {
            Object oldValue = this.ec2AutoScalingGroup;
            this.ec2AutoScalingGroup = ec2AutoScalingGroup;
            handleUnionValueChange(Type.EC2_AUTO_SCALING_GROUP, oldValue, this.ec2AutoScalingGroup);
            return this;
        }

        public final Ec2ReservedInstances.Builder getEc2ReservedInstances() {
            return ec2ReservedInstances != null ? ec2ReservedInstances.toBuilder() : null;
        }

        public final void setEc2ReservedInstances(Ec2ReservedInstances.BuilderImpl ec2ReservedInstances) {
            Object oldValue = this.ec2ReservedInstances;
            this.ec2ReservedInstances = ec2ReservedInstances != null ? ec2ReservedInstances.build() : null;
            handleUnionValueChange(Type.EC2_RESERVED_INSTANCES, oldValue, this.ec2ReservedInstances);
        }

        @Override
        public final Builder ec2ReservedInstances(Ec2ReservedInstances ec2ReservedInstances) {
            Object oldValue = this.ec2ReservedInstances;
            this.ec2ReservedInstances = ec2ReservedInstances;
            handleUnionValueChange(Type.EC2_RESERVED_INSTANCES, oldValue, this.ec2ReservedInstances);
            return this;
        }

        public final RdsReservedInstances.Builder getRdsReservedInstances() {
            return rdsReservedInstances != null ? rdsReservedInstances.toBuilder() : null;
        }

        public final void setRdsReservedInstances(RdsReservedInstances.BuilderImpl rdsReservedInstances) {
            Object oldValue = this.rdsReservedInstances;
            this.rdsReservedInstances = rdsReservedInstances != null ? rdsReservedInstances.build() : null;
            handleUnionValueChange(Type.RDS_RESERVED_INSTANCES, oldValue, this.rdsReservedInstances);
        }

        @Override
        public final Builder rdsReservedInstances(RdsReservedInstances rdsReservedInstances) {
            Object oldValue = this.rdsReservedInstances;
            this.rdsReservedInstances = rdsReservedInstances;
            handleUnionValueChange(Type.RDS_RESERVED_INSTANCES, oldValue, this.rdsReservedInstances);
            return this;
        }

        public final ElastiCacheReservedInstances.Builder getElastiCacheReservedInstances() {
            return elastiCacheReservedInstances != null ? elastiCacheReservedInstances.toBuilder() : null;
        }

        public final void setElastiCacheReservedInstances(ElastiCacheReservedInstances.BuilderImpl elastiCacheReservedInstances) {
            Object oldValue = this.elastiCacheReservedInstances;
            this.elastiCacheReservedInstances = elastiCacheReservedInstances != null ? elastiCacheReservedInstances.build()
                    : null;
            handleUnionValueChange(Type.ELASTI_CACHE_RESERVED_INSTANCES, oldValue, this.elastiCacheReservedInstances);
        }

        @Override
        public final Builder elastiCacheReservedInstances(ElastiCacheReservedInstances elastiCacheReservedInstances) {
            Object oldValue = this.elastiCacheReservedInstances;
            this.elastiCacheReservedInstances = elastiCacheReservedInstances;
            handleUnionValueChange(Type.ELASTI_CACHE_RESERVED_INSTANCES, oldValue, this.elastiCacheReservedInstances);
            return this;
        }

        public final OpenSearchReservedInstances.Builder getOpenSearchReservedInstances() {
            return openSearchReservedInstances != null ? openSearchReservedInstances.toBuilder() : null;
        }

        public final void setOpenSearchReservedInstances(OpenSearchReservedInstances.BuilderImpl openSearchReservedInstances) {
            Object oldValue = this.openSearchReservedInstances;
            this.openSearchReservedInstances = openSearchReservedInstances != null ? openSearchReservedInstances.build() : null;
            handleUnionValueChange(Type.OPEN_SEARCH_RESERVED_INSTANCES, oldValue, this.openSearchReservedInstances);
        }

        @Override
        public final Builder openSearchReservedInstances(OpenSearchReservedInstances openSearchReservedInstances) {
            Object oldValue = this.openSearchReservedInstances;
            this.openSearchReservedInstances = openSearchReservedInstances;
            handleUnionValueChange(Type.OPEN_SEARCH_RESERVED_INSTANCES, oldValue, this.openSearchReservedInstances);
            return this;
        }

        public final RedshiftReservedInstances.Builder getRedshiftReservedInstances() {
            return redshiftReservedInstances != null ? redshiftReservedInstances.toBuilder() : null;
        }

        public final void setRedshiftReservedInstances(RedshiftReservedInstances.BuilderImpl redshiftReservedInstances) {
            Object oldValue = this.redshiftReservedInstances;
            this.redshiftReservedInstances = redshiftReservedInstances != null ? redshiftReservedInstances.build() : null;
            handleUnionValueChange(Type.REDSHIFT_RESERVED_INSTANCES, oldValue, this.redshiftReservedInstances);
        }

        @Override
        public final Builder redshiftReservedInstances(RedshiftReservedInstances redshiftReservedInstances) {
            Object oldValue = this.redshiftReservedInstances;
            this.redshiftReservedInstances = redshiftReservedInstances;
            handleUnionValueChange(Type.REDSHIFT_RESERVED_INSTANCES, oldValue, this.redshiftReservedInstances);
            return this;
        }

        public final Ec2InstanceSavingsPlans.Builder getEc2InstanceSavingsPlans() {
            return ec2InstanceSavingsPlans != null ? ec2InstanceSavingsPlans.toBuilder() : null;
        }

        public final void setEc2InstanceSavingsPlans(Ec2InstanceSavingsPlans.BuilderImpl ec2InstanceSavingsPlans) {
            Object oldValue = this.ec2InstanceSavingsPlans;
            this.ec2InstanceSavingsPlans = ec2InstanceSavingsPlans != null ? ec2InstanceSavingsPlans.build() : null;
            handleUnionValueChange(Type.EC2_INSTANCE_SAVINGS_PLANS, oldValue, this.ec2InstanceSavingsPlans);
        }

        @Override
        public final Builder ec2InstanceSavingsPlans(Ec2InstanceSavingsPlans ec2InstanceSavingsPlans) {
            Object oldValue = this.ec2InstanceSavingsPlans;
            this.ec2InstanceSavingsPlans = ec2InstanceSavingsPlans;
            handleUnionValueChange(Type.EC2_INSTANCE_SAVINGS_PLANS, oldValue, this.ec2InstanceSavingsPlans);
            return this;
        }

        public final ComputeSavingsPlans.Builder getComputeSavingsPlans() {
            return computeSavingsPlans != null ? computeSavingsPlans.toBuilder() : null;
        }

        public final void setComputeSavingsPlans(ComputeSavingsPlans.BuilderImpl computeSavingsPlans) {
            Object oldValue = this.computeSavingsPlans;
            this.computeSavingsPlans = computeSavingsPlans != null ? computeSavingsPlans.build() : null;
            handleUnionValueChange(Type.COMPUTE_SAVINGS_PLANS, oldValue, this.computeSavingsPlans);
        }

        @Override
        public final Builder computeSavingsPlans(ComputeSavingsPlans computeSavingsPlans) {
            Object oldValue = this.computeSavingsPlans;
            this.computeSavingsPlans = computeSavingsPlans;
            handleUnionValueChange(Type.COMPUTE_SAVINGS_PLANS, oldValue, this.computeSavingsPlans);
            return this;
        }

        public final SageMakerSavingsPlans.Builder getSageMakerSavingsPlans() {
            return sageMakerSavingsPlans != null ? sageMakerSavingsPlans.toBuilder() : null;
        }

        public final void setSageMakerSavingsPlans(SageMakerSavingsPlans.BuilderImpl sageMakerSavingsPlans) {
            Object oldValue = this.sageMakerSavingsPlans;
            this.sageMakerSavingsPlans = sageMakerSavingsPlans != null ? sageMakerSavingsPlans.build() : null;
            handleUnionValueChange(Type.SAGE_MAKER_SAVINGS_PLANS, oldValue, this.sageMakerSavingsPlans);
        }

        @Override
        public final Builder sageMakerSavingsPlans(SageMakerSavingsPlans sageMakerSavingsPlans) {
            Object oldValue = this.sageMakerSavingsPlans;
            this.sageMakerSavingsPlans = sageMakerSavingsPlans;
            handleUnionValueChange(Type.SAGE_MAKER_SAVINGS_PLANS, oldValue, this.sageMakerSavingsPlans);
            return this;
        }

        public final RdsDbInstance.Builder getRdsDbInstance() {
            return rdsDbInstance != null ? rdsDbInstance.toBuilder() : null;
        }

        public final void setRdsDbInstance(RdsDbInstance.BuilderImpl rdsDbInstance) {
            Object oldValue = this.rdsDbInstance;
            this.rdsDbInstance = rdsDbInstance != null ? rdsDbInstance.build() : null;
            handleUnionValueChange(Type.RDS_DB_INSTANCE, oldValue, this.rdsDbInstance);
        }

        @Override
        public final Builder rdsDbInstance(RdsDbInstance rdsDbInstance) {
            Object oldValue = this.rdsDbInstance;
            this.rdsDbInstance = rdsDbInstance;
            handleUnionValueChange(Type.RDS_DB_INSTANCE, oldValue, this.rdsDbInstance);
            return this;
        }

        public final RdsDbInstanceStorage.Builder getRdsDbInstanceStorage() {
            return rdsDbInstanceStorage != null ? rdsDbInstanceStorage.toBuilder() : null;
        }

        public final void setRdsDbInstanceStorage(RdsDbInstanceStorage.BuilderImpl rdsDbInstanceStorage) {
            Object oldValue = this.rdsDbInstanceStorage;
            this.rdsDbInstanceStorage = rdsDbInstanceStorage != null ? rdsDbInstanceStorage.build() : null;
            handleUnionValueChange(Type.RDS_DB_INSTANCE_STORAGE, oldValue, this.rdsDbInstanceStorage);
        }

        @Override
        public final Builder rdsDbInstanceStorage(RdsDbInstanceStorage rdsDbInstanceStorage) {
            Object oldValue = this.rdsDbInstanceStorage;
            this.rdsDbInstanceStorage = rdsDbInstanceStorage;
            handleUnionValueChange(Type.RDS_DB_INSTANCE_STORAGE, oldValue, this.rdsDbInstanceStorage);
            return this;
        }

        @Override
        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ResourceDetails#type()
     */
    public enum Type {
        LAMBDA_FUNCTION,

        ECS_SERVICE,

        EC2_INSTANCE,

        EBS_VOLUME,

        EC2_AUTO_SCALING_GROUP,

        EC2_RESERVED_INSTANCES,

        RDS_RESERVED_INSTANCES,

        ELASTI_CACHE_RESERVED_INSTANCES,

        OPEN_SEARCH_RESERVED_INSTANCES,

        REDSHIFT_RESERVED_INSTANCES,

        EC2_INSTANCE_SAVINGS_PLANS,

        COMPUTE_SAVINGS_PLANS,

        SAGE_MAKER_SAVINGS_PLANS,

        RDS_DB_INSTANCE,

        RDS_DB_INSTANCE_STORAGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
