/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon Elastic Block Store volume configuration of the current and recommended resource configuration
 * for a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsVolume implements SdkPojo, Serializable, ToCopyableBuilder<EbsVolume.Builder, EbsVolume> {
    private static final SdkField<EbsVolumeConfiguration> CONFIGURATION_FIELD = SdkField
            .<EbsVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(EbsVolume::configuration)).setter(setter(Builder::configuration))
            .constructor(EbsVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<ResourceCostCalculation> COST_CALCULATION_FIELD = SdkField
            .<ResourceCostCalculation> builder(MarshallingType.SDK_POJO).memberName("costCalculation")
            .getter(getter(EbsVolume::costCalculation)).setter(setter(Builder::costCalculation))
            .constructor(ResourceCostCalculation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCalculation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            COST_CALCULATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EbsVolumeConfiguration configuration;

    private final ResourceCostCalculation costCalculation;

    private EbsVolume(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.costCalculation = builder.costCalculation;
    }

    /**
     * <p>
     * The Amazon Elastic Block Store volume configuration used for recommendations.
     * </p>
     * 
     * @return The Amazon Elastic Block Store volume configuration used for recommendations.
     */
    public final EbsVolumeConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Cost impact of the recommendation.
     * </p>
     * 
     * @return Cost impact of the recommendation.
     */
    public final ResourceCostCalculation costCalculation() {
        return costCalculation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(costCalculation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolume)) {
            return false;
        }
        EbsVolume other = (EbsVolume) obj;
        return Objects.equals(configuration(), other.configuration())
                && Objects.equals(costCalculation(), other.costCalculation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsVolume").add("Configuration", configuration()).add("CostCalculation", costCalculation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "costCalculation":
            return Optional.ofNullable(clazz.cast(costCalculation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("costCalculation", COST_CALCULATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EbsVolume, T> g) {
        return obj -> g.apply((EbsVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsVolume> {
        /**
         * <p>
         * The Amazon Elastic Block Store volume configuration used for recommendations.
         * </p>
         * 
         * @param configuration
         *        The Amazon Elastic Block Store volume configuration used for recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(EbsVolumeConfiguration configuration);

        /**
         * <p>
         * The Amazon Elastic Block Store volume configuration used for recommendations.
         * </p>
         * This is a convenience method that creates an instance of the {@link EbsVolumeConfiguration.Builder} avoiding
         * the need to create one manually via {@link EbsVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EbsVolumeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(EbsVolumeConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link EbsVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(EbsVolumeConfiguration)
         */
        default Builder configuration(Consumer<EbsVolumeConfiguration.Builder> configuration) {
            return configuration(EbsVolumeConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Cost impact of the recommendation.
         * </p>
         * 
         * @param costCalculation
         *        Cost impact of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCalculation(ResourceCostCalculation costCalculation);

        /**
         * <p>
         * Cost impact of the recommendation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCostCalculation.Builder} avoiding
         * the need to create one manually via {@link ResourceCostCalculation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCostCalculation.Builder#build()} is called immediately
         * and its result is passed to {@link #costCalculation(ResourceCostCalculation)}.
         * 
         * @param costCalculation
         *        a consumer that will call methods on {@link ResourceCostCalculation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costCalculation(ResourceCostCalculation)
         */
        default Builder costCalculation(Consumer<ResourceCostCalculation.Builder> costCalculation) {
            return costCalculation(ResourceCostCalculation.builder().applyMutation(costCalculation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EbsVolumeConfiguration configuration;

        private ResourceCostCalculation costCalculation;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolume model) {
            configuration(model.configuration);
            costCalculation(model.costCalculation);
        }

        public final EbsVolumeConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(EbsVolumeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(EbsVolumeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ResourceCostCalculation.Builder getCostCalculation() {
            return costCalculation != null ? costCalculation.toBuilder() : null;
        }

        public final void setCostCalculation(ResourceCostCalculation.BuilderImpl costCalculation) {
            this.costCalculation = costCalculation != null ? costCalculation.build() : null;
        }

        @Override
        public final Builder costCalculation(ResourceCostCalculation costCalculation) {
            this.costCalculation = costCalculation;
            return this;
        }

        @Override
        public EbsVolume build() {
            return new EbsVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
