/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationResponse extends CostOptimizationHubResponse implements
        ToCopyableBuilder<GetRecommendationResponse.Builder, GetRecommendationResponse> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(GetRecommendationResponse::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(GetRecommendationResponse::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetRecommendationResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(GetRecommendationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currencyCode").getter(getter(GetRecommendationResponse::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<Integer> RECOMMENDATION_LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("recommendationLookbackPeriodInDays")
            .getter(getter(GetRecommendationResponse::recommendationLookbackPeriodInDays))
            .setter(setter(Builder::recommendationLookbackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationLookbackPeriodInDays")
                    .build()).build();

    private static final SdkField<Integer> COST_CALCULATION_LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("costCalculationLookbackPeriodInDays")
            .getter(getter(GetRecommendationResponse::costCalculationLookbackPeriodInDays))
            .setter(setter(Builder::costCalculationLookbackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("costCalculationLookbackPeriodInDays").build()).build();

    private static final SdkField<Double> ESTIMATED_SAVINGS_PERCENTAGE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedSavingsPercentage")
            .getter(getter(GetRecommendationResponse::estimatedSavingsPercentage))
            .setter(setter(Builder::estimatedSavingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedSavingsPercentage").build())
            .build();

    private static final SdkField<Double> ESTIMATED_SAVINGS_OVER_COST_CALCULATION_LOOKBACK_PERIOD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedSavingsOverCostCalculationLookbackPeriod")
            .getter(getter(GetRecommendationResponse::estimatedSavingsOverCostCalculationLookbackPeriod))
            .setter(setter(Builder::estimatedSavingsOverCostCalculationLookbackPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("estimatedSavingsOverCostCalculationLookbackPeriod").build()).build();

    private static final SdkField<String> CURRENT_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentResourceType").getter(getter(GetRecommendationResponse::currentResourceTypeAsString))
            .setter(setter(Builder::currentResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentResourceType").build())
            .build();

    private static final SdkField<String> RECOMMENDED_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendedResourceType").getter(getter(GetRecommendationResponse::recommendedResourceTypeAsString))
            .setter(setter(Builder::recommendedResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedResourceType").build())
            .build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(GetRecommendationResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(GetRecommendationResponse::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastRefreshTimestamp").getter(getter(GetRecommendationResponse::lastRefreshTimestamp))
            .setter(setter(Builder::lastRefreshTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build())
            .build();

    private static final SdkField<Double> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedMonthlySavings").getter(getter(GetRecommendationResponse::estimatedMonthlySavings))
            .setter(setter(Builder::estimatedMonthlySavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build())
            .build();

    private static final SdkField<Double> ESTIMATED_MONTHLY_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedMonthlyCost").getter(getter(GetRecommendationResponse::estimatedMonthlyCost))
            .setter(setter(Builder::estimatedMonthlyCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlyCost").build())
            .build();

    private static final SdkField<String> IMPLEMENTATION_EFFORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("implementationEffort").getter(getter(GetRecommendationResponse::implementationEffortAsString))
            .setter(setter(Builder::implementationEffort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("implementationEffort").build())
            .build();

    private static final SdkField<Boolean> RESTART_NEEDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("restartNeeded").getter(getter(GetRecommendationResponse::restartNeeded))
            .setter(setter(Builder::restartNeeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartNeeded").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(GetRecommendationResponse::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<Boolean> ROLLBACK_POSSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("rollbackPossible").getter(getter(GetRecommendationResponse::rollbackPossible))
            .setter(setter(Builder::rollbackPossible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackPossible").build()).build();

    private static final SdkField<ResourceDetails> CURRENT_RESOURCE_DETAILS_FIELD = SdkField
            .<ResourceDetails> builder(MarshallingType.SDK_POJO).memberName("currentResourceDetails")
            .getter(getter(GetRecommendationResponse::currentResourceDetails)).setter(setter(Builder::currentResourceDetails))
            .constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentResourceDetails").build())
            .build();

    private static final SdkField<ResourceDetails> RECOMMENDED_RESOURCE_DETAILS_FIELD = SdkField
            .<ResourceDetails> builder(MarshallingType.SDK_POJO)
            .memberName("recommendedResourceDetails")
            .getter(getter(GetRecommendationResponse::recommendedResourceDetails))
            .setter(setter(Builder::recommendedResourceDetails))
            .constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedResourceDetails").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(GetRecommendationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            RESOURCE_ID_FIELD, RESOURCE_ARN_FIELD, ACCOUNT_ID_FIELD, CURRENCY_CODE_FIELD,
            RECOMMENDATION_LOOKBACK_PERIOD_IN_DAYS_FIELD, COST_CALCULATION_LOOKBACK_PERIOD_IN_DAYS_FIELD,
            ESTIMATED_SAVINGS_PERCENTAGE_FIELD, ESTIMATED_SAVINGS_OVER_COST_CALCULATION_LOOKBACK_PERIOD_FIELD,
            CURRENT_RESOURCE_TYPE_FIELD, RECOMMENDED_RESOURCE_TYPE_FIELD, REGION_FIELD, SOURCE_FIELD,
            LAST_REFRESH_TIMESTAMP_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD, ESTIMATED_MONTHLY_COST_FIELD,
            IMPLEMENTATION_EFFORT_FIELD, RESTART_NEEDED_FIELD, ACTION_TYPE_FIELD, ROLLBACK_POSSIBLE_FIELD,
            CURRENT_RESOURCE_DETAILS_FIELD, RECOMMENDED_RESOURCE_DETAILS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String recommendationId;

    private final String resourceId;

    private final String resourceArn;

    private final String accountId;

    private final String currencyCode;

    private final Integer recommendationLookbackPeriodInDays;

    private final Integer costCalculationLookbackPeriodInDays;

    private final Double estimatedSavingsPercentage;

    private final Double estimatedSavingsOverCostCalculationLookbackPeriod;

    private final String currentResourceType;

    private final String recommendedResourceType;

    private final String region;

    private final String source;

    private final Instant lastRefreshTimestamp;

    private final Double estimatedMonthlySavings;

    private final Double estimatedMonthlyCost;

    private final String implementationEffort;

    private final Boolean restartNeeded;

    private final String actionType;

    private final Boolean rollbackPossible;

    private final ResourceDetails currentResourceDetails;

    private final ResourceDetails recommendedResourceDetails;

    private final List<Tag> tags;

    private GetRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationId = builder.recommendationId;
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
        this.accountId = builder.accountId;
        this.currencyCode = builder.currencyCode;
        this.recommendationLookbackPeriodInDays = builder.recommendationLookbackPeriodInDays;
        this.costCalculationLookbackPeriodInDays = builder.costCalculationLookbackPeriodInDays;
        this.estimatedSavingsPercentage = builder.estimatedSavingsPercentage;
        this.estimatedSavingsOverCostCalculationLookbackPeriod = builder.estimatedSavingsOverCostCalculationLookbackPeriod;
        this.currentResourceType = builder.currentResourceType;
        this.recommendedResourceType = builder.recommendedResourceType;
        this.region = builder.region;
        this.source = builder.source;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.estimatedMonthlyCost = builder.estimatedMonthlyCost;
        this.implementationEffort = builder.implementationEffort;
        this.restartNeeded = builder.restartNeeded;
        this.actionType = builder.actionType;
        this.rollbackPossible = builder.rollbackPossible;
        this.currentResourceDetails = builder.currentResourceDetails;
        this.recommendedResourceDetails = builder.recommendedResourceDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID for the recommendation.
     * </p>
     * 
     * @return The ID for the recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The unique identifier for the resource. This is the same as the Amazon Resource Name (ARN), if available.
     * </p>
     * 
     * @return The unique identifier for the resource. This is the same as the Amazon Resource Name (ARN), if available.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The account that the recommendation is for.
     * </p>
     * 
     * @return The account that the recommendation is for.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The currency code used for the recommendation.
     * </p>
     * 
     * @return The currency code used for the recommendation.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The lookback period that's used to generate the recommendation.
     * </p>
     * 
     * @return The lookback period that's used to generate the recommendation.
     */
    public final Integer recommendationLookbackPeriodInDays() {
        return recommendationLookbackPeriodInDays;
    }

    /**
     * <p>
     * The lookback period used to calculate cost impact for a recommendation.
     * </p>
     * 
     * @return The lookback period used to calculate cost impact for a recommendation.
     */
    public final Integer costCalculationLookbackPeriodInDays() {
        return costCalculationLookbackPeriodInDays;
    }

    /**
     * <p>
     * The estimated savings percentage relative to the total cost over the cost calculation lookback period.
     * </p>
     * 
     * @return The estimated savings percentage relative to the total cost over the cost calculation lookback period.
     */
    public final Double estimatedSavingsPercentage() {
        return estimatedSavingsPercentage;
    }

    /**
     * <p>
     * The estimated savings amount over the lookback period used to calculate cost impact for a recommendation.
     * </p>
     * 
     * @return The estimated savings amount over the lookback period used to calculate cost impact for a recommendation.
     */
    public final Double estimatedSavingsOverCostCalculationLookbackPeriod() {
        return estimatedSavingsOverCostCalculationLookbackPeriod;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentResourceType} will return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #currentResourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see ResourceType
     */
    public final ResourceType currentResourceType() {
        return ResourceType.fromValue(currentResourceType);
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentResourceType} will return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #currentResourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource.
     * @see ResourceType
     */
    public final String currentResourceTypeAsString() {
        return currentResourceType;
    }

    /**
     * <p>
     * The resource type of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendedResourceType} will return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #recommendedResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the recommendation.
     * @see ResourceType
     */
    public final ResourceType recommendedResourceType() {
        return ResourceType.fromValue(recommendedResourceType);
    }

    /**
     * <p>
     * The resource type of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendedResourceType} will return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #recommendedResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the recommendation.
     * @see ResourceType
     */
    public final String recommendedResourceTypeAsString() {
        return recommendedResourceType;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the resource.
     * </p>
     * 
     * @return The Amazon Web Services Region of the resource.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The source of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the recommendation.
     * @see Source
     */
    public final Source source() {
        return Source.fromValue(source);
    }

    /**
     * <p>
     * The source of the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the recommendation.
     * @see Source
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * The time when the recommendation was last generated.
     * </p>
     * 
     * @return The time when the recommendation was last generated.
     */
    public final Instant lastRefreshTimestamp() {
        return lastRefreshTimestamp;
    }

    /**
     * <p>
     * The estimated monthly savings amount for the recommendation.
     * </p>
     * 
     * @return The estimated monthly savings amount for the recommendation.
     */
    public final Double estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    /**
     * <p>
     * The estimated monthly cost of the current resource. For Reserved Instances and Savings Plans, it refers to the
     * cost for eligible usage.
     * </p>
     * 
     * @return The estimated monthly cost of the current resource. For Reserved Instances and Savings Plans, it refers
     *         to the cost for eligible usage.
     */
    public final Double estimatedMonthlyCost() {
        return estimatedMonthlyCost;
    }

    /**
     * <p>
     * The effort required to implement the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #implementationEffort} will return {@link ImplementationEffort#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #implementationEffortAsString}.
     * </p>
     * 
     * @return The effort required to implement the recommendation.
     * @see ImplementationEffort
     */
    public final ImplementationEffort implementationEffort() {
        return ImplementationEffort.fromValue(implementationEffort);
    }

    /**
     * <p>
     * The effort required to implement the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #implementationEffort} will return {@link ImplementationEffort#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #implementationEffortAsString}.
     * </p>
     * 
     * @return The effort required to implement the recommendation.
     * @see ImplementationEffort
     */
    public final String implementationEffortAsString() {
        return implementationEffort;
    }

    /**
     * <p>
     * Whether or not implementing the recommendation requires a restart.
     * </p>
     * 
     * @return Whether or not implementing the recommendation requires a restart.
     */
    public final Boolean restartNeeded() {
        return restartNeeded;
    }

    /**
     * <p>
     * The type of action you can take by adopting the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action you can take by adopting the recommendation.
     * @see ActionType
     */
    public final ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of action you can take by adopting the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action you can take by adopting the recommendation.
     * @see ActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * Whether or not implementing the recommendation can be rolled back.
     * </p>
     * 
     * @return Whether or not implementing the recommendation can be rolled back.
     */
    public final Boolean rollbackPossible() {
        return rollbackPossible;
    }

    /**
     * <p>
     * The details for the resource.
     * </p>
     * 
     * @return The details for the resource.
     */
    public final ResourceDetails currentResourceDetails() {
        return currentResourceDetails;
    }

    /**
     * <p>
     * The details about the recommended resource.
     * </p>
     * 
     * @return The details about the recommended resource.
     */
    public final ResourceDetails recommendedResourceDetails() {
        return recommendedResourceDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags associated with the resource for which the recommendation exists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags associated with the resource for which the recommendation exists.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationLookbackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(costCalculationLookbackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsOverCostCalculationLookbackPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(currentResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(implementationEffortAsString());
        hashCode = 31 * hashCode + Objects.hashCode(restartNeeded());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rollbackPossible());
        hashCode = 31 * hashCode + Objects.hashCode(currentResourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedResourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationResponse)) {
            return false;
        }
        GetRecommendationResponse other = (GetRecommendationResponse) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(accountId(), other.accountId())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(recommendationLookbackPeriodInDays(), other.recommendationLookbackPeriodInDays())
                && Objects.equals(costCalculationLookbackPeriodInDays(), other.costCalculationLookbackPeriodInDays())
                && Objects.equals(estimatedSavingsPercentage(), other.estimatedSavingsPercentage())
                && Objects.equals(estimatedSavingsOverCostCalculationLookbackPeriod(),
                        other.estimatedSavingsOverCostCalculationLookbackPeriod())
                && Objects.equals(currentResourceTypeAsString(), other.currentResourceTypeAsString())
                && Objects.equals(recommendedResourceTypeAsString(), other.recommendedResourceTypeAsString())
                && Objects.equals(region(), other.region()) && Objects.equals(sourceAsString(), other.sourceAsString())
                && Objects.equals(lastRefreshTimestamp(), other.lastRefreshTimestamp())
                && Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings())
                && Objects.equals(estimatedMonthlyCost(), other.estimatedMonthlyCost())
                && Objects.equals(implementationEffortAsString(), other.implementationEffortAsString())
                && Objects.equals(restartNeeded(), other.restartNeeded())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(rollbackPossible(), other.rollbackPossible())
                && Objects.equals(currentResourceDetails(), other.currentResourceDetails())
                && Objects.equals(recommendedResourceDetails(), other.recommendedResourceDetails())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecommendationResponse").add("RecommendationId", recommendationId())
                .add("ResourceId", resourceId()).add("ResourceArn", resourceArn()).add("AccountId", accountId())
                .add("CurrencyCode", currencyCode())
                .add("RecommendationLookbackPeriodInDays", recommendationLookbackPeriodInDays())
                .add("CostCalculationLookbackPeriodInDays", costCalculationLookbackPeriodInDays())
                .add("EstimatedSavingsPercentage", estimatedSavingsPercentage())
                .add("EstimatedSavingsOverCostCalculationLookbackPeriod", estimatedSavingsOverCostCalculationLookbackPeriod())
                .add("CurrentResourceType", currentResourceTypeAsString())
                .add("RecommendedResourceType", recommendedResourceTypeAsString()).add("Region", region())
                .add("Source", sourceAsString()).add("LastRefreshTimestamp", lastRefreshTimestamp())
                .add("EstimatedMonthlySavings", estimatedMonthlySavings()).add("EstimatedMonthlyCost", estimatedMonthlyCost())
                .add("ImplementationEffort", implementationEffortAsString()).add("RestartNeeded", restartNeeded())
                .add("ActionType", actionTypeAsString()).add("RollbackPossible", rollbackPossible())
                .add("CurrentResourceDetails", currentResourceDetails())
                .add("RecommendedResourceDetails", recommendedResourceDetails()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "recommendationLookbackPeriodInDays":
            return Optional.ofNullable(clazz.cast(recommendationLookbackPeriodInDays()));
        case "costCalculationLookbackPeriodInDays":
            return Optional.ofNullable(clazz.cast(costCalculationLookbackPeriodInDays()));
        case "estimatedSavingsPercentage":
            return Optional.ofNullable(clazz.cast(estimatedSavingsPercentage()));
        case "estimatedSavingsOverCostCalculationLookbackPeriod":
            return Optional.ofNullable(clazz.cast(estimatedSavingsOverCostCalculationLookbackPeriod()));
        case "currentResourceType":
            return Optional.ofNullable(clazz.cast(currentResourceTypeAsString()));
        case "recommendedResourceType":
            return Optional.ofNullable(clazz.cast(recommendedResourceTypeAsString()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "lastRefreshTimestamp":
            return Optional.ofNullable(clazz.cast(lastRefreshTimestamp()));
        case "estimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        case "estimatedMonthlyCost":
            return Optional.ofNullable(clazz.cast(estimatedMonthlyCost()));
        case "implementationEffort":
            return Optional.ofNullable(clazz.cast(implementationEffortAsString()));
        case "restartNeeded":
            return Optional.ofNullable(clazz.cast(restartNeeded()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "rollbackPossible":
            return Optional.ofNullable(clazz.cast(rollbackPossible()));
        case "currentResourceDetails":
            return Optional.ofNullable(clazz.cast(currentResourceDetails()));
        case "recommendedResourceDetails":
            return Optional.ofNullable(clazz.cast(recommendedResourceDetails()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recommendationId", RECOMMENDATION_ID_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("recommendationLookbackPeriodInDays", RECOMMENDATION_LOOKBACK_PERIOD_IN_DAYS_FIELD);
        map.put("costCalculationLookbackPeriodInDays", COST_CALCULATION_LOOKBACK_PERIOD_IN_DAYS_FIELD);
        map.put("estimatedSavingsPercentage", ESTIMATED_SAVINGS_PERCENTAGE_FIELD);
        map.put("estimatedSavingsOverCostCalculationLookbackPeriod",
                ESTIMATED_SAVINGS_OVER_COST_CALCULATION_LOOKBACK_PERIOD_FIELD);
        map.put("currentResourceType", CURRENT_RESOURCE_TYPE_FIELD);
        map.put("recommendedResourceType", RECOMMENDED_RESOURCE_TYPE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("lastRefreshTimestamp", LAST_REFRESH_TIMESTAMP_FIELD);
        map.put("estimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        map.put("estimatedMonthlyCost", ESTIMATED_MONTHLY_COST_FIELD);
        map.put("implementationEffort", IMPLEMENTATION_EFFORT_FIELD);
        map.put("restartNeeded", RESTART_NEEDED_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("rollbackPossible", ROLLBACK_POSSIBLE_FIELD);
        map.put("currentResourceDetails", CURRENT_RESOURCE_DETAILS_FIELD);
        map.put("recommendedResourceDetails", RECOMMENDED_RESOURCE_DETAILS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationResponse, T> g) {
        return obj -> g.apply((GetRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostOptimizationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationResponse> {
        /**
         * <p>
         * The ID for the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The ID for the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The unique identifier for the resource. This is the same as the Amazon Resource Name (ARN), if available.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier for the resource. This is the same as the Amazon Resource Name (ARN), if
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The account that the recommendation is for.
         * </p>
         * 
         * @param accountId
         *        The account that the recommendation is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The currency code used for the recommendation.
         * </p>
         * 
         * @param currencyCode
         *        The currency code used for the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The lookback period that's used to generate the recommendation.
         * </p>
         * 
         * @param recommendationLookbackPeriodInDays
         *        The lookback period that's used to generate the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationLookbackPeriodInDays(Integer recommendationLookbackPeriodInDays);

        /**
         * <p>
         * The lookback period used to calculate cost impact for a recommendation.
         * </p>
         * 
         * @param costCalculationLookbackPeriodInDays
         *        The lookback period used to calculate cost impact for a recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCalculationLookbackPeriodInDays(Integer costCalculationLookbackPeriodInDays);

        /**
         * <p>
         * The estimated savings percentage relative to the total cost over the cost calculation lookback period.
         * </p>
         * 
         * @param estimatedSavingsPercentage
         *        The estimated savings percentage relative to the total cost over the cost calculation lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsPercentage(Double estimatedSavingsPercentage);

        /**
         * <p>
         * The estimated savings amount over the lookback period used to calculate cost impact for a recommendation.
         * </p>
         * 
         * @param estimatedSavingsOverCostCalculationLookbackPeriod
         *        The estimated savings amount over the lookback period used to calculate cost impact for a
         *        recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsOverCostCalculationLookbackPeriod(Double estimatedSavingsOverCostCalculationLookbackPeriod);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param currentResourceType
         *        The type of resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder currentResourceType(String currentResourceType);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param currentResourceType
         *        The type of resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder currentResourceType(ResourceType currentResourceType);

        /**
         * <p>
         * The resource type of the recommendation.
         * </p>
         * 
         * @param recommendedResourceType
         *        The resource type of the recommendation.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder recommendedResourceType(String recommendedResourceType);

        /**
         * <p>
         * The resource type of the recommendation.
         * </p>
         * 
         * @param recommendedResourceType
         *        The resource type of the recommendation.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder recommendedResourceType(ResourceType recommendedResourceType);

        /**
         * <p>
         * The Amazon Web Services Region of the resource.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The source of the recommendation.
         * </p>
         * 
         * @param source
         *        The source of the recommendation.
         * @see Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Source
         */
        Builder source(String source);

        /**
         * <p>
         * The source of the recommendation.
         * </p>
         * 
         * @param source
         *        The source of the recommendation.
         * @see Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Source
         */
        Builder source(Source source);

        /**
         * <p>
         * The time when the recommendation was last generated.
         * </p>
         * 
         * @param lastRefreshTimestamp
         *        The time when the recommendation was last generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRefreshTimestamp(Instant lastRefreshTimestamp);

        /**
         * <p>
         * The estimated monthly savings amount for the recommendation.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        The estimated monthly savings amount for the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(Double estimatedMonthlySavings);

        /**
         * <p>
         * The estimated monthly cost of the current resource. For Reserved Instances and Savings Plans, it refers to
         * the cost for eligible usage.
         * </p>
         * 
         * @param estimatedMonthlyCost
         *        The estimated monthly cost of the current resource. For Reserved Instances and Savings Plans, it
         *        refers to the cost for eligible usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlyCost(Double estimatedMonthlyCost);

        /**
         * <p>
         * The effort required to implement the recommendation.
         * </p>
         * 
         * @param implementationEffort
         *        The effort required to implement the recommendation.
         * @see ImplementationEffort
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImplementationEffort
         */
        Builder implementationEffort(String implementationEffort);

        /**
         * <p>
         * The effort required to implement the recommendation.
         * </p>
         * 
         * @param implementationEffort
         *        The effort required to implement the recommendation.
         * @see ImplementationEffort
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImplementationEffort
         */
        Builder implementationEffort(ImplementationEffort implementationEffort);

        /**
         * <p>
         * Whether or not implementing the recommendation requires a restart.
         * </p>
         * 
         * @param restartNeeded
         *        Whether or not implementing the recommendation requires a restart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restartNeeded(Boolean restartNeeded);

        /**
         * <p>
         * The type of action you can take by adopting the recommendation.
         * </p>
         * 
         * @param actionType
         *        The type of action you can take by adopting the recommendation.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of action you can take by adopting the recommendation.
         * </p>
         * 
         * @param actionType
         *        The type of action you can take by adopting the recommendation.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * Whether or not implementing the recommendation can be rolled back.
         * </p>
         * 
         * @param rollbackPossible
         *        Whether or not implementing the recommendation can be rolled back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackPossible(Boolean rollbackPossible);

        /**
         * <p>
         * The details for the resource.
         * </p>
         * 
         * @param currentResourceDetails
         *        The details for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentResourceDetails(ResourceDetails currentResourceDetails);

        /**
         * <p>
         * The details for the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDetails.Builder} avoiding the
         * need to create one manually via {@link ResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #currentResourceDetails(ResourceDetails)}.
         * 
         * @param currentResourceDetails
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentResourceDetails(ResourceDetails)
         */
        default Builder currentResourceDetails(Consumer<ResourceDetails.Builder> currentResourceDetails) {
            return currentResourceDetails(ResourceDetails.builder().applyMutation(currentResourceDetails).build());
        }

        /**
         * <p>
         * The details about the recommended resource.
         * </p>
         * 
         * @param recommendedResourceDetails
         *        The details about the recommended resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedResourceDetails(ResourceDetails recommendedResourceDetails);

        /**
         * <p>
         * The details about the recommended resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDetails.Builder} avoiding the
         * need to create one manually via {@link ResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #recommendedResourceDetails(ResourceDetails)}.
         * 
         * @param recommendedResourceDetails
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendedResourceDetails(ResourceDetails)
         */
        default Builder recommendedResourceDetails(Consumer<ResourceDetails.Builder> recommendedResourceDetails) {
            return recommendedResourceDetails(ResourceDetails.builder().applyMutation(recommendedResourceDetails).build());
        }

        /**
         * <p>
         * A list of tags associated with the resource for which the recommendation exists.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the resource for which the recommendation exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with the resource for which the recommendation exists.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the resource for which the recommendation exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags associated with the resource for which the recommendation exists.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.costoptimizationhub.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costoptimizationhub.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends CostOptimizationHubResponse.BuilderImpl implements Builder {
        private String recommendationId;

        private String resourceId;

        private String resourceArn;

        private String accountId;

        private String currencyCode;

        private Integer recommendationLookbackPeriodInDays;

        private Integer costCalculationLookbackPeriodInDays;

        private Double estimatedSavingsPercentage;

        private Double estimatedSavingsOverCostCalculationLookbackPeriod;

        private String currentResourceType;

        private String recommendedResourceType;

        private String region;

        private String source;

        private Instant lastRefreshTimestamp;

        private Double estimatedMonthlySavings;

        private Double estimatedMonthlyCost;

        private String implementationEffort;

        private Boolean restartNeeded;

        private String actionType;

        private Boolean rollbackPossible;

        private ResourceDetails currentResourceDetails;

        private ResourceDetails recommendedResourceDetails;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationResponse model) {
            super(model);
            recommendationId(model.recommendationId);
            resourceId(model.resourceId);
            resourceArn(model.resourceArn);
            accountId(model.accountId);
            currencyCode(model.currencyCode);
            recommendationLookbackPeriodInDays(model.recommendationLookbackPeriodInDays);
            costCalculationLookbackPeriodInDays(model.costCalculationLookbackPeriodInDays);
            estimatedSavingsPercentage(model.estimatedSavingsPercentage);
            estimatedSavingsOverCostCalculationLookbackPeriod(model.estimatedSavingsOverCostCalculationLookbackPeriod);
            currentResourceType(model.currentResourceType);
            recommendedResourceType(model.recommendedResourceType);
            region(model.region);
            source(model.source);
            lastRefreshTimestamp(model.lastRefreshTimestamp);
            estimatedMonthlySavings(model.estimatedMonthlySavings);
            estimatedMonthlyCost(model.estimatedMonthlyCost);
            implementationEffort(model.implementationEffort);
            restartNeeded(model.restartNeeded);
            actionType(model.actionType);
            rollbackPossible(model.rollbackPossible);
            currentResourceDetails(model.currentResourceDetails);
            recommendedResourceDetails(model.recommendedResourceDetails);
            tags(model.tags);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getRecommendationLookbackPeriodInDays() {
            return recommendationLookbackPeriodInDays;
        }

        public final void setRecommendationLookbackPeriodInDays(Integer recommendationLookbackPeriodInDays) {
            this.recommendationLookbackPeriodInDays = recommendationLookbackPeriodInDays;
        }

        @Override
        public final Builder recommendationLookbackPeriodInDays(Integer recommendationLookbackPeriodInDays) {
            this.recommendationLookbackPeriodInDays = recommendationLookbackPeriodInDays;
            return this;
        }

        public final Integer getCostCalculationLookbackPeriodInDays() {
            return costCalculationLookbackPeriodInDays;
        }

        public final void setCostCalculationLookbackPeriodInDays(Integer costCalculationLookbackPeriodInDays) {
            this.costCalculationLookbackPeriodInDays = costCalculationLookbackPeriodInDays;
        }

        @Override
        public final Builder costCalculationLookbackPeriodInDays(Integer costCalculationLookbackPeriodInDays) {
            this.costCalculationLookbackPeriodInDays = costCalculationLookbackPeriodInDays;
            return this;
        }

        public final Double getEstimatedSavingsPercentage() {
            return estimatedSavingsPercentage;
        }

        public final void setEstimatedSavingsPercentage(Double estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
        }

        @Override
        public final Builder estimatedSavingsPercentage(Double estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
            return this;
        }

        public final Double getEstimatedSavingsOverCostCalculationLookbackPeriod() {
            return estimatedSavingsOverCostCalculationLookbackPeriod;
        }

        public final void setEstimatedSavingsOverCostCalculationLookbackPeriod(
                Double estimatedSavingsOverCostCalculationLookbackPeriod) {
            this.estimatedSavingsOverCostCalculationLookbackPeriod = estimatedSavingsOverCostCalculationLookbackPeriod;
        }

        @Override
        public final Builder estimatedSavingsOverCostCalculationLookbackPeriod(
                Double estimatedSavingsOverCostCalculationLookbackPeriod) {
            this.estimatedSavingsOverCostCalculationLookbackPeriod = estimatedSavingsOverCostCalculationLookbackPeriod;
            return this;
        }

        public final String getCurrentResourceType() {
            return currentResourceType;
        }

        public final void setCurrentResourceType(String currentResourceType) {
            this.currentResourceType = currentResourceType;
        }

        @Override
        public final Builder currentResourceType(String currentResourceType) {
            this.currentResourceType = currentResourceType;
            return this;
        }

        @Override
        public final Builder currentResourceType(ResourceType currentResourceType) {
            this.currentResourceType(currentResourceType == null ? null : currentResourceType.toString());
            return this;
        }

        public final String getRecommendedResourceType() {
            return recommendedResourceType;
        }

        public final void setRecommendedResourceType(String recommendedResourceType) {
            this.recommendedResourceType = recommendedResourceType;
        }

        @Override
        public final Builder recommendedResourceType(String recommendedResourceType) {
            this.recommendedResourceType = recommendedResourceType;
            return this;
        }

        @Override
        public final Builder recommendedResourceType(ResourceType recommendedResourceType) {
            this.recommendedResourceType(recommendedResourceType == null ? null : recommendedResourceType.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(Source source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final Double getEstimatedMonthlySavings() {
            return estimatedMonthlySavings;
        }

        public final void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final Double getEstimatedMonthlyCost() {
            return estimatedMonthlyCost;
        }

        public final void setEstimatedMonthlyCost(Double estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
        }

        @Override
        public final Builder estimatedMonthlyCost(Double estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
            return this;
        }

        public final String getImplementationEffort() {
            return implementationEffort;
        }

        public final void setImplementationEffort(String implementationEffort) {
            this.implementationEffort = implementationEffort;
        }

        @Override
        public final Builder implementationEffort(String implementationEffort) {
            this.implementationEffort = implementationEffort;
            return this;
        }

        @Override
        public final Builder implementationEffort(ImplementationEffort implementationEffort) {
            this.implementationEffort(implementationEffort == null ? null : implementationEffort.toString());
            return this;
        }

        public final Boolean getRestartNeeded() {
            return restartNeeded;
        }

        public final void setRestartNeeded(Boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
        }

        @Override
        public final Builder restartNeeded(Boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final Boolean getRollbackPossible() {
            return rollbackPossible;
        }

        public final void setRollbackPossible(Boolean rollbackPossible) {
            this.rollbackPossible = rollbackPossible;
        }

        @Override
        public final Builder rollbackPossible(Boolean rollbackPossible) {
            this.rollbackPossible = rollbackPossible;
            return this;
        }

        public final ResourceDetails.Builder getCurrentResourceDetails() {
            return currentResourceDetails != null ? currentResourceDetails.toBuilder() : null;
        }

        public final void setCurrentResourceDetails(ResourceDetails.BuilderImpl currentResourceDetails) {
            this.currentResourceDetails = currentResourceDetails != null ? currentResourceDetails.build() : null;
        }

        @Override
        public final Builder currentResourceDetails(ResourceDetails currentResourceDetails) {
            this.currentResourceDetails = currentResourceDetails;
            return this;
        }

        public final ResourceDetails.Builder getRecommendedResourceDetails() {
            return recommendedResourceDetails != null ? recommendedResourceDetails.toBuilder() : null;
        }

        public final void setRecommendedResourceDetails(ResourceDetails.BuilderImpl recommendedResourceDetails) {
            this.recommendedResourceDetails = recommendedResourceDetails != null ? recommendedResourceDetails.build() : null;
        }

        @Override
        public final Builder recommendedResourceDetails(ResourceDetails recommendedResourceDetails) {
            this.recommendedResourceDetails = recommendedResourceDetails;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRecommendationResponse build() {
            return new GetRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
