/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Pricing details for your recommended reserved instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstancesPricing implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstancesPricing.Builder, ReservedInstancesPricing> {
    private static final SdkField<Double> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedOnDemandCost").getter(getter(ReservedInstancesPricing::estimatedOnDemandCost))
            .setter(setter(Builder::estimatedOnDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedOnDemandCost").build())
            .build();

    private static final SdkField<Double> MONTHLY_RESERVATION_ELIGIBLE_COST_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("monthlyReservationEligibleCost")
            .getter(getter(ReservedInstancesPricing::monthlyReservationEligibleCost))
            .setter(setter(Builder::monthlyReservationEligibleCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyReservationEligibleCost")
                    .build()).build();

    private static final SdkField<Double> SAVINGS_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("savingsPercentage").getter(getter(ReservedInstancesPricing::savingsPercentage))
            .setter(setter(Builder::savingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPercentage").build()).build();

    private static final SdkField<Double> ESTIMATED_MONTHLY_AMORTIZED_RESERVATION_COST_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedMonthlyAmortizedReservationCost")
            .getter(getter(ReservedInstancesPricing::estimatedMonthlyAmortizedReservationCost))
            .setter(setter(Builder::estimatedMonthlyAmortizedReservationCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("estimatedMonthlyAmortizedReservationCost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_ON_DEMAND_COST_FIELD, MONTHLY_RESERVATION_ELIGIBLE_COST_FIELD, SAVINGS_PERCENTAGE_FIELD,
            ESTIMATED_MONTHLY_AMORTIZED_RESERVATION_COST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double estimatedOnDemandCost;

    private final Double monthlyReservationEligibleCost;

    private final Double savingsPercentage;

    private final Double estimatedMonthlyAmortizedReservationCost;

    private ReservedInstancesPricing(BuilderImpl builder) {
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.monthlyReservationEligibleCost = builder.monthlyReservationEligibleCost;
        this.savingsPercentage = builder.savingsPercentage;
        this.estimatedMonthlyAmortizedReservationCost = builder.estimatedMonthlyAmortizedReservationCost;
    }

    /**
     * <p>
     * The remaining On-Demand cost estimated to not be covered by the recommended reserved instance, over the length of
     * the lookback period.
     * </p>
     * 
     * @return The remaining On-Demand cost estimated to not be covered by the recommended reserved instance, over the
     *         length of the lookback period.
     */
    public final Double estimatedOnDemandCost() {
        return estimatedOnDemandCost;
    }

    /**
     * <p>
     * The cost of paying for the recommended reserved instance monthly.
     * </p>
     * 
     * @return The cost of paying for the recommended reserved instance monthly.
     */
    public final Double monthlyReservationEligibleCost() {
        return monthlyReservationEligibleCost;
    }

    /**
     * <p>
     * The savings percentage relative to the total On-Demand costs that are associated with this instance.
     * </p>
     * 
     * @return The savings percentage relative to the total On-Demand costs that are associated with this instance.
     */
    public final Double savingsPercentage() {
        return savingsPercentage;
    }

    /**
     * <p>
     * The estimated cost of your recurring monthly fees for the recommended reserved instance across the month.
     * </p>
     * 
     * @return The estimated cost of your recurring monthly fees for the recommended reserved instance across the month.
     */
    public final Double estimatedMonthlyAmortizedReservationCost() {
        return estimatedMonthlyAmortizedReservationCost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyReservationEligibleCost());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlyAmortizedReservationCost());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesPricing)) {
            return false;
        }
        ReservedInstancesPricing other = (ReservedInstancesPricing) obj;
        return Objects.equals(estimatedOnDemandCost(), other.estimatedOnDemandCost())
                && Objects.equals(monthlyReservationEligibleCost(), other.monthlyReservationEligibleCost())
                && Objects.equals(savingsPercentage(), other.savingsPercentage())
                && Objects.equals(estimatedMonthlyAmortizedReservationCost(), other.estimatedMonthlyAmortizedReservationCost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedInstancesPricing").add("EstimatedOnDemandCost", estimatedOnDemandCost())
                .add("MonthlyReservationEligibleCost", monthlyReservationEligibleCost())
                .add("SavingsPercentage", savingsPercentage())
                .add("EstimatedMonthlyAmortizedReservationCost", estimatedMonthlyAmortizedReservationCost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedOnDemandCost":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCost()));
        case "monthlyReservationEligibleCost":
            return Optional.ofNullable(clazz.cast(monthlyReservationEligibleCost()));
        case "savingsPercentage":
            return Optional.ofNullable(clazz.cast(savingsPercentage()));
        case "estimatedMonthlyAmortizedReservationCost":
            return Optional.ofNullable(clazz.cast(estimatedMonthlyAmortizedReservationCost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("estimatedOnDemandCost", ESTIMATED_ON_DEMAND_COST_FIELD);
        map.put("monthlyReservationEligibleCost", MONTHLY_RESERVATION_ELIGIBLE_COST_FIELD);
        map.put("savingsPercentage", SAVINGS_PERCENTAGE_FIELD);
        map.put("estimatedMonthlyAmortizedReservationCost", ESTIMATED_MONTHLY_AMORTIZED_RESERVATION_COST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesPricing, T> g) {
        return obj -> g.apply((ReservedInstancesPricing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstancesPricing> {
        /**
         * <p>
         * The remaining On-Demand cost estimated to not be covered by the recommended reserved instance, over the
         * length of the lookback period.
         * </p>
         * 
         * @param estimatedOnDemandCost
         *        The remaining On-Demand cost estimated to not be covered by the recommended reserved instance, over
         *        the length of the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCost(Double estimatedOnDemandCost);

        /**
         * <p>
         * The cost of paying for the recommended reserved instance monthly.
         * </p>
         * 
         * @param monthlyReservationEligibleCost
         *        The cost of paying for the recommended reserved instance monthly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyReservationEligibleCost(Double monthlyReservationEligibleCost);

        /**
         * <p>
         * The savings percentage relative to the total On-Demand costs that are associated with this instance.
         * </p>
         * 
         * @param savingsPercentage
         *        The savings percentage relative to the total On-Demand costs that are associated with this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPercentage(Double savingsPercentage);

        /**
         * <p>
         * The estimated cost of your recurring monthly fees for the recommended reserved instance across the month.
         * </p>
         * 
         * @param estimatedMonthlyAmortizedReservationCost
         *        The estimated cost of your recurring monthly fees for the recommended reserved instance across the
         *        month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlyAmortizedReservationCost(Double estimatedMonthlyAmortizedReservationCost);
    }

    static final class BuilderImpl implements Builder {
        private Double estimatedOnDemandCost;

        private Double monthlyReservationEligibleCost;

        private Double savingsPercentage;

        private Double estimatedMonthlyAmortizedReservationCost;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesPricing model) {
            estimatedOnDemandCost(model.estimatedOnDemandCost);
            monthlyReservationEligibleCost(model.monthlyReservationEligibleCost);
            savingsPercentage(model.savingsPercentage);
            estimatedMonthlyAmortizedReservationCost(model.estimatedMonthlyAmortizedReservationCost);
        }

        public final Double getEstimatedOnDemandCost() {
            return estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final Double getMonthlyReservationEligibleCost() {
            return monthlyReservationEligibleCost;
        }

        public final void setMonthlyReservationEligibleCost(Double monthlyReservationEligibleCost) {
            this.monthlyReservationEligibleCost = monthlyReservationEligibleCost;
        }

        @Override
        public final Builder monthlyReservationEligibleCost(Double monthlyReservationEligibleCost) {
            this.monthlyReservationEligibleCost = monthlyReservationEligibleCost;
            return this;
        }

        public final Double getSavingsPercentage() {
            return savingsPercentage;
        }

        public final void setSavingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
        }

        @Override
        public final Builder savingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
            return this;
        }

        public final Double getEstimatedMonthlyAmortizedReservationCost() {
            return estimatedMonthlyAmortizedReservationCost;
        }

        public final void setEstimatedMonthlyAmortizedReservationCost(Double estimatedMonthlyAmortizedReservationCost) {
            this.estimatedMonthlyAmortizedReservationCost = estimatedMonthlyAmortizedReservationCost;
        }

        @Override
        public final Builder estimatedMonthlyAmortizedReservationCost(Double estimatedMonthlyAmortizedReservationCost) {
            this.estimatedMonthlyAmortizedReservationCost = estimatedMonthlyAmortizedReservationCost;
            return this;
        }

        @Override
        public ReservedInstancesPricing build() {
            return new ReservedInstancesPricing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
