/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.CostOptimizationHubResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.MemberAccountDiscountVisibility;
import software.amazon.awssdk.services.costoptimizationhub.model.PreferredCommitment;
import software.amazon.awssdk.services.costoptimizationhub.model.SavingsEstimationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPreferencesResponse
extends CostOptimizationHubResponse
implements ToCopyableBuilder<Builder, GetPreferencesResponse> {
    private static final SdkField<String> SAVINGS_ESTIMATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("savingsEstimationMode").getter(GetPreferencesResponse.getter(GetPreferencesResponse::savingsEstimationModeAsString)).setter(GetPreferencesResponse.setter(Builder::savingsEstimationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsEstimationMode").build()}).build();
    private static final SdkField<String> MEMBER_ACCOUNT_DISCOUNT_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberAccountDiscountVisibility").getter(GetPreferencesResponse.getter(GetPreferencesResponse::memberAccountDiscountVisibilityAsString)).setter(GetPreferencesResponse.setter(Builder::memberAccountDiscountVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountDiscountVisibility").build()}).build();
    private static final SdkField<PreferredCommitment> PREFERRED_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preferredCommitment").getter(GetPreferencesResponse.getter(GetPreferencesResponse::preferredCommitment)).setter(GetPreferencesResponse.setter(Builder::preferredCommitment)).constructor(PreferredCommitment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredCommitment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_ESTIMATION_MODE_FIELD, MEMBER_ACCOUNT_DISCOUNT_VISIBILITY_FIELD, PREFERRED_COMMITMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPreferencesResponse.memberNameToFieldInitializer();
    private final String savingsEstimationMode;
    private final String memberAccountDiscountVisibility;
    private final PreferredCommitment preferredCommitment;

    private GetPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.savingsEstimationMode = builder.savingsEstimationMode;
        this.memberAccountDiscountVisibility = builder.memberAccountDiscountVisibility;
        this.preferredCommitment = builder.preferredCommitment;
    }

    public final SavingsEstimationMode savingsEstimationMode() {
        return SavingsEstimationMode.fromValue(this.savingsEstimationMode);
    }

    public final String savingsEstimationModeAsString() {
        return this.savingsEstimationMode;
    }

    public final MemberAccountDiscountVisibility memberAccountDiscountVisibility() {
        return MemberAccountDiscountVisibility.fromValue(this.memberAccountDiscountVisibility);
    }

    public final String memberAccountDiscountVisibilityAsString() {
        return this.memberAccountDiscountVisibility;
    }

    public final PreferredCommitment preferredCommitment() {
        return this.preferredCommitment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsEstimationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountDiscountVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredCommitment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPreferencesResponse)) {
            return false;
        }
        GetPreferencesResponse other = (GetPreferencesResponse)((Object)obj);
        return Objects.equals(this.savingsEstimationModeAsString(), other.savingsEstimationModeAsString()) && Objects.equals(this.memberAccountDiscountVisibilityAsString(), other.memberAccountDiscountVisibilityAsString()) && Objects.equals(this.preferredCommitment(), other.preferredCommitment());
    }

    public final String toString() {
        return ToString.builder((String)"GetPreferencesResponse").add("SavingsEstimationMode", (Object)this.savingsEstimationModeAsString()).add("MemberAccountDiscountVisibility", (Object)this.memberAccountDiscountVisibilityAsString()).add("PreferredCommitment", (Object)this.preferredCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "savingsEstimationMode": {
                return Optional.ofNullable(clazz.cast(this.savingsEstimationModeAsString()));
            }
            case "memberAccountDiscountVisibility": {
                return Optional.ofNullable(clazz.cast(this.memberAccountDiscountVisibilityAsString()));
            }
            case "preferredCommitment": {
                return Optional.ofNullable(clazz.cast(this.preferredCommitment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("savingsEstimationMode", SAVINGS_ESTIMATION_MODE_FIELD);
        map.put("memberAccountDiscountVisibility", MEMBER_ACCOUNT_DISCOUNT_VISIBILITY_FIELD);
        map.put("preferredCommitment", PREFERRED_COMMITMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPreferencesResponse, T> g) {
        return obj -> g.apply((GetPreferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostOptimizationHubResponse.BuilderImpl
    implements Builder {
        private String savingsEstimationMode;
        private String memberAccountDiscountVisibility;
        private PreferredCommitment preferredCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPreferencesResponse model) {
            super(model);
            this.savingsEstimationMode(model.savingsEstimationMode);
            this.memberAccountDiscountVisibility(model.memberAccountDiscountVisibility);
            this.preferredCommitment(model.preferredCommitment);
        }

        public final String getSavingsEstimationMode() {
            return this.savingsEstimationMode;
        }

        public final void setSavingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
        }

        @Override
        public final Builder savingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
            return this;
        }

        @Override
        public final Builder savingsEstimationMode(SavingsEstimationMode savingsEstimationMode) {
            this.savingsEstimationMode(savingsEstimationMode == null ? null : savingsEstimationMode.toString());
            return this;
        }

        public final String getMemberAccountDiscountVisibility() {
            return this.memberAccountDiscountVisibility;
        }

        public final void setMemberAccountDiscountVisibility(String memberAccountDiscountVisibility) {
            this.memberAccountDiscountVisibility = memberAccountDiscountVisibility;
        }

        @Override
        public final Builder memberAccountDiscountVisibility(String memberAccountDiscountVisibility) {
            this.memberAccountDiscountVisibility = memberAccountDiscountVisibility;
            return this;
        }

        @Override
        public final Builder memberAccountDiscountVisibility(MemberAccountDiscountVisibility memberAccountDiscountVisibility) {
            this.memberAccountDiscountVisibility(memberAccountDiscountVisibility == null ? null : memberAccountDiscountVisibility.toString());
            return this;
        }

        public final PreferredCommitment.Builder getPreferredCommitment() {
            return this.preferredCommitment != null ? this.preferredCommitment.toBuilder() : null;
        }

        public final void setPreferredCommitment(PreferredCommitment.BuilderImpl preferredCommitment) {
            this.preferredCommitment = preferredCommitment != null ? preferredCommitment.build() : null;
        }

        @Override
        public final Builder preferredCommitment(PreferredCommitment preferredCommitment) {
            this.preferredCommitment = preferredCommitment;
            return this;
        }

        @Override
        public GetPreferencesResponse build() {
            return new GetPreferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostOptimizationHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPreferencesResponse> {
        public Builder savingsEstimationMode(String var1);

        public Builder savingsEstimationMode(SavingsEstimationMode var1);

        public Builder memberAccountDiscountVisibility(String var1);

        public Builder memberAccountDiscountVisibility(MemberAccountDiscountVisibility var1);

        public Builder preferredCommitment(PreferredCommitment var1);

        default public Builder preferredCommitment(Consumer<PreferredCommitment.Builder> preferredCommitment) {
            return this.preferredCommitment((PreferredCommitment)((PreferredCommitment.Builder)PreferredCommitment.builder().applyMutation(preferredCommitment)).build());
        }
    }
}

