/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon Elastic Block Store performance configuration of the current and recommended resource
 * configuration for a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockStoragePerformanceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockStoragePerformanceConfiguration.Builder, BlockStoragePerformanceConfiguration> {
    private static final SdkField<Double> IOPS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("iops")
            .getter(getter(BlockStoragePerformanceConfiguration::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()).build();

    private static final SdkField<Double> THROUGHPUT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("throughput").getter(getter(BlockStoragePerformanceConfiguration::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double iops;

    private final Double throughput;

    private BlockStoragePerformanceConfiguration(BuilderImpl builder) {
        this.iops = builder.iops;
        this.throughput = builder.throughput;
    }

    /**
     * <p>
     * The number of I/O operations per second.
     * </p>
     * 
     * @return The number of I/O operations per second.
     */
    public final Double iops() {
        return iops;
    }

    /**
     * <p>
     * The throughput that the volume supports.
     * </p>
     * 
     * @return The throughput that the volume supports.
     */
    public final Double throughput() {
        return throughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockStoragePerformanceConfiguration)) {
            return false;
        }
        BlockStoragePerformanceConfiguration other = (BlockStoragePerformanceConfiguration) obj;
        return Objects.equals(iops(), other.iops()) && Objects.equals(throughput(), other.throughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockStoragePerformanceConfiguration").add("Iops", iops()).add("Throughput", throughput())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("iops", IOPS_FIELD);
        map.put("throughput", THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockStoragePerformanceConfiguration, T> g) {
        return obj -> g.apply((BlockStoragePerformanceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockStoragePerformanceConfiguration> {
        /**
         * <p>
         * The number of I/O operations per second.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Double iops);

        /**
         * <p>
         * The throughput that the volume supports.
         * </p>
         * 
         * @param throughput
         *        The throughput that the volume supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Double throughput);
    }

    static final class BuilderImpl implements Builder {
        private Double iops;

        private Double throughput;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockStoragePerformanceConfiguration model) {
            iops(model.iops);
            throughput(model.throughput);
        }

        public final Double getIops() {
            return iops;
        }

        public final void setIops(Double iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Double iops) {
            this.iops = iops;
            return this;
        }

        public final Double getThroughput() {
            return throughput;
        }

        public final void setThroughput(Double throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Double throughput) {
            this.throughput = throughput;
            return this;
        }

        @Override
        public BlockStoragePerformanceConfiguration build() {
            return new BlockStoragePerformanceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
