/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the performance configuration for compute services such as Amazon EC2, Lambda, and ECS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeConfiguration.Builder, ComputeConfiguration> {
    private static final SdkField<Double> V_CPU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("vCpu")
            .getter(getter(ComputeConfiguration::vCpu)).setter(setter(Builder::vCpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCpu").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySizeInMB").getter(getter(ComputeConfiguration::memorySizeInMB))
            .setter(setter(Builder::memorySizeInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInMB").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(ComputeConfiguration::architecture)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(ComputeConfiguration::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V_CPU_FIELD,
            MEMORY_SIZE_IN_MB_FIELD, ARCHITECTURE_FIELD, PLATFORM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double vCpu;

    private final Integer memorySizeInMB;

    private final String architecture;

    private final String platform;

    private ComputeConfiguration(BuilderImpl builder) {
        this.vCpu = builder.vCpu;
        this.memorySizeInMB = builder.memorySizeInMB;
        this.architecture = builder.architecture;
        this.platform = builder.platform;
    }

    /**
     * <p>
     * The number of vCPU cores in the resource.
     * </p>
     * 
     * @return The number of vCPU cores in the resource.
     */
    public final Double vCpu() {
        return vCpu;
    }

    /**
     * <p>
     * The memory size of the resource.
     * </p>
     * 
     * @return The memory size of the resource.
     */
    public final Integer memorySizeInMB() {
        return memorySizeInMB;
    }

    /**
     * <p>
     * The architecture of the resource.
     * </p>
     * 
     * @return The architecture of the resource.
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The platform of the resource. The platform is the specific combination of operating system, license model, and
     * software on an instance.
     * </p>
     * 
     * @return The platform of the resource. The platform is the specific combination of operating system, license
     *         model, and software on an instance.
     */
    public final String platform() {
        return platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vCpu());
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInMB());
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeConfiguration)) {
            return false;
        }
        ComputeConfiguration other = (ComputeConfiguration) obj;
        return Objects.equals(vCpu(), other.vCpu()) && Objects.equals(memorySizeInMB(), other.memorySizeInMB())
                && Objects.equals(architecture(), other.architecture()) && Objects.equals(platform(), other.platform());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeConfiguration").add("VCpu", vCpu()).add("MemorySizeInMB", memorySizeInMB())
                .add("Architecture", architecture()).add("Platform", platform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vCpu":
            return Optional.ofNullable(clazz.cast(vCpu()));
        case "memorySizeInMB":
            return Optional.ofNullable(clazz.cast(memorySizeInMB()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vCpu", V_CPU_FIELD);
        map.put("memorySizeInMB", MEMORY_SIZE_IN_MB_FIELD);
        map.put("architecture", ARCHITECTURE_FIELD);
        map.put("platform", PLATFORM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeConfiguration, T> g) {
        return obj -> g.apply((ComputeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeConfiguration> {
        /**
         * <p>
         * The number of vCPU cores in the resource.
         * </p>
         * 
         * @param vCpu
         *        The number of vCPU cores in the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vCpu(Double vCpu);

        /**
         * <p>
         * The memory size of the resource.
         * </p>
         * 
         * @param memorySizeInMB
         *        The memory size of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInMB(Integer memorySizeInMB);

        /**
         * <p>
         * The architecture of the resource.
         * </p>
         * 
         * @param architecture
         *        The architecture of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The platform of the resource. The platform is the specific combination of operating system, license model,
         * and software on an instance.
         * </p>
         * 
         * @param platform
         *        The platform of the resource. The platform is the specific combination of operating system, license
         *        model, and software on an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);
    }

    static final class BuilderImpl implements Builder {
        private Double vCpu;

        private Integer memorySizeInMB;

        private String architecture;

        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeConfiguration model) {
            vCpu(model.vCpu);
            memorySizeInMB(model.memorySizeInMB);
            architecture(model.architecture);
            platform(model.platform);
        }

        public final Double getVCpu() {
            return vCpu;
        }

        public final void setVCpu(Double vCpu) {
            this.vCpu = vCpu;
        }

        @Override
        public final Builder vCpu(Double vCpu) {
            this.vCpu = vCpu;
            return this;
        }

        public final Integer getMemorySizeInMB() {
            return memorySizeInMB;
        }

        public final void setMemorySizeInMB(Integer memorySizeInMB) {
            this.memorySizeInMB = memorySizeInMB;
        }

        @Override
        public final Builder memorySizeInMB(Integer memorySizeInMB) {
            this.memorySizeInMB = memorySizeInMB;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public ComputeConfiguration build() {
            return new ComputeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
