/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Elastic Block Store volume configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsVolumeConfiguration.Builder, EbsVolumeConfiguration> {
    private static final SdkField<StorageConfiguration> STORAGE_FIELD = SdkField
            .<StorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("storage")
            .getter(getter(EbsVolumeConfiguration::storage)).setter(setter(Builder::storage))
            .constructor(StorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()).build();

    private static final SdkField<BlockStoragePerformanceConfiguration> PERFORMANCE_FIELD = SdkField
            .<BlockStoragePerformanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("performance")
            .getter(getter(EbsVolumeConfiguration::performance)).setter(setter(Builder::performance))
            .constructor(BlockStoragePerformanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performance").build()).build();

    private static final SdkField<String> ATTACHMENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentState").getter(getter(EbsVolumeConfiguration::attachmentState))
            .setter(setter(Builder::attachmentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_FIELD,
            PERFORMANCE_FIELD, ATTACHMENT_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StorageConfiguration storage;

    private final BlockStoragePerformanceConfiguration performance;

    private final String attachmentState;

    private EbsVolumeConfiguration(BuilderImpl builder) {
        this.storage = builder.storage;
        this.performance = builder.performance;
        this.attachmentState = builder.attachmentState;
    }

    /**
     * <p>
     * The disk storage of the Amazon Elastic Block Store volume.
     * </p>
     * 
     * @return The disk storage of the Amazon Elastic Block Store volume.
     */
    public final StorageConfiguration storage() {
        return storage;
    }

    /**
     * <p>
     * The Amazon Elastic Block Store performance configuration.
     * </p>
     * 
     * @return The Amazon Elastic Block Store performance configuration.
     */
    public final BlockStoragePerformanceConfiguration performance() {
        return performance;
    }

    /**
     * <p>
     * The Amazon Elastic Block Store attachment state.
     * </p>
     * 
     * @return The Amazon Elastic Block Store attachment state.
     */
    public final String attachmentState() {
        return attachmentState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        hashCode = 31 * hashCode + Objects.hashCode(performance());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolumeConfiguration)) {
            return false;
        }
        EbsVolumeConfiguration other = (EbsVolumeConfiguration) obj;
        return Objects.equals(storage(), other.storage()) && Objects.equals(performance(), other.performance())
                && Objects.equals(attachmentState(), other.attachmentState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsVolumeConfiguration").add("Storage", storage()).add("Performance", performance())
                .add("AttachmentState", attachmentState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storage":
            return Optional.ofNullable(clazz.cast(storage()));
        case "performance":
            return Optional.ofNullable(clazz.cast(performance()));
        case "attachmentState":
            return Optional.ofNullable(clazz.cast(attachmentState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storage", STORAGE_FIELD);
        map.put("performance", PERFORMANCE_FIELD);
        map.put("attachmentState", ATTACHMENT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EbsVolumeConfiguration, T> g) {
        return obj -> g.apply((EbsVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsVolumeConfiguration> {
        /**
         * <p>
         * The disk storage of the Amazon Elastic Block Store volume.
         * </p>
         * 
         * @param storage
         *        The disk storage of the Amazon Elastic Block Store volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(StorageConfiguration storage);

        /**
         * <p>
         * The disk storage of the Amazon Elastic Block Store volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link StorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #storage(StorageConfiguration)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link StorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(StorageConfiguration)
         */
        default Builder storage(Consumer<StorageConfiguration.Builder> storage) {
            return storage(StorageConfiguration.builder().applyMutation(storage).build());
        }

        /**
         * <p>
         * The Amazon Elastic Block Store performance configuration.
         * </p>
         * 
         * @param performance
         *        The Amazon Elastic Block Store performance configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performance(BlockStoragePerformanceConfiguration performance);

        /**
         * <p>
         * The Amazon Elastic Block Store performance configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BlockStoragePerformanceConfiguration.Builder} avoiding the need to create one manually via
         * {@link BlockStoragePerformanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockStoragePerformanceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #performance(BlockStoragePerformanceConfiguration)}.
         * 
         * @param performance
         *        a consumer that will call methods on {@link BlockStoragePerformanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performance(BlockStoragePerformanceConfiguration)
         */
        default Builder performance(Consumer<BlockStoragePerformanceConfiguration.Builder> performance) {
            return performance(BlockStoragePerformanceConfiguration.builder().applyMutation(performance).build());
        }

        /**
         * <p>
         * The Amazon Elastic Block Store attachment state.
         * </p>
         * 
         * @param attachmentState
         *        The Amazon Elastic Block Store attachment state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentState(String attachmentState);
    }

    static final class BuilderImpl implements Builder {
        private StorageConfiguration storage;

        private BlockStoragePerformanceConfiguration performance;

        private String attachmentState;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolumeConfiguration model) {
            storage(model.storage);
            performance(model.performance);
            attachmentState(model.attachmentState);
        }

        public final StorageConfiguration.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        public final void setStorage(StorageConfiguration.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(StorageConfiguration storage) {
            this.storage = storage;
            return this;
        }

        public final BlockStoragePerformanceConfiguration.Builder getPerformance() {
            return performance != null ? performance.toBuilder() : null;
        }

        public final void setPerformance(BlockStoragePerformanceConfiguration.BuilderImpl performance) {
            this.performance = performance != null ? performance.build() : null;
        }

        @Override
        public final Builder performance(BlockStoragePerformanceConfiguration performance) {
            this.performance = performance;
            return this;
        }

        public final String getAttachmentState() {
            return attachmentState;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        @Override
        public EbsVolumeConfiguration build() {
            return new EbsVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
