/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnrollmentStatusesResponse extends CostOptimizationHubResponse implements
        ToCopyableBuilder<ListEnrollmentStatusesResponse.Builder, ListEnrollmentStatusesResponse> {
    private static final SdkField<List<AccountEnrollmentStatus>> ITEMS_FIELD = SdkField
            .<List<AccountEnrollmentStatus>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(ListEnrollmentStatusesResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountEnrollmentStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountEnrollmentStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_MEMBER_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeMemberAccounts").getter(getter(ListEnrollmentStatusesResponse::includeMemberAccounts))
            .setter(setter(Builder::includeMemberAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeMemberAccounts").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnrollmentStatusesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD,
            INCLUDE_MEMBER_ACCOUNTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AccountEnrollmentStatus> items;

    private final Boolean includeMemberAccounts;

    private final String nextToken;

    private ListEnrollmentStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.includeMemberAccounts = builder.includeMemberAccounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The enrollment status of a specific account ID, including creation and last updated timestamps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The enrollment status of a specific account ID, including creation and last updated timestamps.
     */
    public final List<AccountEnrollmentStatus> items() {
        return items;
    }

    /**
     * <p>
     * The enrollment status of all member accounts in the organization if the account is the management account or
     * delegated administrator.
     * </p>
     * 
     * @return The enrollment status of all member accounts in the organization if the account is the management account
     *         or delegated administrator.
     */
    public final Boolean includeMemberAccounts() {
        return includeMemberAccounts;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeMemberAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnrollmentStatusesResponse)) {
            return false;
        }
        ListEnrollmentStatusesResponse other = (ListEnrollmentStatusesResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(includeMemberAccounts(), other.includeMemberAccounts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnrollmentStatusesResponse").add("Items", hasItems() ? items() : null)
                .add("IncludeMemberAccounts", includeMemberAccounts()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "includeMemberAccounts":
            return Optional.ofNullable(clazz.cast(includeMemberAccounts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("items", ITEMS_FIELD);
        map.put("includeMemberAccounts", INCLUDE_MEMBER_ACCOUNTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnrollmentStatusesResponse, T> g) {
        return obj -> g.apply((ListEnrollmentStatusesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostOptimizationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnrollmentStatusesResponse> {
        /**
         * <p>
         * The enrollment status of a specific account ID, including creation and last updated timestamps.
         * </p>
         * 
         * @param items
         *        The enrollment status of a specific account ID, including creation and last updated timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<AccountEnrollmentStatus> items);

        /**
         * <p>
         * The enrollment status of a specific account ID, including creation and last updated timestamps.
         * </p>
         * 
         * @param items
         *        The enrollment status of a specific account ID, including creation and last updated timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(AccountEnrollmentStatus... items);

        /**
         * <p>
         * The enrollment status of a specific account ID, including creation and last updated timestamps.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.AccountEnrollmentStatus.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.AccountEnrollmentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.AccountEnrollmentStatus.Builder#build()} is
         * called immediately and its result is passed to {@link #items(List<AccountEnrollmentStatus>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costoptimizationhub.model.AccountEnrollmentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<AccountEnrollmentStatus>)
         */
        Builder items(Consumer<AccountEnrollmentStatus.Builder>... items);

        /**
         * <p>
         * The enrollment status of all member accounts in the organization if the account is the management account or
         * delegated administrator.
         * </p>
         * 
         * @param includeMemberAccounts
         *        The enrollment status of all member accounts in the organization if the account is the management
         *        account or delegated administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMemberAccounts(Boolean includeMemberAccounts);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CostOptimizationHubResponse.BuilderImpl implements Builder {
        private List<AccountEnrollmentStatus> items = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeMemberAccounts;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnrollmentStatusesResponse model) {
            super(model);
            items(model.items);
            includeMemberAccounts(model.includeMemberAccounts);
            nextToken(model.nextToken);
        }

        public final List<AccountEnrollmentStatus.Builder> getItems() {
            List<AccountEnrollmentStatus.Builder> result = AccountEnrollmentStatusesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AccountEnrollmentStatus.BuilderImpl> items) {
            this.items = AccountEnrollmentStatusesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AccountEnrollmentStatus> items) {
            this.items = AccountEnrollmentStatusesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AccountEnrollmentStatus... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AccountEnrollmentStatus.Builder>... items) {
            items(Stream.of(items).map(c -> AccountEnrollmentStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIncludeMemberAccounts() {
            return includeMemberAccounts;
        }

        public final void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
        }

        @Override
        public final Builder includeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnrollmentStatusesResponse build() {
            return new ListEnrollmentStatusesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
