/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The preferred configuration for Reserved Instances and Savings Plans commitment-based discounts, consisting of a
 * payment option and a commitment duration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreferredCommitment implements SdkPojo, Serializable,
        ToCopyableBuilder<PreferredCommitment.Builder, PreferredCommitment> {
    private static final SdkField<String> TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("term")
            .getter(getter(PreferredCommitment::termAsString)).setter(setter(Builder::term))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(PreferredCommitment::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERM_FIELD,
            PAYMENT_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String term;

    private final String paymentOption;

    private PreferredCommitment(BuilderImpl builder) {
        this.term = builder.term;
        this.paymentOption = builder.paymentOption;
    }

    /**
     * <p>
     * The preferred length of the commitment period. If the value is null, it will default to <code>ThreeYears</code>
     * (highest savings) where applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #term} will return
     * {@link Term#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termAsString}.
     * </p>
     * 
     * @return The preferred length of the commitment period. If the value is null, it will default to
     *         <code>ThreeYears</code> (highest savings) where applicable.
     * @see Term
     */
    public final Term term() {
        return Term.fromValue(term);
    }

    /**
     * <p>
     * The preferred length of the commitment period. If the value is null, it will default to <code>ThreeYears</code>
     * (highest savings) where applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #term} will return
     * {@link Term#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termAsString}.
     * </p>
     * 
     * @return The preferred length of the commitment period. If the value is null, it will default to
     *         <code>ThreeYears</code> (highest savings) where applicable.
     * @see Term
     */
    public final String termAsString() {
        return term;
    }

    /**
     * <p>
     * The preferred upfront payment structure for commitments. If the value is null, it will default to
     * <code>AllUpfront</code> (highest savings) where applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The preferred upfront payment structure for commitments. If the value is null, it will default to
     *         <code>AllUpfront</code> (highest savings) where applicable.
     * @see PaymentOption
     */
    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The preferred upfront payment structure for commitments. If the value is null, it will default to
     * <code>AllUpfront</code> (highest savings) where applicable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The preferred upfront payment structure for commitments. If the value is null, it will default to
     *         <code>AllUpfront</code> (highest savings) where applicable.
     * @see PaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(termAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreferredCommitment)) {
            return false;
        }
        PreferredCommitment other = (PreferredCommitment) obj;
        return Objects.equals(termAsString(), other.termAsString())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreferredCommitment").add("Term", termAsString()).add("PaymentOption", paymentOptionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "term":
            return Optional.ofNullable(clazz.cast(termAsString()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("term", TERM_FIELD);
        map.put("paymentOption", PAYMENT_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreferredCommitment, T> g) {
        return obj -> g.apply((PreferredCommitment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PreferredCommitment> {
        /**
         * <p>
         * The preferred length of the commitment period. If the value is null, it will default to
         * <code>ThreeYears</code> (highest savings) where applicable.
         * </p>
         * 
         * @param term
         *        The preferred length of the commitment period. If the value is null, it will default to
         *        <code>ThreeYears</code> (highest savings) where applicable.
         * @see Term
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Term
         */
        Builder term(String term);

        /**
         * <p>
         * The preferred length of the commitment period. If the value is null, it will default to
         * <code>ThreeYears</code> (highest savings) where applicable.
         * </p>
         * 
         * @param term
         *        The preferred length of the commitment period. If the value is null, it will default to
         *        <code>ThreeYears</code> (highest savings) where applicable.
         * @see Term
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Term
         */
        Builder term(Term term);

        /**
         * <p>
         * The preferred upfront payment structure for commitments. If the value is null, it will default to
         * <code>AllUpfront</code> (highest savings) where applicable.
         * </p>
         * 
         * @param paymentOption
         *        The preferred upfront payment structure for commitments. If the value is null, it will default to
         *        <code>AllUpfront</code> (highest savings) where applicable.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The preferred upfront payment structure for commitments. If the value is null, it will default to
         * <code>AllUpfront</code> (highest savings) where applicable.
         * </p>
         * 
         * @param paymentOption
         *        The preferred upfront payment structure for commitments. If the value is null, it will default to
         *        <code>AllUpfront</code> (highest savings) where applicable.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);
    }

    static final class BuilderImpl implements Builder {
        private String term;

        private String paymentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(PreferredCommitment model) {
            term(model.term);
            paymentOption(model.paymentOption);
        }

        public final String getTerm() {
            return term;
        }

        public final void setTerm(String term) {
            this.term = term;
        }

        @Override
        public final Builder term(String term) {
            this.term = term;
            return this;
        }

        @Override
        public final Builder term(Term term) {
            this.term(term == null ? null : term.toString());
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        @Override
        public PreferredCommitment build() {
            return new PreferredCommitment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
