/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DynamoDB reserved capacity configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamoDbReservedCapacityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamoDbReservedCapacityConfiguration.Builder, DynamoDbReservedCapacityConfiguration> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountScope").getter(getter(DynamoDbReservedCapacityConfiguration::accountScope))
            .setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountScope").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(DynamoDbReservedCapacityConfiguration::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("term")
            .getter(getter(DynamoDbReservedCapacityConfiguration::term)).setter(setter(Builder::term))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(DynamoDbReservedCapacityConfiguration::paymentOption))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reservedInstancesRegion").getter(getter(DynamoDbReservedCapacityConfiguration::reservedInstancesRegion))
            .setter(setter(Builder::reservedInstancesRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedInstancesRegion").build())
            .build();

    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upfrontCost").getter(getter(DynamoDbReservedCapacityConfiguration::upfrontCost))
            .setter(setter(Builder::upfrontCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontCost").build()).build();

    private static final SdkField<String> MONTHLY_RECURRING_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monthlyRecurringCost").getter(getter(DynamoDbReservedCapacityConfiguration::monthlyRecurringCost))
            .setter(setter(Builder::monthlyRecurringCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyRecurringCost").build())
            .build();

    private static final SdkField<String> NUMBER_OF_CAPACITY_UNITS_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("numberOfCapacityUnitsToPurchase")
            .getter(getter(DynamoDbReservedCapacityConfiguration::numberOfCapacityUnitsToPurchase))
            .setter(setter(Builder::numberOfCapacityUnitsToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfCapacityUnitsToPurchase")
                    .build()).build();

    private static final SdkField<String> CAPACITY_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capacityUnits").getter(getter(DynamoDbReservedCapacityConfiguration::capacityUnits))
            .setter(setter(Builder::capacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            SERVICE_FIELD, TERM_FIELD, PAYMENT_OPTION_FIELD, RESERVED_INSTANCES_REGION_FIELD, UPFRONT_COST_FIELD,
            MONTHLY_RECURRING_COST_FIELD, NUMBER_OF_CAPACITY_UNITS_TO_PURCHASE_FIELD, CAPACITY_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountScope;

    private final String service;

    private final String term;

    private final String paymentOption;

    private final String reservedInstancesRegion;

    private final String upfrontCost;

    private final String monthlyRecurringCost;

    private final String numberOfCapacityUnitsToPurchase;

    private final String capacityUnits;

    private DynamoDbReservedCapacityConfiguration(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.service = builder.service;
        this.term = builder.term;
        this.paymentOption = builder.paymentOption;
        this.reservedInstancesRegion = builder.reservedInstancesRegion;
        this.upfrontCost = builder.upfrontCost;
        this.monthlyRecurringCost = builder.monthlyRecurringCost;
        this.numberOfCapacityUnitsToPurchase = builder.numberOfCapacityUnitsToPurchase;
        this.capacityUnits = builder.capacityUnits;
    }

    /**
     * <p>
     * The account scope for which you want recommendations.
     * </p>
     * 
     * @return The account scope for which you want recommendations.
     */
    public final String accountScope() {
        return accountScope;
    }

    /**
     * <p>
     * The service for which you want recommendations.
     * </p>
     * 
     * @return The service for which you want recommendations.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The reserved capacity recommendation term in years.
     * </p>
     * 
     * @return The reserved capacity recommendation term in years.
     */
    public final String term() {
        return term;
    }

    /**
     * <p>
     * The payment option for the commitment.
     * </p>
     * 
     * @return The payment option for the commitment.
     */
    public final String paymentOption() {
        return paymentOption;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the commitment.
     * </p>
     * 
     * @return The Amazon Web Services Region of the commitment.
     */
    public final String reservedInstancesRegion() {
        return reservedInstancesRegion;
    }

    /**
     * <p>
     * How much purchasing this reserved capacity costs you upfront.
     * </p>
     * 
     * @return How much purchasing this reserved capacity costs you upfront.
     */
    public final String upfrontCost() {
        return upfrontCost;
    }

    /**
     * <p>
     * How much purchasing this reserved capacity costs you on a monthly basis.
     * </p>
     * 
     * @return How much purchasing this reserved capacity costs you on a monthly basis.
     */
    public final String monthlyRecurringCost() {
        return monthlyRecurringCost;
    }

    /**
     * <p>
     * The number of reserved capacity units that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The number of reserved capacity units that Amazon Web Services recommends that you purchase.
     */
    public final String numberOfCapacityUnitsToPurchase() {
        return numberOfCapacityUnitsToPurchase;
    }

    /**
     * <p>
     * The capacity unit of the recommended reservation.
     * </p>
     * 
     * @return The capacity unit of the recommended reservation.
     */
    public final String capacityUnits() {
        return capacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScope());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesRegion());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyRecurringCost());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfCapacityUnitsToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(capacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDbReservedCapacityConfiguration)) {
            return false;
        }
        DynamoDbReservedCapacityConfiguration other = (DynamoDbReservedCapacityConfiguration) obj;
        return Objects.equals(accountScope(), other.accountScope()) && Objects.equals(service(), other.service())
                && Objects.equals(term(), other.term()) && Objects.equals(paymentOption(), other.paymentOption())
                && Objects.equals(reservedInstancesRegion(), other.reservedInstancesRegion())
                && Objects.equals(upfrontCost(), other.upfrontCost())
                && Objects.equals(monthlyRecurringCost(), other.monthlyRecurringCost())
                && Objects.equals(numberOfCapacityUnitsToPurchase(), other.numberOfCapacityUnitsToPurchase())
                && Objects.equals(capacityUnits(), other.capacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamoDbReservedCapacityConfiguration").add("AccountScope", accountScope())
                .add("Service", service()).add("Term", term()).add("PaymentOption", paymentOption())
                .add("ReservedInstancesRegion", reservedInstancesRegion()).add("UpfrontCost", upfrontCost())
                .add("MonthlyRecurringCost", monthlyRecurringCost())
                .add("NumberOfCapacityUnitsToPurchase", numberOfCapacityUnitsToPurchase()).add("CapacityUnits", capacityUnits())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountScope":
            return Optional.ofNullable(clazz.cast(accountScope()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "term":
            return Optional.ofNullable(clazz.cast(term()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOption()));
        case "reservedInstancesRegion":
            return Optional.ofNullable(clazz.cast(reservedInstancesRegion()));
        case "upfrontCost":
            return Optional.ofNullable(clazz.cast(upfrontCost()));
        case "monthlyRecurringCost":
            return Optional.ofNullable(clazz.cast(monthlyRecurringCost()));
        case "numberOfCapacityUnitsToPurchase":
            return Optional.ofNullable(clazz.cast(numberOfCapacityUnitsToPurchase()));
        case "capacityUnits":
            return Optional.ofNullable(clazz.cast(capacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountScope", ACCOUNT_SCOPE_FIELD);
        map.put("service", SERVICE_FIELD);
        map.put("term", TERM_FIELD);
        map.put("paymentOption", PAYMENT_OPTION_FIELD);
        map.put("reservedInstancesRegion", RESERVED_INSTANCES_REGION_FIELD);
        map.put("upfrontCost", UPFRONT_COST_FIELD);
        map.put("monthlyRecurringCost", MONTHLY_RECURRING_COST_FIELD);
        map.put("numberOfCapacityUnitsToPurchase", NUMBER_OF_CAPACITY_UNITS_TO_PURCHASE_FIELD);
        map.put("capacityUnits", CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamoDbReservedCapacityConfiguration, T> g) {
        return obj -> g.apply((DynamoDbReservedCapacityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamoDbReservedCapacityConfiguration> {
        /**
         * <p>
         * The account scope for which you want recommendations.
         * </p>
         * 
         * @param accountScope
         *        The account scope for which you want recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * The service for which you want recommendations.
         * </p>
         * 
         * @param service
         *        The service for which you want recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The reserved capacity recommendation term in years.
         * </p>
         * 
         * @param term
         *        The reserved capacity recommendation term in years.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(String term);

        /**
         * <p>
         * The payment option for the commitment.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The Amazon Web Services Region of the commitment.
         * </p>
         * 
         * @param reservedInstancesRegion
         *        The Amazon Web Services Region of the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesRegion(String reservedInstancesRegion);

        /**
         * <p>
         * How much purchasing this reserved capacity costs you upfront.
         * </p>
         * 
         * @param upfrontCost
         *        How much purchasing this reserved capacity costs you upfront.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontCost(String upfrontCost);

        /**
         * <p>
         * How much purchasing this reserved capacity costs you on a monthly basis.
         * </p>
         * 
         * @param monthlyRecurringCost
         *        How much purchasing this reserved capacity costs you on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyRecurringCost(String monthlyRecurringCost);

        /**
         * <p>
         * The number of reserved capacity units that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param numberOfCapacityUnitsToPurchase
         *        The number of reserved capacity units that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfCapacityUnitsToPurchase(String numberOfCapacityUnitsToPurchase);

        /**
         * <p>
         * The capacity unit of the recommended reservation.
         * </p>
         * 
         * @param capacityUnits
         *        The capacity unit of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnits(String capacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private String accountScope;

        private String service;

        private String term;

        private String paymentOption;

        private String reservedInstancesRegion;

        private String upfrontCost;

        private String monthlyRecurringCost;

        private String numberOfCapacityUnitsToPurchase;

        private String capacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDbReservedCapacityConfiguration model) {
            accountScope(model.accountScope);
            service(model.service);
            term(model.term);
            paymentOption(model.paymentOption);
            reservedInstancesRegion(model.reservedInstancesRegion);
            upfrontCost(model.upfrontCost);
            monthlyRecurringCost(model.monthlyRecurringCost);
            numberOfCapacityUnitsToPurchase(model.numberOfCapacityUnitsToPurchase);
            capacityUnits(model.capacityUnits);
        }

        public final String getAccountScope() {
            return accountScope;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getTerm() {
            return term;
        }

        public final void setTerm(String term) {
            this.term = term;
        }

        @Override
        public final Builder term(String term) {
            this.term = term;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        public final String getReservedInstancesRegion() {
            return reservedInstancesRegion;
        }

        public final void setReservedInstancesRegion(String reservedInstancesRegion) {
            this.reservedInstancesRegion = reservedInstancesRegion;
        }

        @Override
        public final Builder reservedInstancesRegion(String reservedInstancesRegion) {
            this.reservedInstancesRegion = reservedInstancesRegion;
            return this;
        }

        public final String getUpfrontCost() {
            return upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final String getMonthlyRecurringCost() {
            return monthlyRecurringCost;
        }

        public final void setMonthlyRecurringCost(String monthlyRecurringCost) {
            this.monthlyRecurringCost = monthlyRecurringCost;
        }

        @Override
        public final Builder monthlyRecurringCost(String monthlyRecurringCost) {
            this.monthlyRecurringCost = monthlyRecurringCost;
            return this;
        }

        public final String getNumberOfCapacityUnitsToPurchase() {
            return numberOfCapacityUnitsToPurchase;
        }

        public final void setNumberOfCapacityUnitsToPurchase(String numberOfCapacityUnitsToPurchase) {
            this.numberOfCapacityUnitsToPurchase = numberOfCapacityUnitsToPurchase;
        }

        @Override
        public final Builder numberOfCapacityUnitsToPurchase(String numberOfCapacityUnitsToPurchase) {
            this.numberOfCapacityUnitsToPurchase = numberOfCapacityUnitsToPurchase;
            return this;
        }

        public final String getCapacityUnits() {
            return capacityUnits;
        }

        public final void setCapacityUnits(String capacityUnits) {
            this.capacityUnits = capacityUnits;
        }

        @Override
        public final Builder capacityUnits(String capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        @Override
        public DynamoDbReservedCapacityConfiguration build() {
            return new DynamoDbReservedCapacityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
