/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EC2 Auto Scaling group configuration used for recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2AutoScalingGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2AutoScalingGroupConfiguration.Builder, Ec2AutoScalingGroupConfiguration> {
    private static final SdkField<InstanceConfiguration> INSTANCE_FIELD = SdkField
            .<InstanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("instance")
            .getter(getter(Ec2AutoScalingGroupConfiguration::instance)).setter(setter(Builder::instance))
            .constructor(InstanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instance").build()).build();

    private static final SdkField<List<MixedInstanceConfiguration>> MIXED_INSTANCES_FIELD = SdkField
            .<List<MixedInstanceConfiguration>> builder(MarshallingType.LIST)
            .memberName("mixedInstances")
            .getter(getter(Ec2AutoScalingGroupConfiguration::mixedInstances))
            .setter(setter(Builder::mixedInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mixedInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MixedInstanceConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(MixedInstanceConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Ec2AutoScalingGroupConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("allocationStrategy").getter(getter(Ec2AutoScalingGroupConfiguration::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FIELD,
            MIXED_INSTANCES_FIELD, TYPE_FIELD, ALLOCATION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InstanceConfiguration instance;

    private final List<MixedInstanceConfiguration> mixedInstances;

    private final String type;

    private final String allocationStrategy;

    private Ec2AutoScalingGroupConfiguration(BuilderImpl builder) {
        this.instance = builder.instance;
        this.mixedInstances = builder.mixedInstances;
        this.type = builder.type;
        this.allocationStrategy = builder.allocationStrategy;
    }

    /**
     * <p>
     * Details about the instance for the EC2 Auto Scaling group with a single instance type.
     * </p>
     * 
     * @return Details about the instance for the EC2 Auto Scaling group with a single instance type.
     */
    public final InstanceConfiguration instance() {
        return instance;
    }

    /**
     * For responses, this returns true if the service returned a value for the MixedInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMixedInstances() {
        return mixedInstances != null && !(mixedInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of instance types for an EC2 Auto Scaling group with mixed instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMixedInstances} method.
     * </p>
     * 
     * @return A list of instance types for an EC2 Auto Scaling group with mixed instance types.
     */
    public final List<MixedInstanceConfiguration> mixedInstances() {
        return mixedInstances;
    }

    /**
     * <p>
     * The type of EC2 Auto Scaling group, showing whether it consists of a single instance type or mixed instance
     * types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Ec2AutoScalingGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of EC2 Auto Scaling group, showing whether it consists of a single instance type or mixed
     *         instance types.
     * @see Ec2AutoScalingGroupType
     */
    public final Ec2AutoScalingGroupType type() {
        return Ec2AutoScalingGroupType.fromValue(type);
    }

    /**
     * <p>
     * The type of EC2 Auto Scaling group, showing whether it consists of a single instance type or mixed instance
     * types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Ec2AutoScalingGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of EC2 Auto Scaling group, showing whether it consists of a single instance type or mixed
     *         instance types.
     * @see Ec2AutoScalingGroupType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The strategy used for allocating instances, based on a predefined priority order or based on the lowest available
     * price.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The strategy used for allocating instances, based on a predefined priority order or based on the lowest
     *         available price.
     * @see AllocationStrategy
     */
    public final AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * The strategy used for allocating instances, based on a predefined priority order or based on the lowest available
     * price.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The strategy used for allocating instances, based on a predefined priority order or based on the lowest
     *         available price.
     * @see AllocationStrategy
     */
    public final String allocationStrategyAsString() {
        return allocationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        hashCode = 31 * hashCode + Objects.hashCode(hasMixedInstances() ? mixedInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AutoScalingGroupConfiguration)) {
            return false;
        }
        Ec2AutoScalingGroupConfiguration other = (Ec2AutoScalingGroupConfiguration) obj;
        return Objects.equals(instance(), other.instance()) && hasMixedInstances() == other.hasMixedInstances()
                && Objects.equals(mixedInstances(), other.mixedInstances())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2AutoScalingGroupConfiguration").add("Instance", instance())
                .add("MixedInstances", hasMixedInstances() ? mixedInstances() : null).add("Type", typeAsString())
                .add("AllocationStrategy", allocationStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instance":
            return Optional.ofNullable(clazz.cast(instance()));
        case "mixedInstances":
            return Optional.ofNullable(clazz.cast(mixedInstances()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "allocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instance", INSTANCE_FIELD);
        map.put("mixedInstances", MIXED_INSTANCES_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("allocationStrategy", ALLOCATION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2AutoScalingGroupConfiguration, T> g) {
        return obj -> g.apply((Ec2AutoScalingGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2AutoScalingGroupConfiguration> {
        /**
         * <p>
         * Details about the instance for the EC2 Auto Scaling group with a single instance type.
         * </p>
         * 
         * @param instance
         *        Details about the instance for the EC2 Auto Scaling group with a single instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(InstanceConfiguration instance);

        /**
         * <p>
         * Details about the instance for the EC2 Auto Scaling group with a single instance type.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceConfiguration.Builder} avoiding
         * the need to create one manually via {@link InstanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #instance(InstanceConfiguration)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link InstanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(InstanceConfiguration)
         */
        default Builder instance(Consumer<InstanceConfiguration.Builder> instance) {
            return instance(InstanceConfiguration.builder().applyMutation(instance).build());
        }

        /**
         * <p>
         * A list of instance types for an EC2 Auto Scaling group with mixed instance types.
         * </p>
         * 
         * @param mixedInstances
         *        A list of instance types for an EC2 Auto Scaling group with mixed instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstances(Collection<MixedInstanceConfiguration> mixedInstances);

        /**
         * <p>
         * A list of instance types for an EC2 Auto Scaling group with mixed instance types.
         * </p>
         * 
         * @param mixedInstances
         *        A list of instance types for an EC2 Auto Scaling group with mixed instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstances(MixedInstanceConfiguration... mixedInstances);

        /**
         * <p>
         * A list of instance types for an EC2 Auto Scaling group with mixed instance types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.MixedInstanceConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.MixedInstanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.MixedInstanceConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link #mixedInstances(List<MixedInstanceConfiguration>)}.
         * 
         * @param mixedInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costoptimizationhub.model.MixedInstanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedInstances(java.util.Collection<MixedInstanceConfiguration>)
         */
        Builder mixedInstances(Consumer<MixedInstanceConfiguration.Builder>... mixedInstances);

        /**
         * <p>
         * The type of EC2 Auto Scaling group, showing whether it consists of a single instance type or mixed instance
         * types.
         * </p>
         * 
         * @param type
         *        The type of EC2 Auto Scaling group, showing whether it consists of a single instance type or mixed
         *        instance types.
         * @see Ec2AutoScalingGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2AutoScalingGroupType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of EC2 Auto Scaling group, showing whether it consists of a single instance type or mixed instance
         * types.
         * </p>
         * 
         * @param type
         *        The type of EC2 Auto Scaling group, showing whether it consists of a single instance type or mixed
         *        instance types.
         * @see Ec2AutoScalingGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ec2AutoScalingGroupType
         */
        Builder type(Ec2AutoScalingGroupType type);

        /**
         * <p>
         * The strategy used for allocating instances, based on a predefined priority order or based on the lowest
         * available price.
         * </p>
         * 
         * @param allocationStrategy
         *        The strategy used for allocating instances, based on a predefined priority order or based on the
         *        lowest available price.
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * The strategy used for allocating instances, based on a predefined priority order or based on the lowest
         * available price.
         * </p>
         * 
         * @param allocationStrategy
         *        The strategy used for allocating instances, based on a predefined priority order or based on the
         *        lowest available price.
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(AllocationStrategy allocationStrategy);
    }

    static final class BuilderImpl implements Builder {
        private InstanceConfiguration instance;

        private List<MixedInstanceConfiguration> mixedInstances = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String allocationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AutoScalingGroupConfiguration model) {
            instance(model.instance);
            mixedInstances(model.mixedInstances);
            type(model.type);
            allocationStrategy(model.allocationStrategy);
        }

        public final InstanceConfiguration.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        public final void setInstance(InstanceConfiguration.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public final Builder instance(InstanceConfiguration instance) {
            this.instance = instance;
            return this;
        }

        public final List<MixedInstanceConfiguration.Builder> getMixedInstances() {
            List<MixedInstanceConfiguration.Builder> result = MixedInstanceConfigurationListCopier
                    .copyToBuilder(this.mixedInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMixedInstances(Collection<MixedInstanceConfiguration.BuilderImpl> mixedInstances) {
            this.mixedInstances = MixedInstanceConfigurationListCopier.copyFromBuilder(mixedInstances);
        }

        @Override
        public final Builder mixedInstances(Collection<MixedInstanceConfiguration> mixedInstances) {
            this.mixedInstances = MixedInstanceConfigurationListCopier.copy(mixedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedInstances(MixedInstanceConfiguration... mixedInstances) {
            mixedInstances(Arrays.asList(mixedInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedInstances(Consumer<MixedInstanceConfiguration.Builder>... mixedInstances) {
            mixedInstances(Stream.of(mixedInstances).map(c -> MixedInstanceConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Ec2AutoScalingGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        @Override
        public Ec2AutoScalingGroupConfiguration build() {
            return new Ec2AutoScalingGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
