/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains cost efficiency metrics for a specific group over time. The group is defined by the grouping dimension
 * specified in the request, such as account ID, Amazon Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EfficiencyMetricsByGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<EfficiencyMetricsByGroup.Builder, EfficiencyMetricsByGroup> {
    private static final SdkField<List<MetricsByTime>> METRICS_BY_TIME_FIELD = SdkField
            .<List<MetricsByTime>> builder(MarshallingType.LIST)
            .memberName("metricsByTime")
            .getter(getter(EfficiencyMetricsByGroup::metricsByTime))
            .setter(setter(Builder::metricsByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsByTime").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricsByTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricsByTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(EfficiencyMetricsByGroup::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(EfficiencyMetricsByGroup::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_BY_TIME_FIELD,
            GROUP_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MetricsByTime> metricsByTime;

    private final String group;

    private final String message;

    private EfficiencyMetricsByGroup(BuilderImpl builder) {
        this.metricsByTime = builder.metricsByTime;
        this.group = builder.group;
        this.message = builder.message;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricsByTime property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricsByTime() {
        return metricsByTime != null && !(metricsByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of time-series data points containing efficiency metrics for this group. Each data point includes an
     * efficiency score, estimated savings, spending, and a timestamp corresponding to the specified granularity. This
     * field is null when efficiency metrics cannot be calculated for the group, in which case the message field
     * provides an explanation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricsByTime} method.
     * </p>
     * 
     * @return A list of time-series data points containing efficiency metrics for this group. Each data point includes
     *         an efficiency score, estimated savings, spending, and a timestamp corresponding to the specified
     *         granularity. This field is null when efficiency metrics cannot be calculated for the group, in which case
     *         the message field provides an explanation.
     */
    public final List<MetricsByTime> metricsByTime() {
        return metricsByTime;
    }

    /**
     * <p>
     * The value of the grouping dimension for this set of metrics. For example, if grouped by account ID, this field
     * contains the account ID. If no grouping is specified, this field is empty.
     * </p>
     * 
     * @return The value of the grouping dimension for this set of metrics. For example, if grouped by account ID, this
     *         field contains the account ID. If no grouping is specified, this field is empty.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * An explanation of why efficiency metrics could not be calculated for this group when the metricsByTime field is
     * null. Common reasons include insufficient or inconclusive cost and usage data during the specified time period.
     * This field is null or empty when metrics are successfully calculated.
     * </p>
     * 
     * @return An explanation of why efficiency metrics could not be calculated for this group when the metricsByTime
     *         field is null. Common reasons include insufficient or inconclusive cost and usage data during the
     *         specified time period. This field is null or empty when metrics are successfully calculated.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricsByTime() ? metricsByTime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EfficiencyMetricsByGroup)) {
            return false;
        }
        EfficiencyMetricsByGroup other = (EfficiencyMetricsByGroup) obj;
        return hasMetricsByTime() == other.hasMetricsByTime() && Objects.equals(metricsByTime(), other.metricsByTime())
                && Objects.equals(group(), other.group()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EfficiencyMetricsByGroup").add("MetricsByTime", hasMetricsByTime() ? metricsByTime() : null)
                .add("Group", group()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricsByTime":
            return Optional.ofNullable(clazz.cast(metricsByTime()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metricsByTime", METRICS_BY_TIME_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EfficiencyMetricsByGroup, T> g) {
        return obj -> g.apply((EfficiencyMetricsByGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EfficiencyMetricsByGroup> {
        /**
         * <p>
         * A list of time-series data points containing efficiency metrics for this group. Each data point includes an
         * efficiency score, estimated savings, spending, and a timestamp corresponding to the specified granularity.
         * This field is null when efficiency metrics cannot be calculated for the group, in which case the message
         * field provides an explanation.
         * </p>
         * 
         * @param metricsByTime
         *        A list of time-series data points containing efficiency metrics for this group. Each data point
         *        includes an efficiency score, estimated savings, spending, and a timestamp corresponding to the
         *        specified granularity. This field is null when efficiency metrics cannot be calculated for the group,
         *        in which case the message field provides an explanation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsByTime(Collection<MetricsByTime> metricsByTime);

        /**
         * <p>
         * A list of time-series data points containing efficiency metrics for this group. Each data point includes an
         * efficiency score, estimated savings, spending, and a timestamp corresponding to the specified granularity.
         * This field is null when efficiency metrics cannot be calculated for the group, in which case the message
         * field provides an explanation.
         * </p>
         * 
         * @param metricsByTime
         *        A list of time-series data points containing efficiency metrics for this group. Each data point
         *        includes an efficiency score, estimated savings, spending, and a timestamp corresponding to the
         *        specified granularity. This field is null when efficiency metrics cannot be calculated for the group,
         *        in which case the message field provides an explanation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsByTime(MetricsByTime... metricsByTime);

        /**
         * <p>
         * A list of time-series data points containing efficiency metrics for this group. Each data point includes an
         * efficiency score, estimated savings, spending, and a timestamp corresponding to the specified granularity.
         * This field is null when efficiency metrics cannot be calculated for the group, in which case the message
         * field provides an explanation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.MetricsByTime.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.MetricsByTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.MetricsByTime.Builder#build()} is called
         * immediately and its result is passed to {@link #metricsByTime(List<MetricsByTime>)}.
         * 
         * @param metricsByTime
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costoptimizationhub.model.MetricsByTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsByTime(java.util.Collection<MetricsByTime>)
         */
        Builder metricsByTime(Consumer<MetricsByTime.Builder>... metricsByTime);

        /**
         * <p>
         * The value of the grouping dimension for this set of metrics. For example, if grouped by account ID, this
         * field contains the account ID. If no grouping is specified, this field is empty.
         * </p>
         * 
         * @param group
         *        The value of the grouping dimension for this set of metrics. For example, if grouped by account ID,
         *        this field contains the account ID. If no grouping is specified, this field is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * An explanation of why efficiency metrics could not be calculated for this group when the metricsByTime field
         * is null. Common reasons include insufficient or inconclusive cost and usage data during the specified time
         * period. This field is null or empty when metrics are successfully calculated.
         * </p>
         * 
         * @param message
         *        An explanation of why efficiency metrics could not be calculated for this group when the metricsByTime
         *        field is null. Common reasons include insufficient or inconclusive cost and usage data during the
         *        specified time period. This field is null or empty when metrics are successfully calculated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private List<MetricsByTime> metricsByTime = DefaultSdkAutoConstructList.getInstance();

        private String group;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(EfficiencyMetricsByGroup model) {
            metricsByTime(model.metricsByTime);
            group(model.group);
            message(model.message);
        }

        public final List<MetricsByTime.Builder> getMetricsByTime() {
            List<MetricsByTime.Builder> result = MetricsByTimeListCopier.copyToBuilder(this.metricsByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsByTime(Collection<MetricsByTime.BuilderImpl> metricsByTime) {
            this.metricsByTime = MetricsByTimeListCopier.copyFromBuilder(metricsByTime);
        }

        @Override
        public final Builder metricsByTime(Collection<MetricsByTime> metricsByTime) {
            this.metricsByTime = MetricsByTimeListCopier.copy(metricsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsByTime(MetricsByTime... metricsByTime) {
            metricsByTime(Arrays.asList(metricsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsByTime(Consumer<MetricsByTime.Builder>... metricsByTime) {
            metricsByTime(Stream.of(metricsByTime).map(c -> MetricsByTime.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public EfficiencyMetricsByGroup build() {
            return new EfficiencyMetricsByGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
