/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEfficiencyMetricsRequest extends CostOptimizationHubRequest implements
        ToCopyableBuilder<ListEfficiencyMetricsRequest.Builder, ListEfficiencyMetricsRequest> {
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupBy").getter(getter(ListEfficiencyMetricsRequest::groupBy)).setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("granularity").getter(getter(ListEfficiencyMetricsRequest::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("granularity").build()).build();

    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.<TimePeriod> builder(MarshallingType.SDK_POJO)
            .memberName("timePeriod").getter(getter(ListEfficiencyMetricsRequest::timePeriod))
            .setter(setter(Builder::timePeriod)).constructor(TimePeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePeriod").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEfficiencyMetricsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<OrderBy> ORDER_BY_FIELD = SdkField.<OrderBy> builder(MarshallingType.SDK_POJO)
            .memberName("orderBy").getter(getter(ListEfficiencyMetricsRequest::orderBy)).setter(setter(Builder::orderBy))
            .constructor(OrderBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEfficiencyMetricsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD,
            GRANULARITY_FIELD, TIME_PERIOD_FIELD, MAX_RESULTS_FIELD, ORDER_BY_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupBy;

    private final String granularity;

    private final TimePeriod timePeriod;

    private final Integer maxResults;

    private final OrderBy orderBy;

    private final String nextToken;

    private ListEfficiencyMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.groupBy = builder.groupBy;
        this.granularity = builder.granularity;
        this.timePeriod = builder.timePeriod;
        this.maxResults = builder.maxResults;
        this.orderBy = builder.orderBy;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The dimension by which to group the cost efficiency metrics. Valid values include account ID, Amazon Web Services
     * Region. When no grouping is specified, metrics are aggregated across all resources in the specified time period.
     * </p>
     * 
     * @return The dimension by which to group the cost efficiency metrics. Valid values include account ID, Amazon Web
     *         Services Region. When no grouping is specified, metrics are aggregated across all resources in the
     *         specified time period.
     */
    public final String groupBy() {
        return groupBy;
    }

    /**
     * <p>
     * The time granularity for the cost efficiency metrics. Specify <code>Daily</code> for metrics aggregated by day,
     * or <code>Monthly</code> for metrics aggregated by month.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link GranularityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The time granularity for the cost efficiency metrics. Specify <code>Daily</code> for metrics aggregated
     *         by day, or <code>Monthly</code> for metrics aggregated by month.
     * @see GranularityType
     */
    public final GranularityType granularity() {
        return GranularityType.fromValue(granularity);
    }

    /**
     * <p>
     * The time granularity for the cost efficiency metrics. Specify <code>Daily</code> for metrics aggregated by day,
     * or <code>Monthly</code> for metrics aggregated by month.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link GranularityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The time granularity for the cost efficiency metrics. Specify <code>Daily</code> for metrics aggregated
     *         by day, or <code>Monthly</code> for metrics aggregated by month.
     * @see GranularityType
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * <p>
     * The time period for which to retrieve the cost efficiency metrics. The start date is inclusive and the end date
     * is exclusive. Dates can be specified in either YYYY-MM-DD format or YYYY-MM format depending on the desired
     * granularity.
     * </p>
     * 
     * @return The time period for which to retrieve the cost efficiency metrics. The start date is inclusive and the
     *         end date is exclusive. Dates can be specified in either YYYY-MM-DD format or YYYY-MM format depending on
     *         the desired granularity.
     */
    public final TimePeriod timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The maximum number of groups to return in the response. Valid values range from 0 to 1000. Use in conjunction
     * with <code>nextToken</code> to paginate through results when the total number of groups exceeds this limit.
     * </p>
     * 
     * @return The maximum number of groups to return in the response. Valid values range from 0 to 1000. Use in
     *         conjunction with <code>nextToken</code> to paginate through results when the total number of groups
     *         exceeds this limit.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The ordering specification for the results. Defines which dimension to sort by and whether to sort in ascending
     * or descending order.
     * </p>
     * 
     * @return The ordering specification for the results. Defines which dimension to sort by and whether to sort in
     *         ascending or descending order.
     */
    public final OrderBy orderBy() {
        return orderBy;
    }

    /**
     * <p>
     * The token to retrieve the next page of results. This value is returned in the response when the number of groups
     * exceeds the specified <code>maxResults</code> value.
     * </p>
     * 
     * @return The token to retrieve the next page of results. This value is returned in the response when the number of
     *         groups exceeds the specified <code>maxResults</code> value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(orderBy());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEfficiencyMetricsRequest)) {
            return false;
        }
        ListEfficiencyMetricsRequest other = (ListEfficiencyMetricsRequest) obj;
        return Objects.equals(groupBy(), other.groupBy()) && Objects.equals(granularityAsString(), other.granularityAsString())
                && Objects.equals(timePeriod(), other.timePeriod()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(orderBy(), other.orderBy()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEfficiencyMetricsRequest").add("GroupBy", groupBy())
                .add("Granularity", granularityAsString()).add("TimePeriod", timePeriod()).add("MaxResults", maxResults())
                .add("OrderBy", orderBy()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "timePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderBy()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("groupBy", GROUP_BY_FIELD);
        map.put("granularity", GRANULARITY_FIELD);
        map.put("timePeriod", TIME_PERIOD_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("orderBy", ORDER_BY_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEfficiencyMetricsRequest, T> g) {
        return obj -> g.apply((ListEfficiencyMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostOptimizationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEfficiencyMetricsRequest> {
        /**
         * <p>
         * The dimension by which to group the cost efficiency metrics. Valid values include account ID, Amazon Web
         * Services Region. When no grouping is specified, metrics are aggregated across all resources in the specified
         * time period.
         * </p>
         * 
         * @param groupBy
         *        The dimension by which to group the cost efficiency metrics. Valid values include account ID, Amazon
         *        Web Services Region. When no grouping is specified, metrics are aggregated across all resources in the
         *        specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(String groupBy);

        /**
         * <p>
         * The time granularity for the cost efficiency metrics. Specify <code>Daily</code> for metrics aggregated by
         * day, or <code>Monthly</code> for metrics aggregated by month.
         * </p>
         * 
         * @param granularity
         *        The time granularity for the cost efficiency metrics. Specify <code>Daily</code> for metrics
         *        aggregated by day, or <code>Monthly</code> for metrics aggregated by month.
         * @see GranularityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GranularityType
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The time granularity for the cost efficiency metrics. Specify <code>Daily</code> for metrics aggregated by
         * day, or <code>Monthly</code> for metrics aggregated by month.
         * </p>
         * 
         * @param granularity
         *        The time granularity for the cost efficiency metrics. Specify <code>Daily</code> for metrics
         *        aggregated by day, or <code>Monthly</code> for metrics aggregated by month.
         * @see GranularityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GranularityType
         */
        Builder granularity(GranularityType granularity);

        /**
         * <p>
         * The time period for which to retrieve the cost efficiency metrics. The start date is inclusive and the end
         * date is exclusive. Dates can be specified in either YYYY-MM-DD format or YYYY-MM format depending on the
         * desired granularity.
         * </p>
         * 
         * @param timePeriod
         *        The time period for which to retrieve the cost efficiency metrics. The start date is inclusive and the
         *        end date is exclusive. Dates can be specified in either YYYY-MM-DD format or YYYY-MM format depending
         *        on the desired granularity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(TimePeriod timePeriod);

        /**
         * <p>
         * The time period for which to retrieve the cost efficiency metrics. The start date is inclusive and the end
         * date is exclusive. Dates can be specified in either YYYY-MM-DD format or YYYY-MM format depending on the
         * desired granularity.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimePeriod.Builder} avoiding the need to
         * create one manually via {@link TimePeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimePeriod.Builder#build()} is called immediately and its result
         * is passed to {@link #timePeriod(TimePeriod)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link TimePeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(TimePeriod)
         */
        default Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return timePeriod(TimePeriod.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The maximum number of groups to return in the response. Valid values range from 0 to 1000. Use in conjunction
         * with <code>nextToken</code> to paginate through results when the total number of groups exceeds this limit.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of groups to return in the response. Valid values range from 0 to 1000. Use in
         *        conjunction with <code>nextToken</code> to paginate through results when the total number of groups
         *        exceeds this limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The ordering specification for the results. Defines which dimension to sort by and whether to sort in
         * ascending or descending order.
         * </p>
         * 
         * @param orderBy
         *        The ordering specification for the results. Defines which dimension to sort by and whether to sort in
         *        ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderBy(OrderBy orderBy);

        /**
         * <p>
         * The ordering specification for the results. Defines which dimension to sort by and whether to sort in
         * ascending or descending order.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrderBy.Builder} avoiding the need to
         * create one manually via {@link OrderBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrderBy.Builder#build()} is called immediately and its result is
         * passed to {@link #orderBy(OrderBy)}.
         * 
         * @param orderBy
         *        a consumer that will call methods on {@link OrderBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderBy(OrderBy)
         */
        default Builder orderBy(Consumer<OrderBy.Builder> orderBy) {
            return orderBy(OrderBy.builder().applyMutation(orderBy).build());
        }

        /**
         * <p>
         * The token to retrieve the next page of results. This value is returned in the response when the number of
         * groups exceeds the specified <code>maxResults</code> value.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results. This value is returned in the response when the number
         *        of groups exceeds the specified <code>maxResults</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostOptimizationHubRequest.BuilderImpl implements Builder {
        private String groupBy;

        private String granularity;

        private TimePeriod timePeriod;

        private Integer maxResults;

        private OrderBy orderBy;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEfficiencyMetricsRequest model) {
            super(model);
            groupBy(model.groupBy);
            granularity(model.granularity);
            timePeriod(model.timePeriod);
            maxResults(model.maxResults);
            orderBy(model.orderBy);
            nextToken(model.nextToken);
        }

        public final String getGroupBy() {
            return groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(GranularityType granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final OrderBy.Builder getOrderBy() {
            return orderBy != null ? orderBy.toBuilder() : null;
        }

        public final void setOrderBy(OrderBy.BuilderImpl orderBy) {
            this.orderBy = orderBy != null ? orderBy.build() : null;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEfficiencyMetricsRequest build() {
            return new ListEfficiencyMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
