/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEfficiencyMetricsResponse extends CostOptimizationHubResponse implements
        ToCopyableBuilder<ListEfficiencyMetricsResponse.Builder, ListEfficiencyMetricsResponse> {
    private static final SdkField<List<EfficiencyMetricsByGroup>> EFFICIENCY_METRICS_BY_GROUP_FIELD = SdkField
            .<List<EfficiencyMetricsByGroup>> builder(MarshallingType.LIST)
            .memberName("efficiencyMetricsByGroup")
            .getter(getter(ListEfficiencyMetricsResponse::efficiencyMetricsByGroup))
            .setter(setter(Builder::efficiencyMetricsByGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("efficiencyMetricsByGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EfficiencyMetricsByGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(EfficiencyMetricsByGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEfficiencyMetricsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EFFICIENCY_METRICS_BY_GROUP_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EfficiencyMetricsByGroup> efficiencyMetricsByGroup;

    private final String nextToken;

    private ListEfficiencyMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.efficiencyMetricsByGroup = builder.efficiencyMetricsByGroup;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EfficiencyMetricsByGroup property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEfficiencyMetricsByGroup() {
        return efficiencyMetricsByGroup != null && !(efficiencyMetricsByGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cost efficiency metrics grouped by the specified dimension. Each group contains time-series data points
     * with cost efficiency, potential savings, and optimzable spend for the specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEfficiencyMetricsByGroup} method.
     * </p>
     * 
     * @return A list of cost efficiency metrics grouped by the specified dimension. Each group contains time-series
     *         data points with cost efficiency, potential savings, and optimzable spend for the specified time period.
     */
    public final List<EfficiencyMetricsByGroup> efficiencyMetricsByGroup() {
        return efficiencyMetricsByGroup;
    }

    /**
     * <p>
     * The token to retrieve the next page of results. When this value is present in the response, additional groups are
     * available. Pass this token in the <code>nextToken</code> parameter of a subsequent request to retrieve the next
     * page.
     * </p>
     * 
     * @return The token to retrieve the next page of results. When this value is present in the response, additional
     *         groups are available. Pass this token in the <code>nextToken</code> parameter of a subsequent request to
     *         retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEfficiencyMetricsByGroup() ? efficiencyMetricsByGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEfficiencyMetricsResponse)) {
            return false;
        }
        ListEfficiencyMetricsResponse other = (ListEfficiencyMetricsResponse) obj;
        return hasEfficiencyMetricsByGroup() == other.hasEfficiencyMetricsByGroup()
                && Objects.equals(efficiencyMetricsByGroup(), other.efficiencyMetricsByGroup())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEfficiencyMetricsResponse")
                .add("EfficiencyMetricsByGroup", hasEfficiencyMetricsByGroup() ? efficiencyMetricsByGroup() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "efficiencyMetricsByGroup":
            return Optional.ofNullable(clazz.cast(efficiencyMetricsByGroup()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("efficiencyMetricsByGroup", EFFICIENCY_METRICS_BY_GROUP_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEfficiencyMetricsResponse, T> g) {
        return obj -> g.apply((ListEfficiencyMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostOptimizationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEfficiencyMetricsResponse> {
        /**
         * <p>
         * A list of cost efficiency metrics grouped by the specified dimension. Each group contains time-series data
         * points with cost efficiency, potential savings, and optimzable spend for the specified time period.
         * </p>
         * 
         * @param efficiencyMetricsByGroup
         *        A list of cost efficiency metrics grouped by the specified dimension. Each group contains time-series
         *        data points with cost efficiency, potential savings, and optimzable spend for the specified time
         *        period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efficiencyMetricsByGroup(Collection<EfficiencyMetricsByGroup> efficiencyMetricsByGroup);

        /**
         * <p>
         * A list of cost efficiency metrics grouped by the specified dimension. Each group contains time-series data
         * points with cost efficiency, potential savings, and optimzable spend for the specified time period.
         * </p>
         * 
         * @param efficiencyMetricsByGroup
         *        A list of cost efficiency metrics grouped by the specified dimension. Each group contains time-series
         *        data points with cost efficiency, potential savings, and optimzable spend for the specified time
         *        period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efficiencyMetricsByGroup(EfficiencyMetricsByGroup... efficiencyMetricsByGroup);

        /**
         * <p>
         * A list of cost efficiency metrics grouped by the specified dimension. Each group contains time-series data
         * points with cost efficiency, potential savings, and optimzable spend for the specified time period.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.EfficiencyMetricsByGroup.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.EfficiencyMetricsByGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costoptimizationhub.model.EfficiencyMetricsByGroup.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #efficiencyMetricsByGroup(List<EfficiencyMetricsByGroup>)}.
         * 
         * @param efficiencyMetricsByGroup
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costoptimizationhub.model.EfficiencyMetricsByGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efficiencyMetricsByGroup(java.util.Collection<EfficiencyMetricsByGroup>)
         */
        Builder efficiencyMetricsByGroup(Consumer<EfficiencyMetricsByGroup.Builder>... efficiencyMetricsByGroup);

        /**
         * <p>
         * The token to retrieve the next page of results. When this value is present in the response, additional groups
         * are available. Pass this token in the <code>nextToken</code> parameter of a subsequent request to retrieve
         * the next page.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results. When this value is present in the response, additional
         *        groups are available. Pass this token in the <code>nextToken</code> parameter of a subsequent request
         *        to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CostOptimizationHubResponse.BuilderImpl implements Builder {
        private List<EfficiencyMetricsByGroup> efficiencyMetricsByGroup = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEfficiencyMetricsResponse model) {
            super(model);
            efficiencyMetricsByGroup(model.efficiencyMetricsByGroup);
            nextToken(model.nextToken);
        }

        public final List<EfficiencyMetricsByGroup.Builder> getEfficiencyMetricsByGroup() {
            List<EfficiencyMetricsByGroup.Builder> result = EfficiencyMetricsByGroupListCopier
                    .copyToBuilder(this.efficiencyMetricsByGroup);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEfficiencyMetricsByGroup(Collection<EfficiencyMetricsByGroup.BuilderImpl> efficiencyMetricsByGroup) {
            this.efficiencyMetricsByGroup = EfficiencyMetricsByGroupListCopier.copyFromBuilder(efficiencyMetricsByGroup);
        }

        @Override
        public final Builder efficiencyMetricsByGroup(Collection<EfficiencyMetricsByGroup> efficiencyMetricsByGroup) {
            this.efficiencyMetricsByGroup = EfficiencyMetricsByGroupListCopier.copy(efficiencyMetricsByGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder efficiencyMetricsByGroup(EfficiencyMetricsByGroup... efficiencyMetricsByGroup) {
            efficiencyMetricsByGroup(Arrays.asList(efficiencyMetricsByGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder efficiencyMetricsByGroup(Consumer<EfficiencyMetricsByGroup.Builder>... efficiencyMetricsByGroup) {
            efficiencyMetricsByGroup(Stream.of(efficiencyMetricsByGroup)
                    .map(c -> EfficiencyMetricsByGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEfficiencyMetricsResponse build() {
            return new ListEfficiencyMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
