/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains efficiency metrics for a specific point in time, including an efficiency score, potential savings,
 * optimizable spend, and timestamp.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricsByTime implements SdkPojo, Serializable, ToCopyableBuilder<MetricsByTime.Builder, MetricsByTime> {
    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("score")
            .getter(getter(MetricsByTime::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final SdkField<Double> SAVINGS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("savings")
            .getter(getter(MetricsByTime::savings)).setter(setter(Builder::savings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savings").build()).build();

    private static final SdkField<Double> SPEND_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("spend")
            .getter(getter(MetricsByTime::spend)).setter(setter(Builder::spend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spend").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timestamp").getter(getter(MetricsByTime::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_FIELD, SAVINGS_FIELD,
            SPEND_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double score;

    private final Double savings;

    private final Double spend;

    private final String timestamp;

    private MetricsByTime(BuilderImpl builder) {
        this.score = builder.score;
        this.savings = builder.savings;
        this.spend = builder.spend;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The efficiency score for this time period. The score represents a measure of how effectively the cloud resources
     * are being optimized, with higher scores indicating better optimization performance.
     * </p>
     * 
     * @return The efficiency score for this time period. The score represents a measure of how effectively the cloud
     *         resources are being optimized, with higher scores indicating better optimization performance.
     */
    public final Double score() {
        return score;
    }

    /**
     * <p>
     * The estimated savings amount for this time period, representing the potential cost reduction achieved through
     * optimization recommendations.
     * </p>
     * 
     * @return The estimated savings amount for this time period, representing the potential cost reduction achieved
     *         through optimization recommendations.
     */
    public final Double savings() {
        return savings;
    }

    /**
     * <p>
     * The total spending amount for this time period.
     * </p>
     * 
     * @return The total spending amount for this time period.
     */
    public final Double spend() {
        return spend;
    }

    /**
     * <p>
     * The timestamp for this data point. The format depends on the granularity: YYYY-MM-DD for daily metrics, or
     * YYYY-MM for monthly metrics.
     * </p>
     * 
     * @return The timestamp for this data point. The format depends on the granularity: YYYY-MM-DD for daily metrics,
     *         or YYYY-MM for monthly metrics.
     */
    public final String timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(savings());
        hashCode = 31 * hashCode + Objects.hashCode(spend());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsByTime)) {
            return false;
        }
        MetricsByTime other = (MetricsByTime) obj;
        return Objects.equals(score(), other.score()) && Objects.equals(savings(), other.savings())
                && Objects.equals(spend(), other.spend()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricsByTime").add("Score", score()).add("Savings", savings()).add("Spend", spend())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        case "savings":
            return Optional.ofNullable(clazz.cast(savings()));
        case "spend":
            return Optional.ofNullable(clazz.cast(spend()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("score", SCORE_FIELD);
        map.put("savings", SAVINGS_FIELD);
        map.put("spend", SPEND_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricsByTime, T> g) {
        return obj -> g.apply((MetricsByTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricsByTime> {
        /**
         * <p>
         * The efficiency score for this time period. The score represents a measure of how effectively the cloud
         * resources are being optimized, with higher scores indicating better optimization performance.
         * </p>
         * 
         * @param score
         *        The efficiency score for this time period. The score represents a measure of how effectively the cloud
         *        resources are being optimized, with higher scores indicating better optimization performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);

        /**
         * <p>
         * The estimated savings amount for this time period, representing the potential cost reduction achieved through
         * optimization recommendations.
         * </p>
         * 
         * @param savings
         *        The estimated savings amount for this time period, representing the potential cost reduction achieved
         *        through optimization recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savings(Double savings);

        /**
         * <p>
         * The total spending amount for this time period.
         * </p>
         * 
         * @param spend
         *        The total spending amount for this time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spend(Double spend);

        /**
         * <p>
         * The timestamp for this data point. The format depends on the granularity: YYYY-MM-DD for daily metrics, or
         * YYYY-MM for monthly metrics.
         * </p>
         * 
         * @param timestamp
         *        The timestamp for this data point. The format depends on the granularity: YYYY-MM-DD for daily
         *        metrics, or YYYY-MM for monthly metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);
    }

    static final class BuilderImpl implements Builder {
        private Double score;

        private Double savings;

        private Double spend;

        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsByTime model) {
            score(model.score);
            savings(model.savings);
            spend(model.spend);
            timestamp(model.timestamp);
        }

        public final Double getScore() {
            return score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final Double getSavings() {
            return savings;
        }

        public final void setSavings(Double savings) {
            this.savings = savings;
        }

        @Override
        public final Builder savings(Double savings) {
            this.savings = savings;
            return this;
        }

        public final Double getSpend() {
            return spend;
        }

        public final void setSpend(Double spend) {
            this.spend = spend;
        }

        @Override
        public final Builder spend(Double spend) {
            this.spend = spend;
            return this;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public MetricsByTime build() {
            return new MetricsByTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
