/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines how rows will be sorted in the response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrderBy implements SdkPojo, Serializable, ToCopyableBuilder<OrderBy.Builder, OrderBy> {
    private static final SdkField<String> DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dimension").getter(getter(OrderBy::dimension)).setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimension").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("order")
            .getter(getter(OrderBy::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD, ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimension;

    private final String order;

    private OrderBy(BuilderImpl builder) {
        this.dimension = builder.dimension;
        this.order = builder.order;
    }

    /**
     * <p>
     * Sorts by dimension values.
     * </p>
     * 
     * @return Sorts by dimension values.
     */
    public final String dimension() {
        return dimension;
    }

    /**
     * <p>
     * The order that's used to sort the data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The order that's used to sort the data.
     * @see Order
     */
    public final Order order() {
        return Order.fromValue(order);
    }

    /**
     * <p>
     * The order that's used to sort the data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The order that's used to sort the data.
     * @see Order
     */
    public final String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimension());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy) obj;
        return Objects.equals(dimension(), other.dimension()) && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrderBy").add("Dimension", dimension()).add("Order", orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimension":
            return Optional.ofNullable(clazz.cast(dimension()));
        case "order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimension", DIMENSION_FIELD);
        map.put("order", ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrderBy, T> g) {
        return obj -> g.apply((OrderBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrderBy> {
        /**
         * <p>
         * Sorts by dimension values.
         * </p>
         * 
         * @param dimension
         *        Sorts by dimension values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimension(String dimension);

        /**
         * <p>
         * The order that's used to sort the data.
         * </p>
         * 
         * @param order
         *        The order that's used to sort the data.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder order(String order);

        /**
         * <p>
         * The order that's used to sort the data.
         * </p>
         * 
         * @param order
         *        The order that's used to sort the data.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder order(Order order);
    }

    static final class BuilderImpl implements Builder {
        private String dimension;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderBy model) {
            dimension(model.dimension);
            order(model.order);
        }

        public final String getDimension() {
            return dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getOrder() {
            return order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        @Override
        public OrderBy build() {
            return new OrderBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
