/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a date range for retrieving efficiency metrics. The start date is inclusive and the end date is exclusive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimePeriod implements SdkPojo, Serializable, ToCopyableBuilder<TimePeriod.Builder, TimePeriod> {
    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("start")
            .getter(getter(TimePeriod::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("end")
            .getter(getter(TimePeriod::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String start;

    private final String end;

    private TimePeriod(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The beginning of the time period (inclusive). Specify the date in ISO 8601 format, such as 2024-01-01.
     * </p>
     * 
     * @return The beginning of the time period (inclusive). Specify the date in ISO 8601 format, such as 2024-01-01.
     */
    public final String start() {
        return start;
    }

    /**
     * <p>
     * The end of the time period (exclusive). Specify the date in ISO 8601 format, such as 2024-12-31.
     * </p>
     * 
     * @return The end of the time period (exclusive). Specify the date in ISO 8601 format, such as 2024-12-31.
     */
    public final String end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimePeriod)) {
            return false;
        }
        TimePeriod other = (TimePeriod) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimePeriod").add("Start", start()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("start", START_FIELD);
        map.put("end", END_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimePeriod, T> g) {
        return obj -> g.apply((TimePeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimePeriod> {
        /**
         * <p>
         * The beginning of the time period (inclusive). Specify the date in ISO 8601 format, such as 2024-01-01.
         * </p>
         * 
         * @param start
         *        The beginning of the time period (inclusive). Specify the date in ISO 8601 format, such as 2024-01-01.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * <p>
         * The end of the time period (exclusive). Specify the date in ISO 8601 format, such as 2024-12-31.
         * </p>
         * 
         * @param end
         *        The end of the time period (exclusive). Specify the date in ISO 8601 format, such as 2024-12-31.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);
    }

    static final class BuilderImpl implements Builder {
        private String start;

        private String end;

        private BuilderImpl() {
        }

        private BuilderImpl(TimePeriod model) {
            start(model.start);
            end(model.end);
        }

        public final String getStart() {
            return start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final String getEnd() {
            return end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        @Override
        public TimePeriod build() {
            return new TimePeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
