/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePreferencesResponse extends CostOptimizationHubResponse implements
        ToCopyableBuilder<UpdatePreferencesResponse.Builder, UpdatePreferencesResponse> {
    private static final SdkField<String> SAVINGS_ESTIMATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsEstimationMode").getter(getter(UpdatePreferencesResponse::savingsEstimationModeAsString))
            .setter(setter(Builder::savingsEstimationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsEstimationMode").build())
            .build();

    private static final SdkField<String> MEMBER_ACCOUNT_DISCOUNT_VISIBILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("memberAccountDiscountVisibility")
            .getter(getter(UpdatePreferencesResponse::memberAccountDiscountVisibilityAsString))
            .setter(setter(Builder::memberAccountDiscountVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountDiscountVisibility")
                    .build()).build();

    private static final SdkField<PreferredCommitment> PREFERRED_COMMITMENT_FIELD = SdkField
            .<PreferredCommitment> builder(MarshallingType.SDK_POJO).memberName("preferredCommitment")
            .getter(getter(UpdatePreferencesResponse::preferredCommitment)).setter(setter(Builder::preferredCommitment))
            .constructor(PreferredCommitment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredCommitment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_ESTIMATION_MODE_FIELD,
            MEMBER_ACCOUNT_DISCOUNT_VISIBILITY_FIELD, PREFERRED_COMMITMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String savingsEstimationMode;

    private final String memberAccountDiscountVisibility;

    private final PreferredCommitment preferredCommitment;

    private UpdatePreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.savingsEstimationMode = builder.savingsEstimationMode;
        this.memberAccountDiscountVisibility = builder.memberAccountDiscountVisibility;
        this.preferredCommitment = builder.preferredCommitment;
    }

    /**
     * <p>
     * Shows the status of the "savings estimation mode" preference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #savingsEstimationMode} will return {@link SavingsEstimationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #savingsEstimationModeAsString}.
     * </p>
     * 
     * @return Shows the status of the "savings estimation mode" preference.
     * @see SavingsEstimationMode
     */
    public final SavingsEstimationMode savingsEstimationMode() {
        return SavingsEstimationMode.fromValue(savingsEstimationMode);
    }

    /**
     * <p>
     * Shows the status of the "savings estimation mode" preference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #savingsEstimationMode} will return {@link SavingsEstimationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #savingsEstimationModeAsString}.
     * </p>
     * 
     * @return Shows the status of the "savings estimation mode" preference.
     * @see SavingsEstimationMode
     */
    public final String savingsEstimationModeAsString() {
        return savingsEstimationMode;
    }

    /**
     * <p>
     * Shows the status of the "member account discount visibility" preference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #memberAccountDiscountVisibility} will return
     * {@link MemberAccountDiscountVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #memberAccountDiscountVisibilityAsString}.
     * </p>
     * 
     * @return Shows the status of the "member account discount visibility" preference.
     * @see MemberAccountDiscountVisibility
     */
    public final MemberAccountDiscountVisibility memberAccountDiscountVisibility() {
        return MemberAccountDiscountVisibility.fromValue(memberAccountDiscountVisibility);
    }

    /**
     * <p>
     * Shows the status of the "member account discount visibility" preference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #memberAccountDiscountVisibility} will return
     * {@link MemberAccountDiscountVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #memberAccountDiscountVisibilityAsString}.
     * </p>
     * 
     * @return Shows the status of the "member account discount visibility" preference.
     * @see MemberAccountDiscountVisibility
     */
    public final String memberAccountDiscountVisibilityAsString() {
        return memberAccountDiscountVisibility;
    }

    /**
     * <p>
     * Shows the updated preferences for how Reserved Instances and Savings Plans cost-saving opportunities are
     * prioritized in terms of payment option and term length.
     * </p>
     * 
     * @return Shows the updated preferences for how Reserved Instances and Savings Plans cost-saving opportunities are
     *         prioritized in terms of payment option and term length.
     */
    public final PreferredCommitment preferredCommitment() {
        return preferredCommitment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsEstimationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountDiscountVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preferredCommitment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePreferencesResponse)) {
            return false;
        }
        UpdatePreferencesResponse other = (UpdatePreferencesResponse) obj;
        return Objects.equals(savingsEstimationModeAsString(), other.savingsEstimationModeAsString())
                && Objects.equals(memberAccountDiscountVisibilityAsString(), other.memberAccountDiscountVisibilityAsString())
                && Objects.equals(preferredCommitment(), other.preferredCommitment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePreferencesResponse").add("SavingsEstimationMode", savingsEstimationModeAsString())
                .add("MemberAccountDiscountVisibility", memberAccountDiscountVisibilityAsString())
                .add("PreferredCommitment", preferredCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsEstimationMode":
            return Optional.ofNullable(clazz.cast(savingsEstimationModeAsString()));
        case "memberAccountDiscountVisibility":
            return Optional.ofNullable(clazz.cast(memberAccountDiscountVisibilityAsString()));
        case "preferredCommitment":
            return Optional.ofNullable(clazz.cast(preferredCommitment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("savingsEstimationMode", SAVINGS_ESTIMATION_MODE_FIELD);
        map.put("memberAccountDiscountVisibility", MEMBER_ACCOUNT_DISCOUNT_VISIBILITY_FIELD);
        map.put("preferredCommitment", PREFERRED_COMMITMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePreferencesResponse, T> g) {
        return obj -> g.apply((UpdatePreferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostOptimizationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePreferencesResponse> {
        /**
         * <p>
         * Shows the status of the "savings estimation mode" preference.
         * </p>
         * 
         * @param savingsEstimationMode
         *        Shows the status of the "savings estimation mode" preference.
         * @see SavingsEstimationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsEstimationMode
         */
        Builder savingsEstimationMode(String savingsEstimationMode);

        /**
         * <p>
         * Shows the status of the "savings estimation mode" preference.
         * </p>
         * 
         * @param savingsEstimationMode
         *        Shows the status of the "savings estimation mode" preference.
         * @see SavingsEstimationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsEstimationMode
         */
        Builder savingsEstimationMode(SavingsEstimationMode savingsEstimationMode);

        /**
         * <p>
         * Shows the status of the "member account discount visibility" preference.
         * </p>
         * 
         * @param memberAccountDiscountVisibility
         *        Shows the status of the "member account discount visibility" preference.
         * @see MemberAccountDiscountVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountDiscountVisibility
         */
        Builder memberAccountDiscountVisibility(String memberAccountDiscountVisibility);

        /**
         * <p>
         * Shows the status of the "member account discount visibility" preference.
         * </p>
         * 
         * @param memberAccountDiscountVisibility
         *        Shows the status of the "member account discount visibility" preference.
         * @see MemberAccountDiscountVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberAccountDiscountVisibility
         */
        Builder memberAccountDiscountVisibility(MemberAccountDiscountVisibility memberAccountDiscountVisibility);

        /**
         * <p>
         * Shows the updated preferences for how Reserved Instances and Savings Plans cost-saving opportunities are
         * prioritized in terms of payment option and term length.
         * </p>
         * 
         * @param preferredCommitment
         *        Shows the updated preferences for how Reserved Instances and Savings Plans cost-saving opportunities
         *        are prioritized in terms of payment option and term length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredCommitment(PreferredCommitment preferredCommitment);

        /**
         * <p>
         * Shows the updated preferences for how Reserved Instances and Savings Plans cost-saving opportunities are
         * prioritized in terms of payment option and term length.
         * </p>
         * This is a convenience method that creates an instance of the {@link PreferredCommitment.Builder} avoiding the
         * need to create one manually via {@link PreferredCommitment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreferredCommitment.Builder#build()} is called immediately and
         * its result is passed to {@link #preferredCommitment(PreferredCommitment)}.
         * 
         * @param preferredCommitment
         *        a consumer that will call methods on {@link PreferredCommitment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preferredCommitment(PreferredCommitment)
         */
        default Builder preferredCommitment(Consumer<PreferredCommitment.Builder> preferredCommitment) {
            return preferredCommitment(PreferredCommitment.builder().applyMutation(preferredCommitment).build());
        }
    }

    static final class BuilderImpl extends CostOptimizationHubResponse.BuilderImpl implements Builder {
        private String savingsEstimationMode;

        private String memberAccountDiscountVisibility;

        private PreferredCommitment preferredCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePreferencesResponse model) {
            super(model);
            savingsEstimationMode(model.savingsEstimationMode);
            memberAccountDiscountVisibility(model.memberAccountDiscountVisibility);
            preferredCommitment(model.preferredCommitment);
        }

        public final String getSavingsEstimationMode() {
            return savingsEstimationMode;
        }

        public final void setSavingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
        }

        @Override
        public final Builder savingsEstimationMode(String savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
            return this;
        }

        @Override
        public final Builder savingsEstimationMode(SavingsEstimationMode savingsEstimationMode) {
            this.savingsEstimationMode(savingsEstimationMode == null ? null : savingsEstimationMode.toString());
            return this;
        }

        public final String getMemberAccountDiscountVisibility() {
            return memberAccountDiscountVisibility;
        }

        public final void setMemberAccountDiscountVisibility(String memberAccountDiscountVisibility) {
            this.memberAccountDiscountVisibility = memberAccountDiscountVisibility;
        }

        @Override
        public final Builder memberAccountDiscountVisibility(String memberAccountDiscountVisibility) {
            this.memberAccountDiscountVisibility = memberAccountDiscountVisibility;
            return this;
        }

        @Override
        public final Builder memberAccountDiscountVisibility(MemberAccountDiscountVisibility memberAccountDiscountVisibility) {
            this.memberAccountDiscountVisibility(memberAccountDiscountVisibility == null ? null : memberAccountDiscountVisibility
                    .toString());
            return this;
        }

        public final PreferredCommitment.Builder getPreferredCommitment() {
            return preferredCommitment != null ? preferredCommitment.toBuilder() : null;
        }

        public final void setPreferredCommitment(PreferredCommitment.BuilderImpl preferredCommitment) {
            this.preferredCommitment = preferredCommitment != null ? preferredCommitment.build() : null;
        }

        @Override
        public final Builder preferredCommitment(PreferredCommitment preferredCommitment) {
            this.preferredCommitment = preferredCommitment;
            return this;
        }

        @Override
        public UpdatePreferencesResponse build() {
            return new UpdatePreferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
