/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Usage implements SdkPojo, Serializable, ToCopyableBuilder<Usage.Builder, Usage> {
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(Usage::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<Double> USAGE_AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("usageAmount").getter(getter(Usage::usageAmount)).setter(setter(Builder::usageAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAmount").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(Usage::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productCode").getter(getter(Usage::productCode)).setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCode").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(Usage::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_TYPE_FIELD,
            USAGE_AMOUNT_FIELD, OPERATION_FIELD, PRODUCT_CODE_FIELD, UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String usageType;

    private final Double usageAmount;

    private final String operation;

    private final String productCode;

    private final String unit;

    private Usage(BuilderImpl builder) {
        this.usageType = builder.usageType;
        this.usageAmount = builder.usageAmount;
        this.operation = builder.operation;
        this.productCode = builder.productCode;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The usage type.
     * </p>
     * 
     * @return The usage type.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The usage amount.
     * </p>
     * 
     * @return The usage amount.
     */
    public final Double usageAmount() {
        return usageAmount;
    }

    /**
     * <p>
     * The operation value.
     * </p>
     * 
     * @return The operation value.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * The product code.
     * </p>
     * 
     * @return The product code.
     */
    public final String productCode() {
        return productCode;
    }

    /**
     * <p>
     * The usage unit.
     * </p>
     * 
     * @return The usage unit.
     */
    public final String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(usageAmount());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Usage)) {
            return false;
        }
        Usage other = (Usage) obj;
        return Objects.equals(usageType(), other.usageType()) && Objects.equals(usageAmount(), other.usageAmount())
                && Objects.equals(operation(), other.operation()) && Objects.equals(productCode(), other.productCode())
                && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Usage").add("UsageType", usageType()).add("UsageAmount", usageAmount())
                .add("Operation", operation()).add("ProductCode", productCode()).add("Unit", unit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "usageAmount":
            return Optional.ofNullable(clazz.cast(usageAmount()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "productCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("usageAmount", USAGE_AMOUNT_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("productCode", PRODUCT_CODE_FIELD);
        map.put("unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Usage, T> g) {
        return obj -> g.apply((Usage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Usage> {
        /**
         * <p>
         * The usage type.
         * </p>
         * 
         * @param usageType
         *        The usage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The usage amount.
         * </p>
         * 
         * @param usageAmount
         *        The usage amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAmount(Double usageAmount);

        /**
         * <p>
         * The operation value.
         * </p>
         * 
         * @param operation
         *        The operation value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The product code.
         * </p>
         * 
         * @param productCode
         *        The product code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        /**
         * <p>
         * The usage unit.
         * </p>
         * 
         * @param unit
         *        The usage unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private String usageType;

        private Double usageAmount;

        private String operation;

        private String productCode;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Usage model) {
            usageType(model.usageType);
            usageAmount(model.usageAmount);
            operation(model.operation);
            productCode(model.productCode);
            unit(model.unit);
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final Double getUsageAmount() {
            return usageAmount;
        }

        public final void setUsageAmount(Double usageAmount) {
            this.usageAmount = usageAmount;
        }

        @Override
        public final Builder usageAmount(Double usageAmount) {
            this.usageAmount = usageAmount;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getProductCode() {
            return productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public Usage build() {
            return new Usage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
