/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GranularityType {
    DAILY("Daily"),
    MONTHLY("Monthly"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GranularityType> VALUE_MAP;
    private final String value;

    private GranularityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GranularityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GranularityType> knownValues() {
        EnumSet<GranularityType> knownValues = EnumSet.allOf(GranularityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GranularityType.class, GranularityType::toString);
    }
}

