/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;

public class HttpRequest {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final int BUFFER_INT_SIZE = 4;
    private final String method;
    private String encodedPath;
    private List<HttpHeader> headers;
    private HttpRequestBodyStream bodyStream;

    public HttpRequest(String method, String encodedPath) {
        this(method, encodedPath, new HttpHeader[0], null);
    }

    public HttpRequest(String method, String encodedPath, HttpHeader[] headers, HttpRequestBodyStream bodyStream) {
        if (headers == null) {
            throw new IllegalArgumentException("Headers can be empty, but can't be null");
        }
        this.method = method;
        this.encodedPath = encodedPath;
        this.headers = Arrays.asList(headers);
        this.bodyStream = bodyStream;
    }

    HttpRequest(ByteBuffer marshalledRequest, HttpRequestBodyStream bodyStream) {
        if (marshalledRequest.remaining() < 8) {
            throw new CrtRuntimeException("Invalid marshalled request object.");
        }
        int methodLength = marshalledRequest.getInt();
        byte[] methodBlob = new byte[methodLength];
        marshalledRequest.get(methodBlob);
        this.method = new String(methodBlob, UTF8);
        if (marshalledRequest.remaining() < 4) {
            throw new CrtRuntimeException("Invalid marshalled request object.");
        }
        int pathLength = marshalledRequest.getInt();
        byte[] pathBlob = new byte[pathLength];
        marshalledRequest.get(pathBlob);
        this.encodedPath = new String(pathBlob, UTF8);
        this.headers = HttpHeader.loadHeadersListFromMarshalledHeadersBlob(marshalledRequest);
        this.bodyStream = bodyStream;
    }

    public String getMethod() {
        return this.method;
    }

    public String getEncodedPath() {
        return this.encodedPath;
    }

    public void setEncodedPath(String encodedPath) {
        this.encodedPath = encodedPath;
    }

    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public HttpHeader[] getHeadersAsArray() {
        return this.headers.toArray(new HttpHeader[0]);
    }

    public void addHeader(HttpHeader header) {
        this.headers.add(header);
    }

    public void addHeader(String headerName, String headerValue) {
        this.headers.add(new HttpHeader(headerName, headerValue));
    }

    public void addHeaders(HttpHeader[] headers) {
        Collections.addAll(this.headers, headers);
    }

    public HttpRequestBodyStream getBodyStream() {
        return this.bodyStream;
    }

    public byte[] marshalForJni() {
        int size = 0;
        size += 4 + this.method.length();
        size += 4 + this.encodedPath.length();
        for (HttpHeader header : this.headers) {
            if (header.getNameBytes().length <= 0) continue;
            size += header.getNameBytes().length + header.getValueBytes().length + 8;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putInt(this.method.length());
        buffer.put(this.method.getBytes(UTF8));
        buffer.putInt(this.encodedPath.length());
        buffer.put(this.encodedPath.getBytes(UTF8));
        for (HttpHeader header : this.headers) {
            if (header.getNameBytes().length <= 0) continue;
            buffer.putInt(header.getNameBytes().length);
            buffer.put(header.getNameBytes());
            buffer.putInt(header.getValueBytes().length);
            buffer.put(header.getValueBytes());
        }
        return buffer.array();
    }
}

